//-----------------------------------------------------------
// Co-op rules addition
//
//  * No KO's allowed
//  * No kills allowed
//  * Override number of spawns?
//	*   Number
//  * No timelimit
//  * GameOver if any thief is killed
//-----------------------------------------------------------
class ThMenuServerGameOptionsCWCoOp expands ThMenuServerGameOptionsCW;

var UMenuLabelControl CoopLabel;

var UWindowCheckbox CoopNoKOsCheck;
var localized string CoopNoKOsText;
var localized string CoopNoKOsHelp;

var UWindowCheckbox CoopNoKillsCheck;
var localized string CoopNoKillsText;
var localized string CoopNoKillsHelp;

var UWindowCheckbox CoopNoTimeLimitCheck;
var localized string CoopNoTimeLimitText;
var localized string CoopNoTimeLimitHelp;

var UWindowCheckbox CoopGameOverOnKillCheck;
var localized string CoopGameOverOnKillText;
var localized string CoopGameOverOnKillHelp;

var UWindowCheckbox CoopDontEndWhenGuardsDeadCheck;
var localized string CoopDontEndWhenGuardsDeadText;
var localized string CoopDontEndWhenGuardsDeadHelp;

var UWindowCheckbox CoopOverrideSpawnsCheck;
var localized string CoopOverrideSpawnsText;
var localized string CoopOverrideSpawnsHelp;

var UWindowEditControl CoopNumberOfSpawns;
var localized string CoopNumberOfSpawnsText;
var localized string CoopNumberOfSpawnsHelp;

var UWindowCheckbox CoopAllToExitCheck;
var localized string CoopAllToExitText;
var localized string CoopAllToExitHelp;

function Created()
{
	local int S;
	local int ControlWidth, ControlLeft, ControlRight;
	local int CenterWidth, CenterPos, ButtonWidth, ButtonLeft;

	Super.Created();

	// hide guard specific options

	BalanceTeamsCheck.HideWindow();
	GuardsStartingLoot.HideWindow();
	MaxOrderedBotsSlider.HideWindow();
	SupplyChestCheck.HideWindow();

	ControlWidth = WinWidth/1.3;
	ControlLeft = (WinWidth/2 - ControlWidth)/2;
	ControlRight = WinWidth/2 + ControlLeft;

	CenterWidth = (WinWidth/4)*3;
	CenterPos = (WinWidth - CenterWidth)/2;

	ButtonWidth = WinWidth - 140;
	ButtonLeft = WinWidth - ButtonWidth - 40;

	ControlOffset += 45;


	CoopLabel = UMenuLabelControl(CreateControl(class'UMenuLabelControl', ControlLeft, ControlOffset, ControlWidth, 1));
	CoopLabel.SetText("- Co-op options -");
	CoopLabel.SetHelpText("Special options for the co-op gametype");
	//CoopLabel.SetFont(F_Bold);	// if I set this it mucks up the alignment of the checkboxes below!?? WTF??
	CoopLabel.Align = TA_Center;
	ControlOffset += 25;

	CoopNoKOsCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', ControlLeft, ControlOffset, ControlWidth, 1));
	CoopNoKOsCheck.SetText(CoopNoKOsText);
	CoopNoKOsCheck.SetHelpText(CoopNoKOsHelp);
	CoopNoKOsCheck.SetFont(F_Normal);
	CoopNoKOsCheck.bChecked = class'ThieveryMod.ThieveryGameSettings'.default.bCoopNoKOs;
	CoopNoKOsCheck.Align = TA_Right;
	ControlOffset += 25;

	CoopNoKillsCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', ControlLeft, ControlOffset, ControlWidth, 1));
	CoopNoKillsCheck.SetText(CoopNoKillsText);
	CoopNoKillsCheck.SetHelpText(CoopNoKillsHelp);
	CoopNoKillsCheck.SetFont(F_Normal);
	CoopNoKillsCheck.bChecked = class'ThieveryMod.ThieveryGameSettings'.default.bCoopNoKills;
	CoopNoKillsCheck.Align = TA_Right;
	ControlOffset += 25;

	CoopNoTimeLimitCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', ControlLeft, ControlOffset, ControlWidth, 1));
	CoopNoTimeLimitCheck.SetText(CoopNoTimeLimitText);
	CoopNoTimeLimitCheck.SetHelpText(CoopNoTimeLimitHelp);
	CoopNoTimeLimitCheck.SetFont(F_Normal);
	CoopNoTimeLimitCheck.bChecked = class'ThieveryMod.ThieveryGameSettings'.default.bCoopNoTimeLimit;
	CoopNoTimeLimitCheck.Align = TA_Right;
	ControlOffset += 25;


	CoopGameOverOnKillCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', ControlLeft, ControlOffset, ControlWidth, 1));
	CoopGameOverOnKillCheck.SetText(CoopGameOverOnKillText);
	CoopGameOverOnKillCheck.SetHelpText(CoopGameOverOnKillHelp);
	CoopGameOverOnKillCheck.SetFont(F_Normal);
	CoopGameOverOnKillCheck.bChecked = class'ThieveryMod.ThieveryGameSettings'.default.bCoopGameOverOnKill;
	CoopGameOverOnKillCheck.Align = TA_Right;
	ControlOffset += 25;

	CoopDontEndWhenGuardsDeadCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', ControlLeft, ControlOffset, ControlWidth, 1));
	CoopDontEndWhenGuardsDeadCheck.SetText(CoopDontEndWhenGuardsDeadText);
	CoopDontEndWhenGuardsDeadCheck.SetHelpText(CoopDontEndWhenGuardsDeadHelp);
	CoopDontEndWhenGuardsDeadCheck.SetFont(F_Normal);
	CoopDontEndWhenGuardsDeadCheck.bChecked = class'ThieveryMod.ThieveryGameSettings'.default.bCoopDontEndWhenGuardsDead;
	CoopDontEndWhenGuardsDeadCheck.Align = TA_Right;
	ControlOffset += 35;

	CoopOverrideSpawnsCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', ControlLeft, ControlOffset, ControlWidth, 1));
	CoopOverrideSpawnsCheck.SetText(CoopOverrideSpawnsText);
	CoopOverrideSpawnsCheck.SetHelpText(CoopOverrideSpawnsHelp);
	CoopOverrideSpawnsCheck.SetFont(F_Normal);
	CoopOverrideSpawnsCheck.bChecked = class'ThieveryMod.ThieveryGameSettings'.default.bCoopOverrideSpawns;
	CoopOverrideSpawnsCheck.Align = TA_Right;
	ControlOffset += 25;

	CoopNumberOfSpawns = UWindowEditControl(CreateControl(class'UWindowEditControl', ControlLeft, ControlOffset, ControlWidth, 1));
	CoopNumberOfSpawns.SetText(CoopNumberOfSpawnsText);
	CoopNumberOfSpawns.SetHelpText(CoopNumberOfSpawnsHelp);
	CoopNumberOfSpawns.SetFont(F_Normal);
	CoopNumberOfSpawns.SetNumericOnly(True);
	CoopNumberOfSpawns.SetMaxLength(3);
	CoopNumberOfSpawns.Align = TA_Right;

	ControlOffset += 35;


	CoopAllToExitCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', ControlLeft, ControlOffset, ControlWidth, 1));
	CoopAllToExitCheck.SetText(CoopAllToExitText);
	CoopAllToExitCheck.SetHelpText(CoopAllToExitHelp);
	CoopAllToExitCheck.SetFont(F_Normal);
	CoopAllToExitCheck.bChecked = class'ThieveryMod.ThieveryGameSettings'.default.bCoopAllToExit;
	CoopAllToExitCheck.Align = TA_Right;
}

function BeforePaint(Canvas C, float X, float Y)
{
	local int ControlWidth, ControlLeft, ControlRight;
	local int CenterWidth, CenterPos, ButtonWidth, ButtonLeft;

	Super.BeforePaint(C, X, Y);

	ControlWidth = WinWidth/1.3;
	ControlLeft = (WinWidth/2 - ControlWidth)/2;
	ControlRight = WinWidth/2 + ControlLeft;

	CenterWidth = (WinWidth/4)*3;
	CenterPos = (WinWidth - CenterWidth)/2;

	CoopLabel.SetSize(ControlWidth, 1);
	CoopLabel.WinLeft = CenterPos;

	CoopNoKOsCheck.SetSize(ControlWidth, 1);
	CoopNoKOsCheck.WinLeft = CenterPos;

	CoopNoKillsCheck.SetSize(ControlWidth, 1);
	CoopNoKillsCheck.WinLeft = CenterPos;

	CoopNoTimeLimitCheck.SetSize(ControlWidth, 1);
	CoopNoTimeLimitCheck.WinLeft = CenterPos;
	CoopGameOverOnKillCheck.SetSize(ControlWidth, 1);
	CoopGameOverOnKillCheck.WinLeft = CenterPos;
	CoopOverrideSpawnsCheck.SetSize(ControlWidth, 1);
	CoopOverrideSpawnsCheck.WinLeft = CenterPos;
	CoopAllToExitCheck.SetSize(ControlWidth, 1);
	CoopAllToExitCheck.WinLeft = CenterPos;

	CoopNumberOfSpawns.SetSize(ControlWidth, 1);
	CoopNumberOfSpawns.WinLeft = CenterPos;
	CoopNumberOfSpawns.EditBoxWidth = 33;

	CoopDontEndWhenGuardsDeadCheck.SetSize(ControlWidth, 1);
	CoopDontEndWhenGuardsDeadCheck.WinLeft = CenterPos;
}

function Notify(UWindowDialogControl C, byte E)
{
	if (!Initialized)
		return;

	Super.Notify(C, E);

	//log("notify called");

	switch(E)
	{
	case DE_Change:
		switch(C)
		{
			case CoopNoKOsCheck:
				CoopKOChanged();
				break;
			case CoopNoKillsCheck:
				CoopKillsChanged();
				break;
			case CoopNoTimeLimitCheck:
				CoopTimeLimitChanged();
				break;
			case CoopGameOverOnKillCheck:
				CoopGameOverOnKillChanged();
				break;
			case CoopOverrideSpawnsCheck:
				CoopOverrideSpawnsChanged();
				break;
			case CoopNumberOfSpawns:
				CoopNumberOfSpawnsChanged();
				break;
			case CoopDontEndWhenGuardsDeadCheck:
				CoopDontEndWhenGuardsDeadChanged();
				break;
			case CoopAllToExitCheck:
				CoopAllToExitChanged();
				break;
		}
	}
}

function CoopKOChanged() {
	class'ThieveryMod.ThieveryGameSettings'.default.bCoopNoKOs=CoopNoKOsCheck.bChecked;
}
function CoopKillsChanged() {
	class'ThieveryMod.ThieveryGameSettings'.default.bCoopNoKills=CoopNoKillsCheck.bChecked;
}
function CoopTimeLimitChanged() {
	class'ThieveryMod.ThieveryGameSettings'.default.bCoopNoTimeLimit=CoopNoTimeLimitCheck.bChecked;
}
function CoopGameOverOnKillChanged() {
	class'ThieveryMod.ThieveryGameSettings'.default.bCoopGameOverOnKill=CoopGameOverOnKillCheck.bChecked;
}
function CoopOverrideSpawnsChanged() {
	class'ThieveryMod.ThieveryGameSettings'.default.bCoopOverrideSpawns=CoopOverrideSpawnsCheck.bChecked;
}
function CoopNumberOfSpawnsChanged() {
	class'ThieveryMod.ThieveryGameSettings'.default.nCoopNumberOfSpawns=int(CoopNumberOfSpawns.GetValue());
}
function CoopDontEndWhenGuardsDeadChanged() {
	class'ThieveryMod.ThieveryGameSettings'.default.bCoopDontEndWhenGuardsDead=CoopDontEndWhenGuardsDeadCheck.bChecked;
}
function CoopAllToExitChanged() {
class'ThieveryMod.ThieveryGameSettings'.default.bCoopAllToExit=CoopAllToExitCheck.bChecked;
}

function LoadCurrentValues() {
	Super.LoadCurrentValues();
	CoopNoKOsCheck.bChecked = class'ThieveryMod.ThieveryGameSettings'.default.bCoopNoKOs;
	CoopNoKillsCheck.bChecked=class'ThieveryMod.ThieveryGameSettings'.default.bCoopNoKills;
	CoopNoTimeLimitCheck.bChecked = class'ThieveryMod.ThieveryGameSettings'.default.bCoopNoTimeLimit;
	CoopGameOverOnKillCheck.bChecked=class'ThieveryMod.ThieveryGameSettings'.default.bCoopGameOverOnKill;
	CoopOverrideSpawnsCheck.bChecked=class'ThieveryMod.ThieveryGameSettings'.default.bCoopOverrideSpawns;
	CoopNumberOfSpawns.SetValue(string(class'ThieveryMod.ThieveryGameSettings'.default.nCoopNumberOfSpawns));
	CoopDontEndWhenGuardsDeadCheck.bChecked=class'ThieveryMod.ThieveryGameSettings'.default.bCoopDontEndWhenGuardsDead;
	CoopAllToExitCheck.bChecked=class'ThieveryMod.ThieveryGameSettings'.default.bCoopAllToExit;
}

defaultproperties
{
     CoopNoKOsText="No KO's allowed"
     CoopNoKOsHelp="If a player KO's anyone, the thieves lose."
     CoopNoKillsText="No kills allowed"
     CoopNoKillsHelp="If a player kills anyone, the thieves lose."
     CoopNoTimeLimitText="No timelimit"
     CoopNoTimeLimitHelp="Unlimited time to play the map."
     CoopGameOverOnKillText="Game over if any thief dies"
     CoopGameOverOnKillHelp="If any thief is killed, the thieves lose."
     CoopDontEndWhenGuardsDeadText="Don't end when all guards dead"
     CoopDontEndWhenGuardsDeadHelp="Game will continue even if all the guards are killed."
     CoopOverrideSpawnsText="Override No. of spawns"
     CoopOverrideSpawnsHelp="Choose the number of thief spawns"
     CoopNumberOfSpawnsText="Number of spawns"
     CoopNumberOfSpawnsHelp="How many lives the thieves get."
     CoopAllToExitText="All thieves to exit"
     CoopAllToExitHelp="All thieves must get to the exit to win"
}
