//-----------------------------------------------------------
//
//-----------------------------------------------------------
class ThMenuServerGameOptionsCWTM expands ThMenuServerGameOptionsCW;

var UMenuLabelControl TMLabel;

var UWindowCheckbox TMShockCheck;
var localized string TMShockText;
var localized string TMShockHelp;

var UWindowCheckbox TMSpeedCheck;
var localized string TMSpeedText;
var localized string TMSpeedHelp;

function Created()
{
	local int S;
	local int ControlWidth, ControlLeft, ControlRight;
	local int CenterWidth, CenterPos, ButtonWidth, ButtonLeft;

	Super.Created();

	// hide guard specific options

	BalanceTeamsCheck.HideWindow();
	GuardsStartingLoot.HideWindow();
	MaxOrderedBotsSlider.HideWindow();
	SupplyChestCheck.HideWindow();

	ControlWidth = WinWidth/1.3;
	ControlLeft = (WinWidth/2 - ControlWidth)/2;
	ControlRight = WinWidth/2 + ControlLeft;

	CenterWidth = (WinWidth/4)*3;
	CenterPos = (WinWidth - CenterWidth)/2;

	ButtonWidth = WinWidth - 140;
	ButtonLeft = WinWidth - ButtonWidth - 40;

	ControlOffset += 45;


	TMLabel = UMenuLabelControl(CreateControl(class'UMenuLabelControl', ControlLeft, ControlOffset, ControlWidth, 1));
	TMLabel.SetText("- Thiefmatch Options -");
	TMLabel.SetHelpText("Special options for ThiefMatch");
	//TMLabel.SetFont(F_Bold);	// if I set this it mucks up the alignment of the checkboxes below!?? WTF??
	TMLabel.Align = TA_Center;
	ControlOffset += 25;

	TMShockCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', ControlLeft, ControlOffset, ControlWidth, 1));
	TMShockCheck.SetText(TMShockText);
	TMShockCheck.SetHelpText(TMShockHelp);
	TMShockCheck.SetFont(F_Normal);
	TMShockCheck.bChecked = class'ThieveryMod.ThieveryGameSettings'.default.bTMShock;
	TMShockCheck.Align = TA_Right;
	ControlOffset += 25;

	TMSpeedCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', ControlLeft, ControlOffset, ControlWidth, 1));
	TMSpeedCheck.SetText(TMSpeedText);
	TMSpeedCheck.SetHelpText(TMSpeedHelp);
	TMSpeedCheck.SetFont(F_Normal);
	TMSpeedCheck.bChecked = class'ThieveryMod.ThieveryGameSettings'.default.bTMSpeed;
	TMSpeedCheck.Align = TA_Right;
	ControlOffset += 25;
}

function BeforePaint(Canvas C, float X, float Y)
{
	local int ControlWidth, ControlLeft, ControlRight;
	local int CenterWidth, CenterPos, ButtonWidth, ButtonLeft;

	Super.BeforePaint(C, X, Y);

	ControlWidth = WinWidth/1.3;
	ControlLeft = (WinWidth/2 - ControlWidth)/2;
	ControlRight = WinWidth/2 + ControlLeft;

	CenterWidth = (WinWidth/4)*3;
	CenterPos = (WinWidth - CenterWidth)/2;

	TMLabel.SetSize(ControlWidth, 1);
	TMLabel.WinLeft = CenterPos;

	TMShockCheck.SetSize(ControlWidth, 1);
	TMShockCheck.WinLeft = CenterPos;

	TMSpeedCheck.SetSize(ControlWidth, 1);
	TMSpeedCheck.WinLeft = CenterPos;
}

function Notify(UWindowDialogControl C, byte E)
{
	if (!Initialized)
		return;

	Super.Notify(C, E);

	//log("notify called");

	switch(E)
	{
	case DE_Change:
		switch(C)
		{
			case TMShockCheck:
				TMShockChanged();
				break;
			case TMSpeedCheck:
				TMSpeedChanged();
				break;
		}
	}
}

function TMShockChanged() {
	class'ThieveryMod.ThieveryGameSettings'.default.bTMShock=TMShockCheck.bChecked;
}
function TMSpeedChanged() {
	class'ThieveryMod.ThieveryGameSettings'.default.bTMSpeed=TMSpeedCheck.bChecked;
}

function LoadCurrentValues() {
	Super.LoadCurrentValues();
	TMSpeedCheck.bChecked = class'ThieveryMod.ThieveryGameSettings'.default.bTMShock;
	TMSpeedCheck.bChecked=class'ThieveryMod.ThieveryGameSettings'.default.bTMSpeed;
}

defaultproperties
{
     TMShockText="Give shock rifles"
     TMShockHelp="All players start with an infinite ammo shock rifle"
     TMSpeedText="Give speed potions"
     TMSpeedHelp="Players start with 10 speed potions"
}
