// ============================================================
// ThMenu.ThMultiplayerMenu: put your comment here

// Created by UClasses - (C) 2000 by meltdown@thirdtower.com
// ============================================================

class ThMultiplayerMenu expands UWindowPulldownMenu;

var UWindowPulldownMenuItem Start, Browser, LAN, Disconnect, Reconnect, OpenLocation;
var UBrowserMainWindow BrowserWindow;

var localized string StartName;
var localized string StartHelp;
var localized string BrowserName;
var localized string BrowserHelp;
var localized string LANName;
var localized string LANHelp;
var localized string OpenLocationName;
var localized string OpenLocationHelp;
var localized string DisconnectName;
var localized string DisconnectHelp;
var localized string ReconnectName;
var localized string ReconnectHelp;

var config string UBrowserClassName;
var config string StartGameClassName;

var UWindowMessageBox SuggestPlayerSetup, SuggestNetspeed;
var bool bOpenLocation;
var bool bOpenLAN;

function Created()
{
	Super.Created();

	Browser = AddMenuItem(BrowserName, None);
	Start = AddMenuItem(StartName, None);
	LAN = AddMenuItem(LanName, None);
	OpenLocation = AddMenuItem(OpenLocationName, None);
	AddMenuItem("-", None);
	Disconnect = AddMenuItem(DisconnectName, None);
	Reconnect = AddMenuItem(ReconnectName, None);
}

function WindowShown()
{
	Super.WindowShown();

	if(GetLevel().NetMode == NM_Client)
	{
		Disconnect.bDisabled = False;
		Reconnect.bDisabled = False;
	}
	else
	{
		Disconnect.bDisabled = True;
		Reconnect.bDisabled = GetLevel() != GetEntryLevel();
	}
}

function ResolutionChanged(float W, float H)
{
	if(BrowserWindow != None)
		BrowserWindow.ResolutionChanged(W, H);
	Super.ResolutionChanged(W, H);
}

function NotifyQuitUnreal()
{
	if(BrowserWindow != None && !BrowserWindow.bWindowVisible)
		BrowserWindow.NotifyQuitUnreal();
	Super.NotifyQuitUnreal();
}

function NotifyBeforeLevelChange()
{
	if(BrowserWindow != None && !BrowserWindow.bWindowVisible)
		BrowserWindow.NotifyBeforeLevelChange();
	Super.NotifyBeforeLevelChange();
}

function NotifyAfterLevelChange()
{
	if(BrowserWindow != None && !BrowserWindow.bWindowVisible)
		BrowserWindow.NotifyAfterLevelChange();
	Super.NotifyAfterLevelChange();
}

function Select(UWindowPulldownMenuItem I)
{
	switch(I)
	{
	case Start:
		ThMenuBar(GetMenuBar()).SetHelp(StartHelp);
		break;
	case Browser:
		ThMenuBar(GetMenuBar()).SetHelp(BrowserHelp);
		break;
	case LAN:
		ThMenuBar(GetMenuBar()).SetHelp(LANHelp);
		break;
	case OpenLocation:
		ThMenuBar(GetMenuBar()).SetHelp(OpenLocationHelp);
		break;
	case Disconnect:
		ThMenuBar(GetMenuBar()).SetHelp(DisconnectHelp);
		break;
	case Reconnect:
		ThMenuBar(GetMenuBar()).SetHelp(ReconnectHelp);
		break;
	}

	Super.Select(I);
}

function ExecuteItem(UWindowPulldownMenuItem I)
{
	local class<UMenuStartGameWindow> StartGameClass;

	switch(I)
	{
	case Start:
		// Create start network game dialog.
		StartGameClass = class<UMenuStartGameWindow>(DynamicLoadObject(StartGameClassName, class'Class'));
		Root.CreateWindow(StartGameClass, 100, 100, 200, 200, Self, True);
		break;
	case OpenLocation:
	case Browser:
	case LAN:
		bOpenLAN = (I == LAN);
		bOpenLocation = (I == OpenLocation);

		//if(GetPlayerOwner().PlayerReplicationInfo.PlayerName ~= "Player") {
			//SuggestPlayerSetup = MessageBox(SuggestPlayerSetupTitle, SuggestPlayerSetupText, MB_YesNo, MR_None, MR_None);
		//} else {
		  //if(!class'UMenuNetworkClientWindow'.default.bShownWindow && !bOpenLAN) {
			//SuggestNetspeed = MessageBox(SuggestNetspeedTitle, SuggestNetspeedText, MB_YesNo, MR_None, MR_None);
		  //} else {
			LoadUBrowser();
	       //}
	    // }
		break;
	case Disconnect:
		GetPlayerOwner().ConsoleCommand("disconnect");
		Root.Console.CloseUWindow();
		break;
	case Reconnect:
		if(GetLevel().NetMode == NM_Client)
			GetPlayerOwner().ConsoleCommand("disconnect");
		GetPlayerOwner().ConsoleCommand("reconnect");
		Root.Console.CloseUWindow();
		break;
	}

	Super.ExecuteItem(I);
}

function LoadUBrowser()
{
	local class<UBrowserMainWindow> UBrowserClass;

	if(BrowserWindow == None)
	{
		UBrowserClass = class<UBrowserMainWindow>(DynamicLoadObject(UBrowserClassName, class'Class'));
		BrowserWindow = UBrowserMainWindow(Root.CreateWindow(UBrowserClass, 50, 30, 500, 300));
	}
	else
	{
		BrowserWindow.ShowWindow();
		BrowserWindow.BringToFront();
	}
	if(bOpenLocation)
		BrowserWindow.ShowOpenWindow();

	if(bOpenLAN)
		BrowserWindow.SelectLAN();
	else {
		BrowserWindow.SelectInternet();
	}

	bOpenLocation = False;
}

defaultproperties
{
     StartName="&Start New Multiplayer Game"
     StartHelp="Start your own network game which others can join."
     BrowserName="&Find Internet Games"
     BrowserHelp="Search for games currently in progress on the Internet."
     LANName="Find &LAN Games"
     LANHelp="Search for games of your local LAN."
     OpenLocationName="Open &Location"
     OpenLocationHelp="Connect to a server using its IP address or unreal:// URL."
     DisconnectName="&Disconnect from Server"
     DisconnectHelp="Disconnect from the current server."
     ReconnectName="&Reconnect to Server"
     ReconnectHelp="Attempt to reconnect to the last server you were connected to."
     UBrowserClassName="ThMenu.ThBrowserMainWindow"
     StartGameClassName="ThMenu.ThMenuStartGameWindow"
}
