// ============================================================
// ThMenu.ThOptionsMenu: put your comment here

// Created by UClasses - (C) 2000 by meltdown@thirdtower.com
// ============================================================

class ThOptionsMenu expands UWindowPulldownMenu;

var UWindowPulldownMenuItem Preferences, Desktop, Advanced, Player;

var localized string PreferencesName;
var localized string PreferencesHelp;
var localized string DesktopName;
var localized string DesktopHelp;
var localized string PlayerMenuName;
var localized string PlayerMenuHelp;

var Class<UWindowWindow> PlayerWindowClass;

function Created()
{
	Super.Created();

	Preferences = AddMenuItem(PreferencesName, None);
	Player = AddMenuItem(PlayerMenuName, None);

	AddMenuItem("-", None);

	Desktop = AddMenuItem(DesktopName, None);
	Desktop.bChecked = Root.Console.ShowDesktop;
}

function UWindowWindow PlayerSetup()
{
	return Root.CreateWindow(PlayerWindowClass, 100, 100, 200, 200, Self, True);
}

function ShowPreferences(optional bool bNetworkSettings)
{
	local ThMenuOptionsWindow O;

	O = ThMenuOptionsWindow(Root.CreateWindow(Class'ThMenuOptionsWindow', 100, 100, 200, 200, Self, True));
	if(bNetworkSettings)
		ThMenuOptionsClientWindow(O.ClientArea).ShowNetworkTab();
}

function ExecuteItem(UWindowPulldownMenuItem I) 
{
	switch (I)
	{
	case Preferences:
		ShowPreferences();
		break;
	case Desktop:
		// Toggle show desktop.
		Desktop.bChecked = !Desktop.bChecked;
		Root.Console.ShowDesktop = !Root.Console.ShowDesktop;
		Root.Console.bNoDrawWorld = Root.Console.ShowDesktop;
		Root.Console.SaveConfig();
		break;
	case Player:
		// Create player dialog.
		PlayerSetup();
		break;
	}

	Super.ExecuteItem(I);
}

function Select(UWindowPulldownMenuItem I) 
{
	switch (I)
	{
	case Preferences:
		ThMenuBar(GetMenuBar()).SetHelp(PreferencesHelp);
		break;
	case Desktop:
		ThMenuBar(GetMenuBar()).SetHelp(DesktopHelp);
		break;
	case Player:
		ThMenuBar(GetMenuBar()).SetHelp(PlayerMenuHelp);
		break;
	}

	Super.Select(I);
}

defaultproperties
{
     PreferencesName="P&references"
     PreferencesHelp="Change your game options, audio and video setup, controls and other options."
     DesktopName="Show &Desktop"
     DesktopHelp="Toggle between showing your game behind the menus, or the desktop logo."
     PlayerMenuName="&Player Setup"
     PlayerMenuHelp="Choose to be a thief or a guard!"
     PlayerWindowClass=Class'ThMenu.ThPlayerWindow'
}
