// ============================================================
// ThMenu.ThPlayerClientWindow: put your comment here

// Created by UClasses - (C) 2000 by meltdown@thirdtower.com
// ============================================================

class ThPlayerClientWindow expands UMenuDialogClientWindow;

var() int ControlOffset;
var bool Initialized;
var UWindowHSplitter Splitter;
var class<UWindowWindow> PlayerSetupClass;

// Player Name
var UWindowEditControl NameEdit;
var localized string NameText;
var localized string NameHelp;

// Don't let you spawn until you've bought something
var UWindowCheckbox	ForceBuyCheck;
var localized string ForceBuyText;
var localized string ForceBuyHelp;

var UWindowCheckbox	ShowTeamLocationInChatCheck;
var localized string ShowTeamLocationInChatText;
var localized string ShowTeamLocationInChatHelp;

var UWindowCheckbox	FrobUseItemCheck;
var localized string FrobUseItemText;
var localized string FrobUseItemHelp;

var UWindowComboControl SpeechPackCombo;
var localized string SpeechPackText;
var localized string SpeechPackHelp;

function Created()
{
	local string SkinName, FaceName;

	local int ControlWidth, ControlLeft, ControlRight;
	local int CenterWidth, CenterPos;
	local int I;

	//MeshWindow = UMenuPlayerMeshClient(UMenuPlayerClientWindow(ParentWindow.ParentWindow.ParentWindow).Splitter.RightClientWindow);

	Super.Created();

	ControlWidth = WinWidth/2.5;
	ControlLeft = (WinWidth/2 - ControlWidth)/2;
	ControlRight = WinWidth/2 + ControlLeft;

	CenterWidth = (WinWidth/4)*3;
	CenterPos = (WinWidth - CenterWidth)/2;

	//NewPlayerClass = GetPlayerOwner().Class;

	// Player Name
	NameEdit = UWindowEditControl(CreateControl(class'UWindowEditControl', CenterPos, ControlOffset, CenterWidth, 1));
	NameEdit.SetText(NameText);
	NameEdit.SetHelpText(NameHelp);
	NameEdit.SetFont(F_Normal);
	NameEdit.SetNumericOnly(False);
	NameEdit.SetMaxLength(20);
	NameEdit.SetDelayedNotify(True);

	ControlOffset += 25;
	ForceBuyCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', CenterPos, ControlOffset, CenterWidth, 1));
	ForceBuyCheck.bChecked = class'ThieveryMod.ThieveryConfigClient'.default.bForceBuying;
	ForceBuyCheck.SetText(ForceBuyText);
	ForceBuyCheck.SetHelpText(ForceBuyHelp);
	ForceBuyCheck.SetFont(F_Normal);
	ForceBuyCheck.Align = TA_Right;

	ControlOffset += 25;
	ShowTeamLocationInChatCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', CenterPos, ControlOffset, CenterWidth, 1));
	ShowTeamLocationInChatCheck.bChecked = class'ThieveryConfigClient'.default.bTeamMessagesShowLocation;
	ShowTeamLocationInChatCheck.SetText(ShowTeamLocationInChatText);
	ShowTeamLocationInChatCheck.SetHelpText(ShowTeamLocationInChatHelp);
	ShowTeamLocationInChatCheck.SetFont(F_Normal);
	ShowTeamLocationInChatCheck.Align = TA_Right;

	ControlOffset += 25;
	FrobUseItemCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', CenterPos, ControlOffset, ControlWidth, 1));
	FrobUseItemCheck.bChecked = class'ThieveryMod.ThieveryConfigClient'.default.bFrobUseInvItem;
	FrobUseItemCheck.SetText(FrobUseItemText);
	FrobUseItemCheck.SetHelpText(FrobUseItemHelp);
	FrobUseItemCheck.SetFont(F_Normal);
	FrobUseItemCheck.Align = TA_Right;

	ControlOffset += 25;
	SpeechPackCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', CenterPos, ControlOffset, CenterWidth, 1));
	SpeechPackCombo.SetText(SpeechPackText);
	SpeechPackCombo.SetHelpText(SpeechPackHelp);
	SpeechPackCombo.SetFont(F_Normal);
	SpeechPackCombo.SetEditable(False);
	SpeechPackCombo.AddItem("Classic");
	SpeechPackCombo.AddItem("Jezmilar Guard");
	SpeechPackCombo.AddItem("Mordengaard Guard");

	/*
	Super.Created();

	Splitter = UWindowHSplitter(CreateWindow(class'UWindowHSplitter', 0, 0, WinWidth, WinHeight));

	Splitter.RightClientWindow = UMenuPlayerMeshClient(Splitter.CreateWindow(class'UMenuPlayerMeshClient', 0, 0, 100, 100));
	Splitter.LeftClientWindow = Splitter.CreateWindow(PlayerSetupClass, 0, 0, 100, 100, OwnerWindow);

	Splitter.bRightGrow = True;
	Splitter.SplitPos = 240;
//	Splitter.MinWinWidth = 300;*/
}

function Resized()
{
	Super.Resized();
	if (Splitter!=none) Splitter.SetSize(WinWidth, WinHeight);
}

function Notify(UWindowDialogControl C, byte E)
{
	Super.Notify(C, E);

	switch(E)
	{
	case DE_Change:
		switch(C)
		{
			case NameEdit:
				NameChanged();
				break;
			case ForceBuyCheck:
				ForceBuyChanged();
				break;
			case ShowTeamLocationInChatCheck:
				ShowTeamLocationInChatChanged();
				break;
			case FrobUseItemCheck:
				FrobUseItemChanged();
				break;
			case SpeechPackCombo:
				SpeechPackChanged();
				break;
		}
	}
}

function NameChanged()
{
	local string N;
	if (Initialized)
	{
		Initialized = False;
		N = NameEdit.GetValue();
		ReplaceText(N, " ", "_");
		NameEdit.SetValue(N);
		Initialized = True;

		GetPlayerOwner().ChangeName(NameEdit.GetValue());
		GetPlayerOwner().UpdateURL("Name", NameEdit.GetValue(), True);
	}
}

function FrobUseItemChanged() {
	class'ThieveryMod.ThieveryConfigClient'.default.bFrobUseInvItem=FrobUseItemCheck.bChecked;
}

function ShowTeamLocationInChatChanged() {
	class'ThieveryConfigClient'.default.bTeamMessagesShowLocation=ShowTeamLocationInChatCheck.bChecked;
}

function BeforePaint(Canvas C, float X, float Y)
{
	local int ControlWidth, ControlLeft, ControlRight;
	local int CenterWidth, CenterPos;
	local float W;

	W = Min(WinWidth, 220);

	ControlWidth = W/3;
	ControlLeft = (W/2 - ControlWidth)/2;
	ControlRight = W/2 + ControlLeft;

	CenterWidth = (W/7)*6;
	CenterPos = (W - CenterWidth)/2;

	NameEdit.SetSize(CenterWidth, 1);
	NameEdit.WinLeft = CenterPos;
	NameEdit.EditBoxWidth = 105;

	ForceBuyCheck.SetSize(CenterWidth, 1);
	ForceBuyCheck.WinLeft = CenterPos;

	ShowTeamLocationInChatCheck.SetSize(CenterWidth, 1);
	ShowTeamLocationInChatCheck.WinLeft = CenterPos;
	
	FrobUseItemCheck.SetSize(CenterWidth, 1);
	FrobUseItemCheck.WinLeft = CenterPos;
	
	SpeechPackCombo.SetSize(CenterWidth, 1);
	SpeechPackCombo.WinLeft = CenterPos;
	SpeechPackCombo.EditBoxWidth = 125;
}

function SaveConfigs()
{
	//Super.SaveConfigs();
	GetPlayerOwner().SaveConfig();
	GetPlayerOwner().PlayerReplicationInfo.SaveConfig();
	class'ThieveryMod.ThieveryConfigClient'.static.StaticSaveConfig();
}

function LoadCurrent()
{
	local string SN, FN;

	log("LOAD CURRENT");
	log("player owner="$GetPlayerOwner()$" PRI="$GetPlayerOwner().PlayerReplicationInfo$" name="$GetPlayerOwner().PlayerReplicationInfo.PlayerName);
	NameEdit.SetValue(GetPlayerOwner().PlayerReplicationInfo.PlayerName);
	ForceBuyCheck.bChecked=class'ThieveryMod.ThieveryConfigClient'.default.bForceBuying;
	ShowTeamLocationInChatCheck.bChecked=class'ThieveryConfigClient'.default.bTeamMessagesShowLocation;
	FrobUseItemCheck.bChecked=class'ThieveryMod.ThieveryConfigClient'.default.bFrobUseInvItem;
	SpeechPackCombo.SetSelectedIndex(class'ThieveryMod.ThieveryConfigClient'.default.SpeechPack);
}

function ForceBuyChanged() {
	class'ThieveryMod.ThieveryConfigClient'.default.bForceBuying=ForceBuyCheck.bChecked;
}

function SpeechPackChanged() {
	local int i;
	class'ThieveryMod.ThieveryConfigClient'.default.SpeechPack=SpeechPackCombo.GetSelectedIndex();
	/*
	if (GetPlayerOwner().Level.NetMode==NM_Standalone) {
		i=GetPlayerOwner().PlayerReplicationInfo.Team;
		GetPlayerOwner().PlayerReplicationInfo.Team=1;
		ThieveryPPawn(GetPlayerOwner()).ThTaunt(rand(6));
		GetPlayerOwner().PlayerReplicationInfo.Team=i;
	}*/
}

function AfterCreate()
{
	Super.AfterCreate();

	DesiredWidth = 320;
	DesiredHeight = ControlOffset + 50;

	LoadCurrent();
	//UseSelected();

	Initialized = True;
}

defaultproperties
{
     ControlOffset=25
     PlayerSetupClass=Class'ThMenu.ThPlayerSetupScrollClient'
     NameText="Name:"
     NameHelp="Set your player name."
     ForceBuyText="Force Buying"
     ForceBuyHelp="Doesn't let you spawn without buying some equipment."
     ShowTeamLocationInChatText="Show location in team chat"
     ShowTeamLocationInChatHelp="Shows other player's location in team chat messages"
     FrobUseItemText="Frob uses inv. item"
     FrobUseItemHelp="Whether frobbing will use an item from your inventory or not"
     SpeechPackText="Guard voice"
     SpeechPackHelp="Determines which taunt speech your guard has"
}
