// ============================================================
// ThMenu.ThToolsMenu: put your comment here

// Created by UClasses - (C) 2000 by meltdown@thirdtower.com
// ============================================================

class ThToolsMenu expands UWindowPulldownMenu;

var UWindowPulldownMenuItem Console, TimeDemo, ShowLog, DevConfig;

var localized string ConsoleName;
var localized string ConsoleHelp;
var localized string TimeDemoName;
var localized string TimeDemoHelp;
var localized string LogName;
var localized string LogHelp;
var localized string DevName;
var localized string DevHelp;

function Created()
{
	Super.Created();

	// Add menu items.
	Console = AddMenuItem(ConsoleName, None);
	Console.bChecked = Root.Console.bShowConsole;
	TimeDemo = AddMenuItem(TimeDemoName, None);
	TimeDemo.bChecked = Root.Console.bTimeDemo;
	ShowLog = AddMenuItem(LogName, None);
	//DevConfig = AddMenuItem(DevName, None);
}

function ShowWindow()
{
	Super.ShowWindow();

	Console.bChecked = Root.Console.bShowConsole;
}

function ExecuteItem(UWindowPulldownMenuItem I)
{
	switch(I)
	{
	case Console:
		Console.bChecked = !Console.bChecked;
		if (Console.bChecked)
			Root.Console.ShowConsole();
		else
			Root.Console.HideConsole();
		break;
	case TimeDemo:
		TimeDemo.bChecked = !TimeDemo.bChecked;
		GetPlayerOwner().ConsoleCommand("TIMEDEMO "$TimeDemo.bChecked);
		break;
	case ShowLog:
		GetPlayerOwner().ConsoleCommand("SHOWLOG");
		break;
	//case DevConfig:
//		Root.CreateWindow(class'ThieveryConfigWin', 0, 0, 280,300);
//		break;
	}

	Super.ExecuteItem(I);
}


function Select(UWindowPulldownMenuItem I)
{
	switch(I)
	{
	case Console:
		ThMenuBar(GetMenuBar()).SetHelp(ConsoleHelp);
		break;
	case TimeDemo:
		ThMenuBar(GetMenuBar()).SetHelp(TimeDemoHelp);
		break;
	case ShowLog:
		ThMenuBar(GetMenuBar()).SetHelp(LogHelp);
		break;
	//case DevConfig:
//		ThMenuBar(GetMenuBar()).SetHelp(DevHelp);
//		break;
	}

	Super.Select(I);
}

defaultproperties
{
     ConsoleName="System &Console"
     ConsoleHelp="This option brings up the Unreal Console.  You can use the console to enter advanced commands and cheats."
     TimeDemoName="T&imeDemo Statistics"
     TimeDemoHelp="Enable the TimeDemo statistic to measure your frame rate."
     LogName="Show &Log"
     LogHelp="Show the Unreal log window."
     DevName="&Dev Config"
     DevHelp="Misc Thievery developer options"
}
