//=============================================================================
// AntiThiefKO.
//=============================================================================
class AntiThiefCrack expands OnCrackEffect;

var() float CrackDuration;
var float crackValue;
var float FadeOutTime;

simulated function Tick(float deltatime) {
	local rotator crackRotator;
	// do crack blurring
	if (Owner.isA('PlayerPawn')) {
		crackValue+=(30+Rand(20))*deltatime;
		if (crackValue>40) crackValue-=40;
		if (crackValue<20) {
			//ThieveryPPawn(Player).SetDesiredFOV(80.0+crackValue);
			PlayerPawn(Owner).ConstantGlowFog.Y=(crackValue/40.0)*0.5+0.3;
		} else {
			//ThieveryPPawn(Player).SetDesiredFOV(80.0+(40-crackValue));
			PlayerPawn(Owner).ConstantGlowFog.Y=((40-crackValue)/40.0)*0.5+0.3;
		}
		//crackRotator.Pitch=sin((crackValue-20)/20.0)*40.0;
		//crackRotator.Roll=(crackValue-20)*40;
		crackRotator.Yaw=cos(((crackValue/60.0)-1.0)*6.2832)*2400.0;
		crackRotator.Pitch=sin(((crackValue/30.0)-1.0)*6.2832)*400.0;
		//log("crackrotator:"$crackRotator);
		Pawn(Owner).ViewRotation+=crackRotator;
		Pawn(Owner).FOVAngle=120+FRand()*120;
		if (Owner.IsA('ThieveryPPawn')) {
			ThieveryPPawn(Owner).bOnCrack=true;
		}
	} else {
		Destroy();
	}
}

simulated function BeginPlay() {
	//log("setting fov, starting timer");
	PlayerPawn(Owner).DesiredFOV=140;
	SetTimer(CrackDuration,false);
}

simulated function Timer() {
	//log("going to fade out");
	GotoState('FadingOut');
}

state FadingOut {

	simulated function Tick(float deltatime) {
		local rotator crackRotator;
		// do crack blurring
		if (Owner.isA('PlayerPawn')) {
			FadeOutTime-=deltatime;
			SoundVolume=(FadeOutTime/5.0)*255;
			crackValue+=(30+Rand(20))*deltatime;
			if (crackValue>40) crackValue-=40;
			if (crackValue<20) {
				//ThieveryPPawn(Player).SetDesiredFOV(80.0+crackValue);
				PlayerPawn(Owner).ConstantGlowFog.Y=((crackValue/20.0)*0.5+0.3)*(FadeOutTime/5.0);
			} else {
				//ThieveryPPawn(Player).SetDesiredFOV(80.0+(40-crackValue));
				PlayerPawn(Owner).ConstantGlowFog.Y=(((40-crackValue)/20.0)*0.5+0.3)*(FadeOutTime/5.0);
			}
			//crackRotator.Pitch=sin((crackValue-20)/20.0)*40.0;
			//crackRotator.Roll=(crackValue-20)*40;
			crackRotator.Yaw=cos(((crackValue/20.0)-1.0)*6.2832)*4000.0;
			crackRotator.Pitch=sin(((crackValue/20.0)-1.0)*6.2832)*4000.0;
			crackRotator*=(FadeOutTime/5.0);
			//log("crackrotator:"$crackRotator);
			Pawn(Owner).ViewRotation+=crackRotator;
		} else {
			Destroy();
		}
	}

	simulated function Timer() {
		//log("Timer killing crack");
		//PlayerPawn(Owner).SetDesiredFOV(90);
		PlayerPawn(Owner).DesiredFOV=90;
		PlayerPawn(Owner).ConstantGlowFog = vect(0,0,0);
		ThieveryPPawn(Owner).bOnCrack=false;
		Destroy();
	}

	simulated function BeginState() {
		FadeOutTime=5.0;
		SetTimer(FadeOutTime,false);
	}
}

simulated function GoAwayTaffer() {
	//log("[OnCrackEffect] GoAwayTaffer() Owner="$Owner);
	disable('tick');
	disable('timer');
	PlayerPawn(Owner).DesiredFOV=90;
	PlayerPawn(Owner).ConstantGlowFog = vect(0,0,0);
	ThieveryPPawn(Owner).bOnCrack=false;
	destroy();
}


defaultproperties
{
    CrackDuration=5.00
}
