//=============================================================================
// ThAddItemClassTHIEFMATCH.
//=============================================================================
class ThAddItemClassTHIEFMATCH expands Mutator;

var() class<ThieveryPickup> ItemClass; // The ammo type to add
var() bool Guards;				//Guard team or thief team.
var() config int Cost;	 		 // The cost of the item
var() config int Quantity;
var() config int ItemLimit;
var bool OutOfRoomError;			 // No more room for this weapon!

event BeginPlay() {
	local bool ShopFound;
	local bool ShopUpdated;
	local int i;
	local class<ThieveryShopThieves> shopClass;
	local ThieveryShopThieves Shop;
	
	saveconfig();

	if (Guards)
		shopClass = class'ThieveryShopThieves';
	else
		shopClass = class'ThieveryShopThievesThiefMatch';
	
	foreach AllActors(class'ThieveryShopThieves', Shop) {
		if (shop.Class==shopClass) {
			ShopUpdated = False;
			ShopFound = True;
			//Checks that the shop doesn't already have this weapon...
			for(i=0; i < ArrayCount(Shop.Items) && Shop.Items[i].Item != none; i++) {
				if(Shop.Items[i].Item == ItemClass) ShopUpdated = true;
			}
			if (!ShopUpdated && i<ArrayCount(Shop.Items)) {
				Shop.Items[i].Item = ItemClass;
				Shop.Items[i].Cost = Cost;
				Shop.Items[i].Quantity = Quantity;
				Shop.ItemsLimit[i] = ItemLimit;
				ShopUpdated = true;
			}
			if (i==ArrayCount(Shop.Items)) {
				ShopUpdated = true;
				OutOfRoomError = true;
			}
		}
	}

	// No existing shop, so spawn one!
	if(!ShopFound && !OutOfRoomError) {
		Shop = Spawn(shopClass); 
		for(i=0;i<ArrayCount(Shop.Items) && Shop.Items[i].Item != none; i++) {
			if(Shop.Items[i].Item == ItemClass) ShopUpdated = true;
		}
		if (!ShopUpdated && i<ArrayCount(Shop.Items)) {
			Shop.Items[i].Item = ItemClass;
			Shop.Items[i].Cost = Cost;
			Shop.Items[i].Quantity = Quantity;
			Shop.ItemsLimit[i] = ItemLimit;
			ShopUpdated = true;
		}
		if (i==ArrayCount(Shop.Items)) {
			ShopUpdated = true;
			OutOfRoomError = true;
		}			
	}
	if(OutOfRoomError){
		log(self$": no room in shop for item!");
	}
	Super.BeginPlay();
}

defaultproperties
{
}
