//=============================================================================
// ThPickupExplosiveSwagDiamondRing.
//=============================================================================
class ThPickupExplosiveSwagDiamondRing expands ThPickupFlashbomb;

#exec MESH IMPORT MESH=ThObjectNewPurse ANIVFILE=MODELS\newlootpurse\ThObjectNewPurse_a.3d DATAFILE=MODELS\newlootpurse\ThObjectNewPurse_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=ThObjectNewPurse X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=ThObjectNewPurse SEQ=All STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=ThObjectNewPurse MESH=ThObjectNewPurse
#exec MESHMAP SCALE MESHMAP=ThObjectNewPurse X=0.175 Y=0.175 Z=0.350

#exec MESHMAP SETTEXTURE MESHMAP=ThObjectNewPurse NUM=1 TEXTURE=NewPurseTex
#exec MESHMAP SETTEXTURE MESHMAP=ThObjectNewPurse NUM=2 TEXTURE=NewPurseTex
#exec MESHMAP SETTEXTURE MESHMAP=ThObjectNewPurse NUM=3 TEXTURE=NewPurseTex
#exec MESHMAP SETTEXTURE MESHMAP=ThObjectNewPurse NUM=4 TEXTURE=NewPurseTex

var ThObjectExplosiveSwagDiamondRing f;
var vector X,Y,Z,FireOffset;
var rotator launchRot, TempRot;
var ThieveryPPawn tpp;
var Weapon w;

state Activated  // Delete from inventory and toss in front of player.
{

Begin:
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);

	// throw one
	f=Spawn(class'ThObjectExplosiveSwagDiamondRing', Owner, '', Pawn(Owner).Location +FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z, Pawn(Owner).Rotation);

	if (f==none) {
		GotoState('');
	} else {

		f.Velocity=vector(Pawn(Owner).ViewRotation)*100+vect(0,0,50);
		TempRot=f.Rotation;
		TempRot.Pitch=0;
		f.SetRotation(TempRot);
		f.SetPhysics(PHYS_Falling);

		NumCopies--;


		if (NumCopies>=0) {		// still have some
			GoToState('');
		} else {				// used all up, destroy pickup
			if (Owner.IsA('ThieveryPPawn') && ThieveryPPawn(Owner).PlayerReplicationInfo!=none) {
				ThieveryPlayerReplicationInfo(ThieveryPPawn(Owner).PlayerReplicationInfo).bHasSupplyChest=false;
			}
			Pawn(Owner).NextItem();
			if (Pawn(Owner).SelectedItem == Self) Pawn(Owner).SelectedItem=None;
			Pawn(Owner).DeleteInventory(Self);
			Destroy();
		}
	}
}

defaultproperties
{
    FireOffset=(X=30.00,Y=0.00,Z=12.00),
    HUDName="Explosive Loot"
    bCanDrop=False
    PickupMessage="You picked up some Explosive Loot"
    ItemName="Explosive Loot"
    PlayerViewMesh=LodMesh'ThieveryObjects.ThObjectDiamondRing'
    PickupViewMesh=LodMesh'ThieveryObjects.ThObjectDiamondRing'
    Mesh=LodMesh'ThieveryObjects.ThObjectDiamondRing'
}
