//===============================================================================
//  [horse]
//===============================================================================

class ThCharger extends ThStallion;

#exec OBJ LOAD FILE=..\Thievery\TH-Sounds\ThCountrysideGuard.uax PACKAGE=ThCountrysideGuard


var bool bPlaying;

function PreBeginPlay()
{
local Weapon NewWeapon;
super.PreBeginPlay();
newWeapon = Spawn(class'ThTenth.ThChargerRider');
newWeapon.WeaponSet(Self);
}


///////////////////////////////////////////////////////////////////

/*----------------------------------------------------------------
Anims
----------------------------------------------------------------*/

// The guard is greeting a friend.
function Greet(Pawn SeenPlayer)
	{
		    if(!bPlaying)

    { 

       PlaySound(Sound'Country_Greet3');

        bPlaying = true; 

        SetTimer(0.3, false); 

    } 

}   

// The guard is just standing there
function PlayStanding()
	{
	TweenAnim('Idle', 1.0);
		    if(!bPlaying)

    { 

       PlaySound(Sound'Country_Idle3');

        bPlaying = true; 

        SetTimer(0.3, false); 

    } 

}

// The guard is looking around (i.e. hand above the eyes)
function PlayLooking()
	{
	PlayAnim('Hiss', FRand()*0.5+0.25);
		    if(!bPlaying)

    { 

       PlaySound(Sound'Country_Idle2');

        bPlaying = true; 

        SetTimer(0.3, false); 

    } 

}


// The guard just got suprised (jumps with surprise)
function PlaySurprised()
	{
	PlayAnim('Hiss', FRand()*0.5+0.25);
		    if(!bPlaying)

    { 

       PlaySound(Sound'Country_Suspicious1');

        bPlaying = true; 

        SetTimer(0.3, false); 

    } 

}

// The guard just got hit by a sword or arrow, etc
function PlayGotHit(float tweentime, vector HitLoc, int damage)
	{
	TweenAnim('Attack1', tweentime);
	PlaySound(Sound'Country_Backup1');
	}

// The guard is pressing a button on the wall
function PlayFrob()
	{
	PlayAnim('Hiss');
	PlaySound(Sound'Country_Idle4');
	}

// The guard is talking
function PlayTalking()
	{
	LoopAnim('Idle');
		    if(!bPlaying)

    { 

       PlaySound(Sound'Country_Greet2');

        bPlaying = true; 

        SetTimer(0.3, false); 

    } 

}

// The guard is talking
function PlayInvestigating()
	{
	LoopAnim('Walk', 0.4);
		    if(!bPlaying)

    { 

       PlaySound(Sound'Country_RaiseAlarm1');

        bPlaying = true; 

        SetTimer(0.3, false); 

    } 

}


// The guard is yelling
function PlayYelling()
	{
	PlayAnim('Attack2');
		    if(!bPlaying)

    { 

       PlaySound(Sound'Country_Charge1');

        bPlaying = true; 

        SetTimer(0.3, false); 

    } 

}
	
// The guard is poppin' caps
function PlayRangedAttack()
	{
	PlayAnim('Idle');
	    if(!bPlaying)

    { 

       PlaySound(Sound'Country_CaughtThief2');

        bPlaying = true; 

        SetTimer(0.3, false); 

    } 

}

// The guard is sleeping
function PlaySleeping()
	{
		PlayAnim('Dead', 1);
		PlaySound(Sound'Country_Backup1');
	}

// The bot has been flashbombed
function PlayBlinded()

{ 

    LoopAnim('Attack2', FRand()*0.5+0.25); 

    if(!bPlaying)

    { 

        PlaySound(Sound'Country_Surprised1');

        bPlaying = true; 

        SetTimer(0.3, false); 

    } 

}
function PlayDying(name DamageType, vector HitLoc)
	{
	PlayAnim('Dead', 0.5);
	PlaySound(Sound'Country_DieQuiet1');
	}
	

///////////////////////////////////////////////////////////////////
defaultproperties
{
    AttitudeToPlayerClass(0)=1
    AttitudeToPlayerClass(1)=3
	Team=1
    BotName="a Charger"
}
