//===============================================================================
//  ThBrutusDog.uc
//  Based on the original BrutusDog model and animation file
//  reimported to 3dsmax and hotfixxed by Duan 'McFarrel' Majts
//  ToDo:
//  the anims are rather rude, the model needs at least reanimating (from my point of view this need to
//  be done by restufing with new biped and reanimating (PSA/PSK file is uncapable of handling IK,
//  due to its output format after all. But when trying to fix anims the missing inverse kinematics makes
//  things rather unpleasant...)
// Chief You have to add anim notify section to tell Unreal core when to play footstep sounds...
//===============================================================================
class ThDog extends ThTenthCreature;

#exec MESH  MODELIMPORT MESH=ThDogMesh MODELFILE=models\ThDogBrutus_fix.PSK LODSTYLE=10
#exec MESH  ORIGIN MESH=ThDogMesh X=-250 Y=-130 Z=-60 YAW=192 PITCH=0 ROLL=0
#exec ANIM  IMPORT ANIM=ThDogAnims ANIMFILE=models\ThDogBrutusAnims_fix.PSA COMPRESS=1 MAXKEYS=999999
#exec MESHMAP   SCALE MESHMAP=ThDogMesh X=0.3 Y=0.3 Z=0.3
#exec MESH  DEFAULTANIM MESH=ThDogMesh ANIM=ThDogAnims

// Animation sequences. These can replace or override the implicit (exporter-defined) sequences.
#EXEC ANIM  SEQUENCE ANIM=ThDogAnims SEQ=BiteIdle STARTFRAME=0 NUMFRAMES=21 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=ThDogAnims SEQ=BiteRun STARTFRAME=21 NUMFRAMES=24 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=ThDogAnims SEQ=Die STARTFRAME=45 NUMFRAMES=31 RATE=60.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=ThDogAnims SEQ=GetHit STARTFRAME=76 NUMFRAMES=13 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=ThDogAnims SEQ=Idle1 STARTFRAME=89 NUMFRAMES=29 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=ThDogAnims SEQ=Idle2 STARTFRAME=118 NUMFRAMES=20 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=ThDogAnims SEQ=Idle3 STARTFRAME=138 NUMFRAMES=20 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=ThDogAnims SEQ=Run STARTFRAME=158 NUMFRAMES=20 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=ThDogAnims SEQ=SniffEnd STARTFRAME=178 NUMFRAMES=11 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=ThDogAnims SEQ=SniffLoop STARTFRAME=189 NUMFRAMES=16 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=ThDogAnims SEQ=SniffStart STARTFRAME=205 NUMFRAMES=10 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=ThDogAnims SEQ=SniffWalk STARTFRAME=215 NUMFRAMES=27 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=ThDogAnims SEQ=Walk STARTFRAME=242 NUMFRAMES=24 RATE=30.0000 COMPRESS=1.00 GROUP=None 

// Digest and compress the animation data. Must come after the sequence declarations.
// 'VERBOSE' gives more debugging info in UCC.log 
#exec ANIM DIGEST ANIM=ThDogAnims  VERBOSE


//Anim Notify used for sfx.

#exec ANIM NOTIFY ANIM=ThDogAnims SEQ=Walk TIME=0.9 FUNCTION=BreathingNotify
#exec ANIM NOTIFY ANIM=ThDogAnims SEQ=Walk TIME=0.25 FUNCTION=PlayFootStep

#exec ANIM NOTIFY ANIM=ThDogAnims SEQ=SniffWalk TIME=0.9 FUNCTION=BreathingNotify
#exec ANIM NOTIFY ANIM=ThDogAnims SEQ=SniffWalk TIME=0.25 FUNCTION=PlayFootStep

#exec ANIM NOTIFY ANIM=ThDogAnims SEQ=BiteRun TIME=0.9 FUNCTION=BreathingNotify
#exec ANIM NOTIFY ANIM=ThDogAnims SEQ=BiteRun TIME=0.25 FUNCTION=PlayFootStep

#exec ANIM NOTIFY ANIM=ThDogAnims SEQ=Run TIME=0.9 FUNCTION=BreathingNotify
#exec ANIM NOTIFY ANIM=ThDogAnims SEQ=Run TIME=0.25 FUNCTION=PlayFootStep


#EXEC TEXTURE IMPORT NAME=ThDogTex0  FILE=TEXTURES\ThDogTex0.bmp  GROUP=Skins
#EXEC TEXTURE IMPORT NAME=ThDogTex1  FILE=TEXTURES\ThDogTex1.bmp  GROUP=Skins

#EXEC MESHMAP SETTEXTURE MESHMAP=ThDogMesh NUM=0 TEXTURE=ThDogTex0
#EXEC MESHMAP SETTEXTURE MESHMAP=ThDogMesh NUM=1 TEXTURE=ThDogTex1

// Original material [0] is [SKIN00.TWOSIDED] SkinIndex: 0 Bitmap: ThDogTex0.bmp  Path: D:\UT\ThTestDog\Textures 
// Original material [1] is [SKIN01.TWOSIDED] SkinIndex: 1 Bitmap: ThDogTex1.bmp  Path: D:\UT\ThTestDog\Textures 

#exec AUDIO IMPORT NAME="Dog_Acknowledge1" FILE="Sounds\dog_Acknowledge1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_Angry1" FILE="Sounds\dog_Angry1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_Backup1" FILE="Sounds\dog_Backup1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_Blinded1" FILE="Sounds\dog_Blinded1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_CaughtThief" FILE="Sounds\dog_CaughtThief.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_Charge1" FILE="Sounds\dog_Charge1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_Damaged1" FILE="Sounds\Dog_Damaged1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_DamagedKnown1" FILE="Sounds\Dog_DamagedKnown1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_DamagedSniped1" FILE="Sounds\Dog_DamagedSniped1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_DamagedUnknown1" FILE="Sounds\Dog_DamagedKnown1.wav" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_DeadBody1" FILE="Sounds\Dog_DeadBody1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_DeadBody2" FILE="Sounds\Dog_DeadBody2.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_DieLoud1" FILE="Sounds\Dog_DieLoud1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_DieQuiet1" FILE="Sounds\Dog_DieQuiet1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_EnemyDead1" FILE="Sounds\Dog_EnemyDead1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_EnemyLocation1" FILE="Sounds\Dog_EnemyLocation1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_Footprint1" FILE="Sounds\Dog_Footprint1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_Gassed1" FILE="Sounds\Dog_Gassed1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_Greet1" FILE="Sounds\Dog_Greet1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_Help1" FILE="Sounds\Dog_Help1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_Idle1" FILE="Sounds\Dog_Idle1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_Investigate1" FILE="Sounds\Dog_Investigate1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_InvestigateHear1" FILE="Sounds\Dog_InvestigateHear1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_InvestigateSight1" FILE="Sounds\Dog_InvestigateSight1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_LostEnemy1" FILE="Sounds\Dog_LostEnemy1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_MeleeAttack1" FILE="Sounds\Dog_MeleeAttack1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_RaiseAlarm1" FILE="Sounds\Dog_RaiseAlarm1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_Snoring1" FILE="Sounds\Dog_Snoring1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_Surprised1" FILE="Sounds\Dog_Surprised1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_Suspicious1" FILE="Sounds\Dog_Suspicious1.WAV" GROUP="dog"
#exec AUDIO IMPORT NAME="Dog_TorchOut1" FILE="Sounds\Dog_TorchOut1.WAV" GROUP="dog"

// Fix me there should be anim notifies preprocessor commands to tell the core when (on which frame) the footstep sound is played (or should this be a stealth dog?)

/*----------------------------------------------------------------
Anims
----------------------------------------------------------------*/

// The guard is just standing there
function PlayStanding()
	{
	TweenAnim('Idle1', 0.25);
	}

// The guard is walking/patrolling
function PlayCreeping()
	{
	LoopAnim('Walk', 0.2);
	}

// The guard is walking/patrolling
function PlayWalking()
	{
	LoopAnim('Walk', 0.6);
	}

// The guard is running
function PlayRunning()
	{
	LoopAnim('Run', 1);
	}

// The guard is looking around (i.e. hand above the eyes)
function PlayLooking()
	{
	PlayAnim('Idle2', FRand()*0.5+0.25);
	}

// The guard just got suprised (jumps with surprise)
function PlaySurprised()
	{
	PlayAnim('BiteIdle', FRand()*0.5+0.25);
	}

// The guard shake's it's fist (i.e. when can't reach player)
function PlayAngry()
	{
	PlayAnim('BiteIdle', 0.25);
	}

// The guard fiddles with it's sword, adjust it's feet, whatever
function PlayIdleAnim()
	{
	PlayAnim('Idle3', 0.2);
	}

// The guard just got hit by a sword or arrow, etc
function PlayGotHit(float tweentime, vector HitLoc, int damage)
	{
	TweenAnim('GetHit', tweentime);
	}

// The guard is pressing a button on the wall
function PlayFrob()
	{
	PlayAnim('BiteIdle');
	}

// The guard is talking
function PlayTalking()
	{
	LoopAnim('BiteIdle');
	}

// The guard is talking
function PlayInvestigating()
	{
	LoopAnim('SniffWalk', 0.4);
	}

// The guard is yelling
function PlayYelling()
	{
	PlayAnim('BiteIdle');
	}

// The guard is a-choppin' and a-loppin'
function PlayMeleeAttack(optional float fSwingTime)
	{
	if(fSwingTime > 0)
		TweenAnim('BiteIdle', fSwingTime);
	else
		TweenAnim('BiteIdle', 0.1);
	}

// The guard is airborne
function PlayInAir()
	{
	TweenAnim('Run', 0.5);
	}

// The guard has just landed
function PlayLanded(float impactVel)
	{
	TweenAnim('Walk', 0.5);
	}

// The bot has killed a foe
function PlayTaunting()
	{
	PlayAnim('BiteIdle', FRand()*0.5+0.25);
	}

// The bot has been flashbombed
function PlayBlinded()
	{
	LoopAnim('BiteIdle', FRand()*0.5+0.25);
	}

function PlayDying(name DamageType, vector HitLoc)
	{
	PlayAnim('Die', 0.25);
	}

/*----------------------------------------------------------------
----------------------------------------------------------------*/

function TweenToStand(float tweentime)
	{
	TweenAnim('Walk', tweentime);
	}

// The guard is airborne
function TweenToFalling()
	{
	TweenAnim('Run', 0.5);
	}

defaultproperties
{
    Team=1
    VoicePackage="ThTenth"
    VoiceSet="Dog"
    DrawType=DT_Mesh
    bStatic=False	
    Orders=Roam
    GroundSpeed=120.00
    Mesh=SkeletalMesh'ThDogMesh'
    DrawScale=1.00
    MultiSkins(0)=Texture'ThDogTex0'
    MultiSkins(1)=Texture'ThDogTex1'	
    bNoSmooth=False
    bShortRangeInvisibilitySight=True
    bCanOpenDoors_Override=False
    MeleeDamage=25.00
	bCanBeCracked=False
	bAttackKillerOnFriendlyDeath=True
	CollisionRadius=40.0
bMustAquireEnemy=False
blunges=True
bHeedsAlarm=True
}
