//===============================================================================
//  [horse]
//===============================================================================

class ThStallion extends ThTenthCreature;

#exec MESH  MODELIMPORT MESH=horseMesh MODELFILE=models\horseMesh.PSK LODSTYLE=12
#exec MESH  ORIGIN MESH=horseMesh X=0 Y=2 Z=0 YAW=128 PITCH=0 ROLL=192  // Y is Up (maya exported).
#exec ANIM  IMPORT ANIM=horseAnims ANIMFILE=models\horseAnims.PSA COMPRESS=1 MAXKEYS=999999
#exec MESHMAP   SCALE MESHMAP=horseMesh X=1.0 Y=1.0 Z=1.0
#exec MESH  DEFAULTANIM MESH=horseMesh ANIM=horseAnims
#exec MESH WEAPONATTACH MESH=horseMesh BONE="jointSaddle"
#exec MESH WEAPONPOSITION MESH=horseMesh YAW=128 PITCH=-14 ROLL=-64 X=0.0 Y=0.0 Z=-4.0

// Animation sequences. These can replace or override the implicit (exporter-defined) sequences.
#EXEC ANIM  SEQUENCE ANIM=horseAnims SEQ=Attack1 STARTFRAME=0 NUMFRAMES=13 RATE=13.0000 COMPRESS=1.00 GROUP=None
#EXEC ANIM  SEQUENCE ANIM=horseAnims SEQ=Attack2 STARTFRAME=13 NUMFRAMES=74 RATE=74.0000 COMPRESS=1.00 GROUP=None
#EXEC ANIM  SEQUENCE ANIM=horseAnims SEQ=Crouch STARTFRAME=87 NUMFRAMES=26 RATE=26.0000 COMPRESS=1.00 GROUP=None
#EXEC ANIM  SEQUENCE ANIM=horseAnims SEQ=Dead STARTFRAME=113 NUMFRAMES=10 RATE=10.0000 COMPRESS=1.00 GROUP=None
#EXEC ANIM  SEQUENCE ANIM=horseAnims SEQ=Hiss STARTFRAME=124 NUMFRAMES=21 RATE=21.0000 COMPRESS=1.00 GROUP=None
#EXEC ANIM  SEQUENCE ANIM=horseAnims SEQ=Idle STARTFRAME=145 NUMFRAMES=61 RATE=61.0000 COMPRESS=1.00 GROUP=None
#EXEC ANIM  SEQUENCE ANIM=horseAnims SEQ=Jumping STARTFRAME=206 NUMFRAMES=24 RATE=24.0000 COMPRESS=1.00 GROUP=None
#EXEC ANIM  SEQUENCE ANIM=horseAnims SEQ=Walk STARTFRAME=230 NUMFRAMES=25 RATE=25.0000 COMPRESS=1.00 GROUP=None

// Digest and compress the animation data. Must come after the sequence declarations.
// 'VERBOSE' gives more debugging info in UCC.log 
#exec ANIM DIGEST ANIM=horseAnims  VERBOSE

//Anim Notify used for sfx.

#exec ANIM NOTIFY ANIM=horseAnims SEQ=Walk TIME=0.9 FUNCTION=BreathingNotify
#exec ANIM NOTIFY ANIM=horseAnims SEQ=Walk TIME=0.25 FUNCTION=PlayFootStep

#EXEC TEXTURE IMPORT NAME=horseTex0  FILE=TEXTURES\horseTex0.bmp  GROUP=Skins MIPS=OFF LODSET=2

#EXEC MESHMAP SETTEXTURE MESHMAP=horseMesh NUM=0 TEXTURE=horseTex0

#exec AUDIO IMPORT NAME="HORSE_DAMAGED1" FILE="Sounds\HORSE_DAMAGED1.WAV" GROUP="HORSE"
#exec AUDIO IMPORT NAME="HORSE_DieLoud1" FILE="Sounds\HORSE_DieLoud1.WAV" GROUP="HORSE"
#exec AUDIO IMPORT NAME="HORSE_IDLE1" FILE="Sounds\HORSE_IDLE1.WAV" GROUP="HORSE"
#exec AUDIO IMPORT NAME="HORSE_INVESTIGATE1" FILE="Sounds\HORSE_INVESTIGATE1.WAV" GROUP="HORSE"
#exec AUDIO IMPORT NAME="HORSE_INVESTIGATE2" FILE="Sounds\HORSE_INVESTIGATE2.WAV" GROUP="HORSE"
#exec AUDIO IMPORT NAME="HORSE_IDLE2" FILE="Sounds\HORSE_IDLE2.WAV" GROUP="HORSE"
#exec AUDIO IMPORT NAME="HORSE_IDLE3" FILE="Sounds\HORSE_IDLE3.WAV" GROUP="HORSE"
#exec AUDIO IMPORT NAME="HORSE_MELEEATTACK1" FILE="Sounds\HORSE_MELEEATTACK1.WAV" GROUP="HORSE"
///////////////////////////////////////////////////////////////////

/*------------------------------------------------------------------------------
Adjusts the bot's variables making them better/worse depending on skill.
------------------------------------------------------------------------------*/
function AdjustForSkill()
	{
	local bool b;
	
	b = bLunges;
	
	Super.AdjustForSkill();
	
	// Spiders always lunge (regardless of skill)
	bLunges = b;
	}
	
/*----------------------------------------------------------------
Don't take falling damage.
----------------------------------------------------------------*/
function TakeFallingDamage()
	{
	}
	
/*----------------------------------------------------------------
Anims
----------------------------------------------------------------*/

// The guard is just standing there
function PlayStanding()
	{
	TweenAnim('Idle', 1.0);
	}

// The guard is walking/patrolling
function PlayCreeping()
	{
	LoopAnim('Walk', 0.2);
	}

// The guard is walking/patrolling
function PlayWalking()
	{
	LoopAnim('Walk', 1.0);
	}

// The guard is running
function PlayRunning()
	{
	LoopAnim('Walk', 2);
	}

// The guard is looking around (i.e. hand above the eyes)
function PlayLooking()
	{
	PlayAnim('Hiss', FRand()*0.5+0.25);
	}

// The guard just got suprised (jumps with surprise)
function PlaySurprised()
	{
	PlayAnim('Hiss', FRand()*0.5+0.25);
	}

// The guard shake's it's fist (i.e. when can't reach player)
function PlayAngry()
	{
	PlayAnim('Attack2', 0.25);
	}

// The guard fiddles with it's sword, adjust it's feet, whatever
function PlayIdleAnim()
	{
	PlayStanding();
	}

// The guard just got hit by a sword or arrow, etc
function PlayGotHit(float tweentime, vector HitLoc, int damage)
	{
	TweenAnim('Attack1', tweentime);
	}

// The guard is pressing a button on the wall
function PlayFrob()
	{
	PlayAnim('Hiss');
	}

// The guard is talking
function PlayTalking()
	{
	LoopAnim('Idle');
	}

// The guard is talking
function PlayInvestigating()
	{
	LoopAnim('Walk', 0.4);
	}

// The guard is yelling
function PlayYelling()
	{
	PlayAnim('Attack2');
	}

// The guard is a-choppin' and a-loppin'
function PlayMeleeAttack(optional float fSwingTime)
	{
	if(fSwingTime > 0)
		TweenAnim('Attack2', fSwingTime);
	else
		TweenAnim('Attack1', 0.1);
	}

// The guard is airborne
function PlayInAir()
	{
	TweenAnim('Jumping', 1.0);
	}

// The guard has just landed
function PlayLanded(float impactVel)
	{
	TweenAnim('Walk', 0.5);
	}

// The bot has killed a foe
function PlayTaunting()
	{
	PlayAnim('Hiss', FRand()*0.5+0.25);
	}

// The bot has been flashbombed
function PlayBlinded()
	{
	LoopAnim('Attack2', FRand()*0.5+0.25);
	}

function PlayDying(name DamageType, vector HitLoc)
	{
	PlayAnim('Dead', 1.0);
	}

/*----------------------------------------------------------------
----------------------------------------------------------------*/

function TweenToStand(float tweentime)
	{
	TweenAnim('Walk', tweentime);
	}

// The guard is airborne
function TweenToFalling()
	{
	TweenAnim('Crouch', 0.5);
	}

/*----------------------------------------------------------------
----------------------------------------------------------------*/


///////////////////////////////////////////////////////////////////

/*----------------------------------------------------------------
Gives this guard a default set of attitudes towards certain
actors.
----------------------------------------------------------------*/
function ETAttitude TAttitudeToIgnoreTeam(Actor Other)
	{
	if(Other.IsA('TGuard'))
		return ETAT_Friendly;
	else if(Other.IsA('TCreature') && TCreature(Other).bEvilCreature)
		return ETAT_Hate;
	// For funnnnnnn, attack non-thievery AI
	else if(Other.IsA('ScriptedPawn') || Other.IsA('Bot') || Other.IsA('Bots'))
		return ETAT_Hate;

	return Super.TAttitudeToIgnoreTeam(Other);
	}

/*----------------------------------------------------------------
----------------------------------------------------------------*/

defaultproperties
{
    LODBias=5.00
    Mesh=SkeletalMesh'horseMesh'
    bMeshCurvy=True
    MultiSkins(0)=Texture'Skins.horseTex0'
    CollisionRadius=48.00
    CollisionHeight=44.00
	DrawScale=4.0
	AttitudeToPlayerClass(0)=3
    AttitudeToPlayerClass(1)=3	
	FootstepSoundPackage="ThiefFootsteps"
    bCanBeFlashed=True
	bCanBeCracked=False
    bCanBeParalysed=True	
    VoicePackage="ThTenth"
    VoiceSet="Horse"
    Orders=GuardHere
	Team=255	
    DefaultLoadoutClass=None
    HelmetProbability=0.00	
    BotSkill=1.50
    BotName="a Stallion"
	bLunges=False
    Health=150	
    bAttacksRanged=False
    MeleeDamage=5.00
    LungeDamageScale=5.00	
    bPlayerCanInhabit=False
    bTakesOrders=False	
    JumpZ=25.00
    AirControl=0.00
}
