//Base class for our own creatures to allow for full voice packages etc that we require.

class ThTenthCreature expands TBot abstract;

var() bool bEvilCreature;		// Guards will hate this creature, civilians will be scared, this creature will attack non-creatures
var() bool bFollowFriendlyPeople;	// This creature will follow humans players and bots that it is friendly to

/*----------------------------------------------------------------
Ignore machines.
----------------------------------------------------------------*/
function ETAttitude TAttitudeTo(Actor Other)
	{
	local ETAttitude att;
	
	att = Super.TAttitudeTo(Other);
	if((att==ETAT_Hate || att==ETAT_Fear) && Other.IsA('TMachine'))
		return ETAT_Ignore;
	else
		return att;
	}
	
/*----------------------------------------------------------------
Some generic stuff for all creatures.
----------------------------------------------------------------*/
function ETAttitude TAttitudeToIgnoreTeam(Actor Other)
	{
	// If Other is one of me, be friendly
	if(Other.IsA(Class.Name))
		return ETAT_Friendly;
	}


/*----------------------------------------------------------------
Anims.
----------------------------------------------------------------*/

// The bot has been cracked, and is rubbing his eyes or stumbling
//  about a bit or whatever
function PlayCracked()
	{
	// Who can tell if a creature's blinded or cracked?  not me.  probably
	PlayBlinded();
	}

/*----------------------------------------------------------------
----------------------------------------------------------------*/

