//-----------------------------------------------------------
//
//-----------------------------------------------------------
class ThProAIDirectorInfo expands Info;

function OrderBot(ThieveryProPawn orderer, TBaseBot orderTarget, int orderNum)
{
    // ReceiveOrders(Name NewOrders, optional Pawn sender, optional Actor orderObj) {
	switch (OrderNum) {
		case 0:
			orderTarget.ReceiveOrders('GuardHere', orderer); // guard here
			break;
		case 1:
			orderTarget.ReceiveOrders('Wander',orderer); // follow me
			break;
		case 2:
			orderTarget.ReceiveOrders('Roam', orderer); //wander
			break;
		case 3:
			orderTarget.ReceiveOrders('StandDown', orderer);
			break;
		case 4:
			orderTarget.ReceiveOrders('Guard', orderer, orderer); // follow me
			break;
		case 5:
			break;
	}
}

function OrderBotPatrol(ThieveryProPawn orderer, TBaseBot orderTarget, int patrolNum)
{
    local ThieveryPPawn tpp;
	local Actor p;
	local ThieveryDeathMatchPlus game;
	local ThieveryGameReplicationInfo GRI;

	GRI = ThieveryGameReplicationInfo(level.Game.GameReplicationInfo);
	if (GRI!=none) {
		// find the point for this routename
		p = orderTarget.FindBestPatrolPoint(GRI.PatrolRouteName[patrolNum]);
		// tell the bot to patrol it
		if (p == none) {
			log("[BotPatrolOrderOption] Couldn't FindBestPatrolPoint for option "$patrolnum$" named:"$GRI.PatrolRouteName[patrolnum]$" self="$self$" orderingbot="$ordertarget);
		} else {
			ordertarget.ReceiveOrders('Patrol',orderer,p);
		}
	}
}

DefaultProperties
{
   RemoteRole=ROLE_None
}