//-----------------------------------------------------------
// ThieveryProMod - ThProBroadheadArrow by Immortius
// Fixes the scaling of arrow damage with velocity
//-----------------------------------------------------------
class ThProBroadheadArrow expands ThProjectileBroadheadArrow;

simulated function ProcessTouch( Actor Other, Vector HitLocation ) {
    local int hitdamage;
	local float dotproduct;

	if ( Other != self && Other != MOwner && !HasLanded && Other!=Owner && !Other.IsA('ThLadder'))
    {
		if ( Role == ROLE_Authority )
        {
			if (VSize(Velocity)<1300)
            {
				hitdamage=FClamp( ( (VSize(Velocity)-700)/600.0 ) * damage * 0.75, 1, damage);
			}
            else
            {
				hitdamage=damage;
			}

			if ((Other.IsA('Pawn')) && (Pawn(Other).PlayerReplicationInfo!=none) && (Pawn(Other).PlayerReplicationInfo.Team==1))
            {
				dotproduct=
                    (Normal(HitLocation-Other.Location) * vect(1,1,0))
					   dot
					(vector(Other.Rotation) * vect(1,1,0)); // how near the front the attack is
				if (dotproduct<-cos(Pi * 0.5 * class'ThieveryProModSettings'.default.broadheadRearArcSize / 180))
                {
                    Other.TakeDamage(hitdamage * class'ThieveryProModSettings'.default.broadheadRearHitDamageMultiplier, instigator,HitLocation,	(MomentumTransfer * Normal(Velocity)), 'RangedArrow');
				} else {
					Other.TakeDamage(hitdamage, instigator,HitLocation, (MomentumTransfer * Normal(Velocity)), 'RangedArrow');
				}
			}
            else
            {
				Other.TakeDamage(hitdamage, instigator,HitLocation, (MomentumTransfer * Normal(Velocity)), 'RangedArrow');
			}
			if (Other.IsA('PlayerPawn'))
            {
				spawn(class 'UT_BloodBurst',Owner,,Location);
			}
		}

		if (Other.IsA('PlayerPawn'))
        {
			PlaySound(sound'ThieveryData.gibP1simple');
		}

		Destroy();
	}
}

DefaultProperties
{

}