//-----------------------------------------------------------
// ThieveryProMod - ThProCarcass by Immortius
// Carcass that allows for a minimum frob wakeup time
//-----------------------------------------------------------
class ThProCarcass expands ThObjectCarcass;

var float CanFrobAwakeTime;

function Initfor(actor Other)
{
    super.Initfor(other);
    CanFrobAwakeTime = Level.TimeSeconds + class'ThieveryProModSettings'.default.MinFrobWakeupTime;
}

function frob (Actor Frobber, Actor FrobItem) {

	if (!class'ThieveryProModSettings'.default.bUseMinFrobWakeupTime || Level.TimeSeconds > CanFrobAwakeTime)
	{
        if (class'ThieveryGameSettings'.default.bCanFrobWakeUp && Pawn(Frobber)!=none && Pawn(Frobber).PlayerReplicationInfo!=none && Pawn(Frobber).PlayerReplicationInfo.Team==1 && bStillAlive) {
		    if (GuardName!="")
		    {
			    Pawn(Frobber).ClientMessage("You wake up "$GuardName$".");
            }

		    Awaken();
		    return;
		}
	}

	// reset corpse to visible when picked up
	Style=STY_Normal;
	ScaleGlow=0.5;
	bLootedSomething=false;
	if (NoKeys()) {
		if (Loot>0) {
			ThieveryPPawn(Frobber).Loot+=Loot;
			ThieveryPlayerReplicationInfo(ThieveryPPawn(Frobber).PlayerReplicationInfo).Loot=ThieveryPPawn(Frobber).Loot;
			ThieveryPPawn(Frobber).ClientPlayFrobSound(Sound'ThieveryData.pickloot');
			Loot=0;
		}
		Super(ThObjectDebris).frob(Frobber,Frobitem);
	} else {
		if (Pawn(Frobber)!=none) {
			StealItems(Pawn(Frobber));
			if (bLootedSomething) {
				LootBodyMessage=LootBodyMessage$".";
				Pawn(Frobber).ClientMessage(LootBodyMessage);
			}
		}
	}
}