//-----------------------------------------------------------
// ThieveryProMod - ThProCrackEffect by Immortius
// Replacement crack effect that properly scales with FPS
//-----------------------------------------------------------
class ThProCrackEffect expands OnCrackEffect;

simulated function Tick(float deltatime) {
	local rotator crackRotator;
	// do crack blurring
	if (Owner.isA('PlayerPawn')) {
		crackValue+=(30+Rand(20))*deltatime;
		if (crackValue>40) crackValue-=40;
		if (crackValue<20) {
			PlayerPawn(Owner).ConstantGlowFog.Y=(crackValue/20.0)*0.5+0.3;
		} else {
			PlayerPawn(Owner).ConstantGlowFog.Y=((40-crackValue)/20.0)*0.5+0.3;
		}
		crackRotator.Yaw=cos(((crackValue/20.0)-1.0)*6.2832)*1400.0 * deltaTime * 100;
		crackRotator.Pitch=sin(((crackValue/20.0)-1.0)*6.2832)*1400.0 * deltaTime * 100;

		Pawn(Owner).ViewRotation+=crackRotator;
		Pawn(Owner).FOVAngle=120+FRand()*40;
		if (Owner.IsA('ThieveryPPawn'))
        {
			ThieveryPPawn(Owner).bOnCrack=true;
		}
	} else {
		Destroy();
	}
}

state FadingOut {

	simulated function Tick(float deltatime) {
		local rotator crackRotator;

		if (Owner.isA('PlayerPawn')) {
			FadeOutTime-=deltatime;
			SoundVolume=(FadeOutTime/5.0)*255;
			crackValue+=(30+Rand(20))*deltatime;
			if (crackValue>40) crackValue-=40;
			if (crackValue<20) {
				PlayerPawn(Owner).ConstantGlowFog.Y=((crackValue/20.0)*0.5+0.3)*(FadeOutTime/5.0)* deltaTime * 100;
			} else {
				PlayerPawn(Owner).ConstantGlowFog.Y=(((40-crackValue)/20.0)*0.5+0.3)*(FadeOutTime/5.0)* deltaTime * 100;
			}
			crackRotator.Yaw=cos(((crackValue/20.0)-1.0)*6.2832)*4000.0;
			crackRotator.Pitch=sin(((crackValue/20.0)-1.0)*6.2832)*4000.0;
			crackRotator*=(FadeOutTime/5.0);
			Pawn(Owner).ViewRotation+=crackRotator;
		} else {
			Destroy();
		}
	}
}

DefaultProperties
{

}