//-----------------------------------------------------------
// ThieveryProMod - ThProFireBolt by Immortius
//
//-----------------------------------------------------------
class ThProFireBolt expands ThProjectileFireBolt;

function BeginPlay() {
	super(ThieveryProjectileBolts).BeginPlay();
	if (Region.Zone.bWaterZone) {
		destroy();
		return;
	}

	if (MyFlame==none) {
    		MyFlame=spawn(class'ThieveryMod.FireArrowFlameGenerator');
		MyFlame.AttachedTo=self;
	}
	PlaySound(Sound'UnrealShare.Pickups.flares1',SLOT_None);

}

function DoExplosion() {
	local UT_SpriteBallExplosion s;
	local Actor a;
	local int i, limit;
	local vector v, hitloc, hitnorm;
	local Generator MyGen;
	local ThieveryTorchTrigger tt;
	local Class<ThFlameGenerator> flameClass;

	if (bExploded) return;

	bExploded=true;

	   flameClass=class'ThProFireBoltFlame';
	   s = spawn(class'ThSpriteBallExplosion');

	foreach RadiusActors(class'ThieveryTorchTrigger',tt,300) {
		tt.Relight(Owner);
	}

	// set players in the radius on fire
	foreach RadiusActors(class'Actor',a,100) {
		if (a.bCollideActors && FastTrace(Location, a.Location)) {
			if (a.IsA('Pawn') && !a.IsA('ScriptedPawn')) {
				SetFireTo(Pawn(a));
			} else {
				a.TakeDamage(50, Instigator, Location, Velocity, 'Fire');
			}
		}
	}

	// spawn a few random flames in the radius
	for (i=0;i<3;i++) {
		limit=0; a=none;

		while (a==none && limit<25) {
			v=VRand()*80;
			a=Trace(hitloc, hitnorm, Location+v, Location, false);

			if (a!=none) {
				MyGen=spawn(flameClass, Instigator, '', Location);
				MyGen.Velocity=VRand()*200;
				MyGen.Velocity.Z=300;
				MyGen.SetPhysics(PHYS_Falling);

                MyGen=spawn(flameClass, Instigator, '', hitloc);
				if (MyGen!=none) {
					MyGen.LightRadius=3;
				}
			}
			limit++;
		}
	}
}

// spawn 3 burning flames and attach them to this player
function SetFireTo(Pawn P) {
	local Generator MyGen;
	local int i;

	for (i=0;i<2;i++) {
	        MyGen=spawn(class'ThProFireBoltFlame');
		

		if (MyGen!=none) {
			FireArrowFlameGeneratorPainful(MyGen).AttachedTo=P;
			FireArrowFlameGeneratorPainful(MyGen).offset=VRand()*P.CollisionRadius;
			MyGen.Instigator=Instigator;
			if (i>0) {	// only make the first flame emit light so as not to create too many dynamic lights
				MyGen.LightType=LT_None;
			}
		}
	}
}

DefaultProperties
{
    speed=600.000000
}