//-----------------------------------------------------------
//
//-----------------------------------------------------------
class ThProFireBoltFlame expands FireArrowFlameGeneratorPainful;

// spawn 2 burning flames and attach them to this player
function SetFireTo(Pawn P) {
	local Generator MyGen;
	local int i;

	for (i=0;i<2;i++) {
		MyGen=spawn(class'ThProFireBoltFlame');
		if (MyGen!=none) {
		    MyGen.LifeSpan = FMax(0.1, LifeSpan);
			FireArrowFlameGeneratorPainful(MyGen).AttachedTo=P;
			FireArrowFlameGeneratorPainful(MyGen).offset=VRand()*P.CollisionRadius;
			MyGen.Instigator=Instigator;
			if (i>0) {	// only make the first flame emit light so as not to create too many dynamic lights
				MyGen.LightType=LT_None;
			}
		}
	}
}

//Thievery Tenth: Add in moss burning abilities to the flame.
simulated function Touch(Actor Other) {
	if (Role==ROLE_Authority) {
		if (Other!=AttachedTo && Other.IsA('Pawn') && !IsOnFire(Pawn(other))) {
			SetFireTo(Pawn(Other));
	//log("Moss touched:"$Other);
	} else if (Other.IsA('ThObjectMossPiece')) {
		Other.Destroy();
		} 
     }
}


function DestroyNearbyCaltrops() {
	local ThObjectMossPiece o;
	foreach RadiusActors(class'ThObjectMossPiece',o,CollisionRadius) {
		o.Destroy();
	}
}
//Thievery Tenth: End of Changes!!

DefaultProperties
{
}