// ============================================================
// ThieveryProMod - ThProHud by Immortius
//
// Changes:
// - Fixed flash effect not being rendered in some circumstances
// ============================================================

class ThProHud expands ThieveryChallengeTeamHUD;

var bool flashRendered;

simulated function PostRender( canvas Canvas )
{
    local ThieveryPPawn tpp;
    flashRendered = false;
    super.PostRender(Canvas);
    if (!flashRendered)
    {
       tpp=ThieveryPPawn(PlayerOwner);
       if (tpp==none || tpp.GetStateName()=='GameEnded') return;
       DrawFlashbombBlindness(Canvas, tpp);
    }
}

simulated function DrawFlashbombBlindness(Canvas Canvas, ThieveryPPawn tpp) {
    flashRendered = true;
    super.DrawFlashbombBlindness(Canvas, tpp);
}

simulated function Tick(float DeltaTime) {
	local ThieveryProPawn tpp;
	if ( (PawnOwner == None) || (PlayerOwner.PlayerReplicationInfo == None) )
		return;

	tpp=ThieveryProPawn(PlayerOwner);
	if (tpp.bUseNewFlashCalculation)
	{
	   if ( (tpp.Weapon==none) || ( (tpp.Weapon!=None) && (tpp.Weapon.bMeleeWeapon) ) ) {
		CurrentCrossHairBrightness=FMin(CrosshairBrightness,CurrentCrossHairBrightness+deltatime*CrossHairBrightness*2);
	   } else {
		CurrentCrossHairBrightness=FMax(0,CurrentCrossHairBrightness-deltatime*CrossHairBrightness*2);
	   }

	   // Use simple linear decay to simplify balancing.
	   if (tpp.Blindness>0)
       {
		  tpp.Blindness -= 40 * Deltatime;
		  if (tpp.Blindness<0) tpp.Blindness = 0;
	   }
	}
	else
	{
	   super.tick(deltaTime);
	}
}


simulated function DrawPotionEffects(Canvas C) {
	local ThieveryProPawn tpp;
	local string msg;
	local float width, height;
	local int y;

	tpp=ThieveryProPawn(PlayerOwner);
	if (tpp==none)
	{
	    super.DrawPotionEffects(C);
	    return;
	}

	C.Reset();
	C.Style=3; //Canvas.font=Font'CarletonFont.Carleton8';
	C.font=C.SmallFont;
	y=0;

	if (tpp.bOnInvisibility) {
		msg="Invisible:"$int(tpp.InvisibilityPotionDuration);
		C.StrLen(msg, width, height);
		C.SetPos((1250*Scale)-width,C.ClipY-(256+12*y)*Scale);
		C.DrawText(msg); y++;
	}
	if (tpp.bOnSpeed) {
		msg="Speed:"$int(tpp.SpeedPotionDuration);
		C.StrLen(msg, width, height);
		C.SetPos((1250*Scale)-width,C.ClipY-(256+12*y)*Scale);
		C.DrawText(msg); y++;
	}
	if (tpp.bOnCatfall) {
		msg="Catfall:"$int(tpp.CatfallPotionDuration);
		C.StrLen(msg, width, height);
		C.SetPos((1250*Scale)-width,C.ClipY-(256+12*y)*Scale);
		C.DrawText(msg); y++;
	}
	if (tpp.bOnParalysed) {
		msg="Paralysed:"$int(tpp.ParalysedDuration);
		C.StrLen(msg, width, height);
		C.SetPos((1250*Scale)-width,C.ClipY-(256+12*y)*Scale);
		C.DrawText(msg); y++;
	}
	if (tpp.bOnCrackImmune)
	{
       msg="Holding Breath:"$int(tpp.breathPotionDuration);
	   C.StrLen(msg, width, height);
	   C.SetPos((1250*Scale)-width,C.ClipY-(256+12*y)*Scale);
	   C.DrawText(msg); y++;
	}
}

// Remove AI Positions
simulated function DrawPlayerPosition(Canvas C) {
	local float cx, cy, xrange, yrange, selfsize;
	local texture icontexture;
	local int i;
	local ThieveryPPawn tpp;
	local bool showAI;

	// check a map with player locations shown exists
	if (SketchMapInfo==none || !SketchMapInfo.bShowPlayerLocation)
		return;

	if (SketchMapInfo.LocationToPixel(PawnOwner.Location, C, cx, cy)) {
		selfsize=64*(cos((Level.TimeSeconds % 1.0)*6.2832)/4.0+2.5);
		C.Reset();
		C.SetPos(cx-16*Scale-Scale*(selfsize/4.0),cy-16*Scale-Scale*(selfsize/4.0));
		C.font=c.smallfont;
		//C.DrawText("X");
		if (PawnOwner.PlayerReplicationInfo.Team==0)
			icontexture=texture'ThiefLocationIcon';
		else
			icontexture=texture'GuardLocationIcon';

		c.DrawIcon(icontexture, Scale*(selfsize/64.0));
		c.SetPos(cx+Scale*4, cy-Scale*24);
		C.DrawColor.R=128; C.DrawColor.G=128; C.DrawColor.B=128;
		C.DrawText(PawnOwner.PlayerReplicationInfo.PlayerName);
		c.SetPos(cx+Scale*4+1, cy-Scale*24+1);
		C.DrawColor.R=0; C.DrawColor.G=0; C.DrawColor.B=0;
		C.DrawText(PawnOwner.PlayerReplicationInfo.PlayerName);
	}

	tpp=ThieveryPPawn(PawnOwner);
	showAI = (tpp.ScoringType != class'ThProScoreBoard');

	if (tpp!=none && SketchMapInfo.bShowTeamMates) {

		if (PawnOwner.PlayerReplicationInfo.Team==0)
			icontexture=texture'ThiefLocationIcon';
		else
			icontexture=texture'GuardLocationIcon';

		for (i=0;i<16;i++) {
			if (tpp.TeamMate[i]!=none && (showAI || !tpp.TeamMate[i].bIsABot) && SketchMapInfo.LocationToPixel(tpp.TeamMateLocation[i], C, cx, cy)) {
				C.Reset();
				C.SetPos(cx-Scale*32,cy-Scale*32);
				C.font=c.smallfont;
				c.DrawIcon(icontexture, Scale);
				c.SetPos(cx+Scale*4, cy-Scale*24);
				C.DrawColor.R=128; C.DrawColor.G=128; C.DrawColor.B=128;
				C.DrawText(tpp.TeamMate[i].PlayerName);
				c.SetPos(cx+Scale*4+1, cy-Scale*24+1);
				C.DrawColor.R=0; C.DrawColor.G=0; C.DrawColor.B=0;
				C.DrawText(tpp.TeamMate[i].PlayerName);
			}
		}

	}

	if (tpp.PlayerReplicationInfo.Team==1 && tpp.ChestLocation.X!=-1) {	// show supply chest
		if (SketchMapInfo.LocationToPixel(tpp.ChestLocation, C, cx, cy)) {
			C.Reset();
			C.SetPos(cx-Scale*32,cy-Scale*32);
			C.DrawIcon(texture'ThieveryMod.LootSpawner', Scale);
		}
	}
}

simulated function DisplayTeamSizes(Canvas Canvas) {
	local float scl, XL, YL;
	local string s;
	local ThieveryGameReplicationInfo GRI;
	local ThProGRI proGRI;

   	scl=Canvas.ClipX/1280.0;
	Canvas.DrawColor = WhiteColor;
	Canvas.Font=MyFontMedium;

	GRI=ThieveryGameReplicationInfo(ThieveryPPawn(Owner).GameReplicationInfo);
	proGRI=ThProGRI(gri);
	if (proGRI != none && proGRI.usingWaves)
	{
        s="Wave: "$(proGRI.wave + 1)$" of "$(proGRI.totalWaves + 1);
	}
	else
	{
	   s="Players:"$GRI.CurrentThiefCount$" Lives:"$GRI.MaxThiefCount;
	}
    Canvas.StrLen(s, XL, YL);
    Canvas.SetPos(320*scl-XL/2.0,Canvas.ClipY-YL*1.0);
    Canvas.DrawText(s, true);

	s="Players:"$GRI.CurrentGuardCount$" Lives:"$GRI.MaxGuardCount;
	Canvas.StrLen(s, XL, YL);
	Canvas.SetPos(960*scl-XL/2.0,Canvas.ClipY-YL*1.0);
	Canvas.DrawText(s, true);
}

defaultproperties
{
}
