//-----------------------------------------------------------
//
//-----------------------------------------------------------
class ThProLimitGuardOrders expands ThProAIDirectorInfo;

var int minGuardingLimit;
var int maxGuardingLimit;
var int guardingPenaltyPerPlayer;

function OrderBot(ThieveryProPawn orderer, TBaseBot orderTarget, int orderNum)
{
    local Pawn pawn;
    local TBaseBot bot;
    local int guardAI, randGuard, currentGuard;

    // ReceiveOrders(Name NewOrders, optional Pawn sender, optional Actor orderObj) {
	switch (OrderNum) {
		case 0:

		    if (orderTarget.GetBotsOrders() == 'guardhere')
		    {
			    orderTarget.ReceiveOrders('GuardHere', orderer); // guard here
			    return;
			}

			// Unorder guarding ai
			guardAI = GuardingAI();
			while (guardAI >= GuardingLimit())
            {
                randGuard = Rand(guardAI);
                currentGuard = 0;
                for (pawn = level.PawnList; pawn != none; pawn = pawn.nextPawn) {
                    bot = TBaseBot(pawn);
                    if (bot != none && pawn.PlayerReplicationInfo.Team == 1 && bot.GetBotsOrders() == 'guardHere' && bot.Health > 0)
                    {
                        if (currentGuard == randGuard)
                        {
                            bot.ReceiveOrders('', orderer);
                            break;
                        }
                        currentGuard++;
                    }
                }
                guardAI--;
			}

            if (guardAI < GuardingLimit())
            {
                orderTarget.ReceiveOrders('GuardHere', orderer);
            }

			break;
		case 1:
			orderTarget.ReceiveOrders('Wander',orderer); // follow me
			break;
		case 2:
			orderTarget.ReceiveOrders('Roam', orderer); //wander
			break;
		case 3:
			orderTarget.ReceiveOrders('StandDown', orderer);
			break;
		case 4:
			orderTarget.ReceiveOrders('Guard', orderer, orderer); // follow me
			break;
		case 5:
			break;
	}
}

function int GuardingAI()
{
    local Pawn pawn;
    local TBaseBot bot;
    local int guarding;


    for (pawn = level.PawnList; pawn != none; pawn = pawn.nextPawn) {
        bot = TBaseBot(pawn);
        if (bot != none && pawn.PlayerReplicationInfo.Team == 1 && bot.GetBotsOrders() == 'guardHere' && bot.Health > 0)
        {
            guarding++;
        }
    }

    return guarding;
}

function int GuardingLimit()
{
    local Pawn pawn;
    local int humanGuards;

    for (pawn = level.PawnList; pawn != none; pawn = pawn.nextPawn) {
        if (ThieveryPPawn(pawn) != none && pawn.PlayerReplicationInfo.Team == 1) {
            humanGuards++;
        }
    }

    return max(minGuardingLimit, maxGuardingLimit - guardingPenaltyPerPlayer * humanGuards + 1);
}

DefaultProperties
{
    guardingPenaltyPerPlayer=1
    minGuardingLimit=1
    maxGuardingLimit=5
}