//-----------------------------------------------------------
//
//-----------------------------------------------------------
class ThProLitFlare expands ThObjectBurningFlare;

auto state Activated  // Delete from inventory and toss in front of player.
{
	function Timer()
	{
		local ThieveryPPawn tpp;
		local TBot tbot;
		//log("Bflare] tick ch:"$Charge$" location:"$Location);
		tpp=ThieveryPPawn(Owner);
		tbot=TBot(Owner);

		if( bFirstTick || LightType!=LT_Steady)
		{
			if (Region.Zone.bWaterZone) {
				PutOutFlare();
				return;
			}

			//log("Bflare] first");
			if (!bPlayedSound) {
				bPlayedSound=true;
				PlaySound(ActivateSound);
				SetTimer(1.0,True);
			}

			RemoteRole=ROLE_DumbProxy;
			bFirstTick=False;
			PlayAnim('out',0.1);

			if (((tpp!=none) && (tpp.HeldItem==self))
                || ((tbot != none) && (tbot.HeldFlare==self))) {
				LightupHeldItem();
			} else {
				DarkenHeldItem();
			}

			AmbientSound = sound'flarel1';
		}
		Charge--;
		if (Charge<=0) {
			PutOutFlare();

		}
	}

	function PutOutFlare() {
		local ThieveryPPawn tpp;
		local TBot tbot;
		local vector v;

		//log("[Flare] PutOutFlare() Owner="$Owner$" tpp.HeldItem="$ThieveryPPawn(Owner).HeldItem);
		tpp=ThieveryPPawn(Owner);
		tbot=TBot(Owner);
		if ((tpp!=none) && (tpp.HeldItem!=none && tpp.HeldItem==self)) {	// check if player is holding this flare as it burns out
			tpp.HeldItem=none;
			tpp.ClearWeaponNoneMesh();
			tpp.SelectedItem=none;
			v=tpp.Location+vector(tpp.Rotation)*40;
			DarkenHeldItem();
		}
        else if ((tbot != none) && (tbot.HeldFlare == self))
        {
			DarkenHeldItem();

        }
        spawn(class'UT_SpriteSmokePuff',,,v);
			Destroy();
	}
}

function LightUpHeldItem() {
	local ThieveryPPawn tpp;
	local TBot tbot;

	tpp=ThieveryPPawn(Owner);
	tbot=TBot(Owner);
	if ((tpp!=none && tpp.HeldItemEffect!=none)) {
		if (!bFirstTick) {
			tpp.HeldItemEffect.LightType = LT_Steady;
			tpp.HeldItemEffect.LightBrightness = 192;
			tpp.HeldItemEffect.LightRadius = 8;
			tpp.HeldItemEffect.LightSaturation = 110;
			tpp.HeldItemEffect.LightHue = 90;
			tpp.HeldItemEffect.AmbientGlow = 200;
		}
		LightType=LT_None;
		AmbientGlow=default.AmbientGlow;
	}

	if (tbot!= none && tbot.HeldItemEffect != none)
	{
	    if (!bFirstTick) {
			tbot.HeldItemEffect.LightType = LT_Steady;
			tbot.HeldItemEffect.LightBrightness = 192;
			tbot.HeldItemEffect.LightRadius = 8;
			tbot.HeldItemEffect.LightSaturation = 110;
			tbot.HeldItemEffect.LightHue = 90;
			tbot.HeldItemEffect.AmbientGlow = 200;
		}
		LightType=LT_None;
		AmbientGlow=default.AmbientGlow;
	}
}

function DarkenHeldItem() {
	local ThieveryPPawn tpp;
	local TBot tbot;

	tpp=ThieveryPPawn(Owner);
	tbot=TBot(Owner);
	if (tpp!=none && tpp.HeldItemEffect!=none) {
		tpp.HeldItemEffect.LightType = LT_None;
		tpp.HeldItemEffect.AmbientGlow = tpp.HeldItemEffect.default.AmbientGlow;
	}
	if (tbot!=none && tbot.HeldItemEffect != none)
	{
	   tbot.HeldItemEffect.LightType = LT_None;
	   tbot.HeldItemEffect.AmbientGlow = tbot.HeldItemEffect.default.AmbientGlow;
	}

	if (!bFirstTick) {
		LightType = LT_Steady;
		LightBrightness = 192;
		LightRadius = 3;
		LightSaturation = 110;
		LightHue = 90;
		AmbientGlow = 200;
	}
}


DefaultProperties
{

}