//-----------------------------------------------------------
// ThieveryProMod - ThProMutator by Immortius
// Enables ThieveryPro. Can be added as a server actor,
// in which case it installs itself as a mutator each map
//-----------------------------------------------------------
class ThProMutator expands Mutator;

var ThProAIDirectorInfo aiDirector;

event PreBeginPlay()
{
    local TBot bot;
    local ThProCarcassReplacer carcassReplacer;
    local ThProShopSpawnNotify shopSpawnNotifier;

    Log("Thievery Pro Mod - by Immortius (" $ class $")");
    Log("Initialising...");
    Log("Current settings:");
    Log("bUseMinFrobWakeupTime: "$ class'ThieveryProModSettings'.default.bUseMinFrobWakeupTime);
    if (class'ThieveryProModSettings'.default.bUseMinFrobWakeupTime)
    {
        Log("MinFrobWakeupTime: "$ class'ThieveryProModSettings'.default.MinFrobWakeupTime);
    }
    Log("bAllowBehindView: "$ class'ThieveryProModSettings'.default.bAllowBehindView);
    Log("broadheadRearArcSize: "$ class'ThieveryProModSettings'.default.broadheadRearArcSize);
    Log("broadheadRearHitDamageMultiplier: "$ class'ThieveryProModSettings'.default.broadheadRearHitDamageMultiplier);
    Log("bUseProModSoundSystem: "$ class'ThieveryProModSettings'.default.bUseProModSoundSystem);
    Log("lockpickSoundRadius: "$ class'ThieveryProModSettings'.default.lockpickSoundRadius);
    Log("bUseSilentCreepMovement: "$ class'ThieveryProModSettings'.default.bUseSilentCreepMovement);
    Log("bIncreaseSupplyChestRespawnTimeWithPlayerCount: "$class'ThieveryProModSettings'.default.bIncreaseSupplyChestRespawnTimeWithPlayerCount);
    Log("bBreathPotionsGiveCrackImmunity: " $ class'ThieveryProModSettings'.default.bBreathPotionsGiveCrackImmunity);
    Log("breathPotionCost: " $ class'ThieveryProModSettings'.default.breathPotionCost);
    Log("breathPotionItemLimit: " $ class'ThieveryProModSettings'.default.breathPotionItemLimit);
    Log("bUseNewFlashCalculation: " $ class'ThieveryProModSettings'.default.bUseNewFlashCalculation);
    if (class'ThieveryProModSettings'.default.bUseNewFlashCalculation)
    {
        Log("flashRadius: " $ class'ThieveryProModSettings'.default.flashRadius);
        Log("maxFlashTime: " $ class'ThieveryProModSettings'.default.maxFlashTime);
        Log("selfFlashModifier: "$class'ThieveryProModSettings'.default.selfFlashModifier);
    }
    Log("flashBombCost: " $ class'ThieveryProModSettings'.default.flashBombCost);
    Log("flashBombItemLimit: " $ class'ThieveryProModSettings'.default.flashBombItemLimit);
    Log("bUseNewBJ: " $ class'ThieveryProModSettings'.default.bUseNewBJ);
    Log("bSilentCatPotions: " $ class'ThieveryProModSettings'.default.bSilentCatPotions);
    Log("catfallDuration: " $ class'ThieveryProModSettings'.default.catfallDuration);
    Log("catfallPotionCost: " $ class'ThieveryProModSettings'.default.catfallPotionCost);
    Log("catfallPotionItemLimit: " $ class'ThieveryProModSettings'.default.catfallPotionItemLimit);
    Log("balancedSpeedPots: " $ class'ThieveryProModSettings'.default.balancedSpeedPots);
    Log("reduceFlareRadiusWhenThrown: " $ class'ThieveryProModSettings'.default.reduceFlareRadiusWhenThrown);
    Log("bUseNewFireBolts: " $ class'ThieveryProModSettings'.default.bUseNewFireBolts);
    Log("bLimitAIInfo: " $ class'ThieveryProModSettings'.default.bLimitAIInfo);
    Log("bReplaceDecoyWithRuse: "$ class'ThieveryProModSettings'.default.bReplaceDecoyWithRuse);
    Log("bPreventOverlappingPotionEffects: "$ class'ThieveryProModSettings'.default.bPreventOverlappingPotionEffects);
    Log("crackLifespan: "$ class'ThieveryProModSettings'.default.crackLifespan);
    Log("bSilentInvisPotions: " $ class'ThieveryProModSettings'.default.bSilentInvisPotions);
    Log("invisPotionCost: " $ class'ThieveryProModSettings'.default.invisPotionCost);
    Log("invisPotionItemLimit: " $ class'ThieveryProModSettings'.default.invisPotionItemLimit);
    Log("speedPotionCost: " $ class'ThieveryProModSettings'.default.speedPotionCost);
    Log("speedPotionItemLimit: " $ class'ThieveryProModSettings'.default.speedPotionItemLimit);
    Log("healthPotionCost: " $ class'ThieveryProModSettings'.default.healthPotionCost);
    Log("healthPotionItemLimit: " $ class'ThieveryProModSettings'.default.healthPotionItemLimit);
    Log("thiefSwordCost: " $ class'ThieveryProModSettings'.default.thiefSwordCost);
    Log("guardSwordCost: " $ class'ThieveryProModSettings'.default.guardSwordCost);
    Log("maceCost: " $ class'ThieveryProModSettings'.default.maceCost);
    Log("bLimitGuardingAI: " $ class'ThieveryProModSettings'.default.bLimitGuardingAI);
    if (class'ThieveryProModSettings'.default.bLimitGuardingAI)
    {
         Log("minGuardingAI: " $ class'ThieveryProModSettings'.default.minGuardingAI);
         Log("maxGuardingAI: " $ class'ThieveryProModSettings'.default.maxGuardingAI);
         Log("guardingPenaltyPerPlayer: " $ class'ThieveryProModSettings'.default.guardingPenaltyPerPlayer);
    }

    carcassReplacer = spawn(class'ThProCarcassReplacer');
    carcassReplacer.mutator = self;
    spawn(class'ThProBowReplacer');
    spawn(class'ThProCrackArrowReplacer');
    spawn(class'ThProBroadheadArrowReplacer');
	
//Thievery Tenth: Add in weapon replacers.
	spawn(class'ThProTenCrossbowReplacer');
	spawn(class'ThProTenMaceReplacer');
	spawn(class'ThProTenSwordReplacer');
	spawn(class'ThProTenWaterArrowReplacer');
	spawn(class'ThProTenSpyOrbReplacer');
//Thievery Tenth: End of Changes!!
	
    if (class'ThieveryProModSettings'.default.bReplaceDecoyWithRuse)
    {
        spawn(class'ThProFootstepArrowReplacer');
    }
    if (class'ThieveryProModSettings'.default.bUseNewFireBolts)
    {
        spawn(class'ThProFireboltReplacer');
    }
    if (class'ThieveryProModSettings'.default.reduceFlareRadiusWhenThrown)
    {
        spawn(class'ThProFlareReplacer');
    }
    if (class'ThieveryProModSettings'.default.bIncreaseSupplyChestRespawnTimeWithPlayerCount)
    {
        spawn(class'ThProSupplyChestReplacer');
    }
    if (class'ThieveryProModSettings'.default.bUseNewBJ)
    {
        spawn(class'ThProBlackjackReplacer');
    }

    // Install self, for when added as server actor
    Level.Game.BaseMutator.AddMutator(self);

    if (Level.Game.HudType == class'ThieveryChallengeTeamHUD')
    {
        Level.Game.HudType = class'ThProHud';
	}

	foreach AllActors(class'TBot', bot)
	{
        ReplaceCarcassForBot(bot);
	}

	UpdateExistingShops();
	shopSpawnNotifier = spawn(class'ThProShopSpawnNotify');
	if (shopSpawnNotifier != none)
	{
	   shopSpawnNotifier.mutator = self;
	}

	if (class'ThieveryProModSettings'.default.bBreathPotionsGiveCrackImmunity)
	{
	    SetTimer(0.3, true);
	}

    if (class'ThieveryProModSettings'.default.bLimitGuardingAI)
    {
        aiDirector = spawn(class'ThProLimitGuardOrders');
        ThProLimitGuardOrders(aiDirector).maxGuardingLimit = class'ThieveryProModSettings'.default.maxGuardingAI;
        ThProLimitGuardOrders(aiDirector).minGuardingLimit = class'ThieveryProModSettings'.default.minGuardingAI;
        ThProLimitGuardOrders(aiDirector).guardingPenaltyPerPlayer = class'ThieveryProModSettings'.default.guardingPenaltyPerPlayer;
    }
    else
    {
	    aiDirector = spawn(class'ThProAIDirectorInfo');
	}
}

function PreCacheReferences()
{
	//never called - here to force precaching of meshes
	spawn(class'ThProWeaponSword');
}

function Mutate(string MutateString, PlayerPawn Sender)
{
    if (sender.bAdmin)
    {
        if (MutateString ~= "ProConfig")
        {
            ListConfig(sender);
        }
    }
	if ( NextMutator != None )
		NextMutator.Mutate(MutateString, Sender);
}

function ListConfig(PlayerPawn sender)
{
    Sender.ClientMessage("Current settings:");
    Sender.ClientMessage("bUseMinFrobWakeupTime: "$ class'ThieveryProModSettings'.default.bUseMinFrobWakeupTime);
    if (class'ThieveryProModSettings'.default.bUseMinFrobWakeupTime)
    {
        Sender.ClientMessage("MinFrobWakeupTime: "$ class'ThieveryProModSettings'.default.MinFrobWakeupTime);
    }
    Sender.ClientMessage("bAllowBehindView: "$ class'ThieveryProModSettings'.default.bAllowBehindView);
    Sender.ClientMessage("broadheadRearArcSize: "$ class'ThieveryProModSettings'.default.broadheadRearArcSize);
    Sender.ClientMessage("broadheadRearHitDamageMultiplier: "$ class'ThieveryProModSettings'.default.broadheadRearHitDamageMultiplier);
    Sender.ClientMessage("bUseProModSoundSystem: "$ class'ThieveryProModSettings'.default.bUseProModSoundSystem);
    Sender.ClientMessage("lockpickSoundRadius: "$ class'ThieveryProModSettings'.default.lockpickSoundRadius);
    Sender.ClientMessage("bUseSilentCreepMovement: "$ class'ThieveryProModSettings'.default.bUseSilentCreepMovement);
    Sender.ClientMessage("bIncreaseSupplyChestRespawnTimeWithPlayerCount: "$class'ThieveryProModSettings'.default.bIncreaseSupplyChestRespawnTimeWithPlayerCount);
    Sender.ClientMessage("bBreathPotionsGiveCrackImmunity: " $ class'ThieveryProModSettings'.default.bBreathPotionsGiveCrackImmunity);
    Sender.ClientMessage("breathPotionCost: " $ class'ThieveryProModSettings'.default.breathPotionCost);
    Sender.ClientMessage("breathPotionItemLimit: " $ class'ThieveryProModSettings'.default.breathPotionItemLimit);
    Sender.ClientMessage("bUseNewFlashCalculation: " $ class'ThieveryProModSettings'.default.bUseNewFlashCalculation);
    if (class'ThieveryProModSettings'.default.bUseNewFlashCalculation)
    {
        Sender.ClientMessage("flashRadius: " $ class'ThieveryProModSettings'.default.flashRadius);
        Sender.ClientMessage("maxFlashTime: " $ class'ThieveryProModSettings'.default.maxFlashTime);
        Sender.ClientMessage("selfFlashModifier: " $ class'ThieveryProModSettings'.default.selfFlashModifier);
    }
    Sender.ClientMessage("flashBombCost: " $ class'ThieveryProModSettings'.default.flashBombCost);
    Sender.ClientMessage("flashBombItemLimit: " $ class'ThieveryProModSettings'.default.flashBombItemLimit);
    Sender.ClientMessage("bUseNewBJ: " $ class'ThieveryProModSettings'.default.bUseNewBJ);
    Sender.ClientMessage("bSilentCatPotions: " $ class'ThieveryProModSettings'.default.bSilentCatPotions);
    Sender.ClientMessage("catfallDuration: " $ class'ThieveryProModSettings'.default.catfallDuration);
    Sender.ClientMessage("catfallPotionCost: " $ class'ThieveryProModSettings'.default.catfallPotionCost);
    Sender.ClientMessage("catfallPotionItemLimit: " $ class'ThieveryProModSettings'.default.catfallPotionItemLimit);
    Sender.ClientMessage("balancedSpeedPots: " $ class'ThieveryProModSettings'.default.balancedSpeedPots);
    Sender.ClientMessage("reduceFlareRadiusWhenThrown: " $ class'ThieveryProModSettings'.default.reduceFlareRadiusWhenThrown);
    Sender.ClientMessage("bUseNewFireBolts: " $ class'ThieveryProModSettings'.default.bUseNewFireBolts);
    Sender.ClientMessage("bLimitAIInfo: " $ class'ThieveryProModSettings'.default.bLimitAIInfo);
    Sender.ClientMessage("bReplaceDecoyWithRuse: "$ class'ThieveryProModSettings'.default.bReplaceDecoyWithRuse);
    Sender.ClientMessage("bPreventOverlappingPotionEffects: "$ class'ThieveryProModSettings'.default.bPreventOverlappingPotionEffects);
    Sender.ClientMessage("crackLifespan: "$ class'ThieveryProModSettings'.default.crackLifespan);
    Sender.ClientMessage("bSilentInvisPotions: " $ class'ThieveryProModSettings'.default.bSilentInvisPotions);
    Sender.ClientMessage("invisPotionCost: " $ class'ThieveryProModSettings'.default.invisPotionCost);
    Sender.ClientMessage("invisPotionItemLimit: " $ class'ThieveryProModSettings'.default.invisPotionItemLimit);
    Sender.ClientMessage("speedPotionCost: " $ class'ThieveryProModSettings'.default.speedPotionCost);
    Sender.ClientMessage("speedPotionItemLimit: " $ class'ThieveryProModSettings'.default.speedPotionItemLimit);
    Sender.ClientMessage("healthPotionCost: " $ class'ThieveryProModSettings'.default.healthPotionCost);
    Sender.ClientMessage("healthPotionItemLimit: " $ class'ThieveryProModSettings'.default.healthPotionItemLimit);
    Sender.ClientMessage("thiefSwordCost: " $ class'ThieveryProModSettings'.default.thiefSwordCost);
    Sender.ClientMessage("guardSwordCost: " $ class'ThieveryProModSettings'.default.guardSwordCost);
    Sender.ClientMessage("maceCost: " $ class'ThieveryProModSettings'.default.maceCost);
    Sender.ClientMessage("bLimitGuardingAI: " $ class'ThieveryProModSettings'.default.bLimitGuardingAI);
    if (class'ThieveryProModSettings'.default.bLimitGuardingAI)
    {
         Sender.ClientMessage("minGuardingAI: " $ class'ThieveryProModSettings'.default.minGuardingAI);
         Sender.ClientMessage("maxGuardingAI: " $ class'ThieveryProModSettings'.default.maxGuardingAI);
         Sender.ClientMessage("guardingPenaltyPerPlayer: " $ class'ThieveryProModSettings'.default.guardingPenaltyPerPlayer);
    }
}

event PostBeginPlay()
{
    ReplaceExistingPickups();
}

function ReplaceExistingPickups()
{
    local ThieveryPickup original;
    local ThieveryPickup replacement;

    foreach AllActors(class'ThieveryPickup', original)
    {
        if (!original.bNoDelete)
        {
            if (original.class == class'ThieveryMod.ThPickupPotionCatfall')
            {
                replacement = spawn(class'ThProPotionCatfall', original.owner,,original.location, original.rotation);
            }
            else if (original.class == class'ThieveryMod.ThPickupPotionBreath')
            {
                replacement = spawn(class'ThProPotionBreath', original.owner,,original.location, original.rotation);
            }
            else if (original.class == class'ThieveryMod.ThPickupPotionHealth')
            {
                replacement = spawn(class'ThProPotionHealth', original.owner,,original.location, original.rotation);
            }
            else if (original.class == class'ThieveryMod.ThPickupPotionInvisibility')
            {
                replacement = spawn(class'ThProPotionInvisibility', original.owner,,original.location, original.rotation);
            }
            else if (original.class == class'ThieveryMod.ThPickupPotionSpeed')
            {
                replacement = spawn(class'ThProPotionSpeed', original.owner,,original.location, original.rotation);
            }
            else if (original.class == class'ThieveryMod.ThPickupFlashBomb')
            {
                replacement = spawn(class'ThProFlashBomb', original.owner,,original.location, original.rotation);
            }


            if (replacement != none)
            {
                replacement.bGuardsNoFrob = original.bGuardsNoFrob;
                replacement.bThievesNoFrob = original.bThievesNoFrob;
                original.Destroy();
                replacement = none;
            }
        }
    }
}

function UpdateExistingShops()
{
    local ThieveryShop shop;
    foreach AllActors(class'ThieveryShop',shop)
    {
        ModifyShop(shop);
    }
}

function ModifyShop(ThieveryShop shop)
{
    local int i;

    if (shop == none) return;

    for (i = 0; i < 15; i++)
    {
        if (shop.Items[i].Item == class'ThPickupPotionBreath')
        {
            shop.Items[i].Item = class'ThProPotionBreath';
            shop.Items[i].Cost = class'ThieveryProModSettings'.default.breathPotionCost;
            shop.ItemsLimit[i] = class'ThieveryProModSettings'.default.breathPotionItemLimit;
        }
        else if (shop.Items[i].Item == class'ThPickupFlashbomb')
        {
            shop.Items[i].Item = class'ThProFlashBomb';
            shop.Items[i].Cost = class'ThieveryProModSettings'.default.flashBombCost;
            shop.ItemsLimit[i] = class'ThieveryProModSettings'.default.flashBombItemLimit;
        }
        else if (shop.Items[i].Item == class'ThPickupPotionCatfall')
        {
            shop.Items[i].Item = class'ThProPotionCatfall';
            shop.Items[i].Cost = class'ThieveryProModSettings'.default.catfallPotionCost;
            shop.ItemsLimit[i] = class'ThieveryProModSettings'.default.catfallPotionItemLimit;
        }
        else if (shop.Items[i].Item == class'ThPickupPotionHealth')
        {
            shop.Items[i].Item = class'ThProPotionHealth';
            shop.Items[i].Cost = class'ThieveryProModSettings'.default.healthPotionCost;
            shop.ItemsLimit[i] = class'ThieveryProModSettings'.default.healthPotionItemLimit;
        }
        else if (shop.Items[i].Item == class'ThPickupPotionInvisibility')
        {
            shop.Items[i].Item = class'ThProPotionInvisibility';
            shop.Items[i].Cost = class'ThieveryProModSettings'.default.invisPotionCost;
            shop.ItemsLimit[i] = class'ThieveryProModSettings'.default.invisPotionItemLimit;
        }
        else if (shop.Items[i].Item == class'ThPickupPotionSpeed')
        {
            shop.Items[i].Item = class'ThProPotionSpeed';
            shop.Items[i].Cost = class'ThieveryProModSettings'.default.speedPotionCost;
            shop.ItemsLimit[i] = class'ThieveryProModSettings'.default.speedPotionItemLimit;
        }

        if (shop.Melee[i].Item == class'ThWeaponSword')
        {
			//Thievery Tenth: Replace pro sword with ten sword.
            //shop.Melee[i].Item = class'ThProWeaponSword';
			shop.Melee[i].Item = class'ThProTenWeaponSword';
            if (ThieveryShopThieves(shop) != none)
            {
                shop.Melee[i].Cost = class'ThieveryProModSettings'.default.thiefSwordCost;
            }
            else if (ThieveryShopGuards(shop) != none)
            {
                shop.Melee[i].Cost = class'ThieveryProModSettings'.default.guardSwordCost;
            }
        }
        else if (shop.Melee[i].Item == class'ThWeaponMace')
        {
			//Thievery Tenth: Replace pro mace with ten mace.
            //shop.Melee[i].Item = class'ThProWeaponMace';
			shop.Melee[i].Item = class'ThProWeaponMace';
            shop.Melee[i].Cost = class'ThieveryProModSettings'.default.maceCost;
        }
    }
}

function ModifyLogin(out class<playerpawn> SpawnClass, out string Portal, out string Options)
{
    ThieveryGameReplicationInfo(Level.Game.GameReplicationInfo).LoadoutClass = class'ThieveryProModTenLoadout.ThProPlayerLoadouts';
    super.ModifyLogin(SpawnClass, Portal, Options);
    if (spawnClass == class'ThieveryPPawn')
    {
		//Thievery Tenth: Replace pro pawn with ten pawn.
        //spawnClass = class'ThieveryProPawn';
		spawnClass = class'ThProTenPawn';
    }
}

function ModifyPlayer(Pawn Other)
{
	//Thievery Tenth: Replace pro pawn with ten pawn.
	//local ThieveryProPawn player;
	local ThProTenPawn player;
	Log("Modifying player: "$other.PlayerReplicationInfo.PlayerName);

	super.ModifyPlayer(other);

	//Thievery Tenth: Replace pro pawn with ten pawn.
	//player = ThieveryProPawn(other);
	player = ThProTenPawn(other);
	if (player != none)
	{
        player.bAllowBehindView = class'ThieveryProModSettings'.default.bAllowBehindView;
        player.bUseProSoundSystem = class'ThieveryProModSettings'.default.bUseProModSoundSystem;
        player.bUseSilentMovement = class'ThieveryProModSettings'.default.bUseSilentCreepMovement;
        player.bUseNewFlashCalculation = class'ThieveryProModSettings'.default.bUseNewFlashCalculation;
        player.ropeHangFix = class'ThieveryProModSettings'.default.ropeHangMovementFix;
        player.balancedSpeedPots = class'ThieveryProModSettings'.default.balancedSpeedPots;
        player.aiDirector = aiDirector;
        return;
	}
    ReplaceCarcassForBot(TBot(other));
}

function bool ReplaceCarcassForBot(TBot bot)
{
    if (bot != none)
    {
        if (bot.CarcassType == class'ThObjectCarcass')
        {
            bot.CarcassType = class'ThProCarcass';
            return true;
        }
    }
    return false;
}

function AddMutator(Mutator M)
{
    if (M != self)
    {
        if (M.Class != class'ThProMutator')
        {
            super.AddMutator(M);
        }
        else
        {
            m.Destroy();
        }
    }
}

function Timer()
{
	local ThieveryProPawn tpp;
	local Pawn P;

	for (P=Level.PawnList; P!=None; P=P.nextPawn)
    {
        tpp=ThieveryProPawn(P);
		if (tpp!=none)
        {
            if (tpp.bOnCrackImmune)
            {
                tpp.BreathPotionDuration -= 0.3;
                if (tpp.BreathPotionDuration <= 0)
                {
                    tpp.bOnCrackImmune = false;
                }
            }
		}

	}
}

//Thievery Tenth: Replace all the AI knights on a map with our chosen model and settings.
function bool CheckReplacement(Actor A, out byte bSuperRelevant)
{
	local TKnight tk;

	if (A.IsA('TKnight'))
	{
		tk = TKnight(A);
		
		if (Level.Title == "Bourgeois" || Level.Title == "City Museum" || Level.Title == "Residency" || Level.Title == "Highway Inn" || Level.Title == "Nostalgia" || Level.Title == "The Theatre")
		{
			tk.Mesh = SkeletalMesh'ThTenth.ThCityGuardNewMesh';
			tk.MultiSkins[0]=Texture(DynamicLoadObject("ThTenth.Skins.ThCityGuardNewTex0", class'Texture'));
			tk.MultiSkins[1]=Texture(DynamicLoadObject("ThTenth.Skins.ThCityGuardNewTex1", class'Texture'));
			tk.MultiSkins[2]=none;
			tk.MultiSkins[3]=none;
		}
		else if (Level.Title == "Skeltston Head" || Level.Title == "Crows Nest")
		{
			tk.Mesh=LodMesh'ThieveryMod.ThSoldierMesh';
			tk.MultiSkins[0]=Texture(DynamicLoadObject("ThMuzGuard1.Skins.mtgrd1-1-1", class'Texture'));
			tk.MultiSkins[1]=Texture(DynamicLoadObject("ThMuzGuard1.Skins.mtgrd1-0-2", class'Texture'));
			tk.MultiSkins[2]=Texture(DynamicLoadObject("ThMuzGuard1.Skins.mtgrd1-0-3", class'Texture'));
			tk.MultiSkins[3]=Texture(DynamicLoadObject("ThMuzGuard1.Skins.mtgrd1-1-4", class'Texture'));
		}
		else if (Level.Title == "Souls Harbor")
		{
			tk.Mesh=LodMesh'ThieveryMod.ThSoldierMesh';
			tk.MultiSkins[0]=Texture(DynamicLoadObject("ThHauntSkins.Skins.hauntbody02", class'Texture'));
			tk.MultiSkins[1]=Texture(DynamicLoadObject("ThHauntSkins.Skins.hauntleg02", class'Texture'));
			tk.MultiSkins[2]=Texture(DynamicLoadObject("ThHauntSkins.Skins.hauntarm02", class'Texture'));
			tk.MultiSkins[3]=Texture(DynamicLoadObject("ThHauntSkins.Skins.hauntdone06", class'Texture'));
		}
		else
		{
			tk.Mesh=SkeletalMesh'ThTenth.TUT_GuardMesh';
			tk.MultiSkins[0]=Texture(DynamicLoadObject("ThTenth.Skins.TUT_GuardTex0", class'Texture'));
			tk.MultiSkins[1]=Texture(DynamicLoadObject("ThTenth.Skins.TUT_GuardTex1", class'Texture'));
			tk.MultiSkins[2]=Texture(DynamicLoadObject("ThTenth.Skins.TUT_GuardTex2", class'Texture'));
			tk.MultiSkins[3]=none;	
		}
	}

	return true;
}
//Thievery Tenth: End of Changes!!

DefaultProperties
{
}