//-----------------------------------------------------------
//
//-----------------------------------------------------------
class ThProPotionInvisibility expands ThPickupPotionInvisibility;

var ThieveryProPawn tprop;

state Activated  // Drink
{
Begin:
	tpp=ThieveryPPawn(Owner);
	tprop=ThieveryProPawn(Owner);

	if (tpp!=none) {

		if (tpp.PlayerReplicationInfo.Team!=0) {	// non-thieves can't use invis potions

			// guard
			GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
			StartLocation=Pawn(Owner).Location +FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z;

			if (Pawn(Owner).IsA('ThieveryPPawn')) {
				if (ThieveryPPawn(Owner).leancurve!=0) {
					StartLocation+=ThieveryPPawn(Owner).GetLeanoffset();
				}
			}
			// stop firing through walls
			if (Trace(HitLocation, HitNormal, StartLocation, Owner.Location, false)!=none) {
				StartLocation=HitLocation;
			}

			f=Spawn(class'ThObjectDontUseIPotion', Owner, '', StartLocation);

			if (f==none) {
				GotoState('');
			} else {
				tpp.ClientMessage("Blurgh! You throw away the awful tasting potion");
				f.SetPhysics(PHYS_Falling);
				f.Velocity=vector(Pawn(Owner).ViewRotation)*300;

				if (NumCopies>0)
				{
					NumCopies--;
				}
				else
				{
					Pawn(Owner).NextItem();
					if (Pawn(Owner).SelectedItem == Self) Pawn(Owner).SelectedItem=None;
					Pawn(Owner).DeleteInventory(Self);
					Destroy();
				}
				GoToState('');
			}

		} else {

            if (!class'ThieveryProModSettings'.default.bSilentInvisPotions)
    			PlayDrinkingSound();

			// give some invis
			tpp.bOnInvisibility=true;
			tpp.InvisibilityPotionDuration=Duration;
			tpp.ClientGiveInvisibility(Duration);
			tpp.VisCapacitor=tpp.LastBrightness;

			if (class'ThieveryProModSettings'.default.bPreventOverlappingPotionEffects)
   		    {
                tprop.ClearCatfall();
                tprop.ClearSpeed();
   		    }

			if (NumCopies>0)
			{
				NumCopies--;
			} else {
				Destroy();
			}
			GoToState('');
		}
	}

	tbb=TBaseBot(Owner);

	if (tbb!=none) {
		PlaySound (ActivateSound,,2.5);

		// give some speed
		tbb.giveInvisibility(Duration);

		if (NumCopies>0)
		{
			NumCopies--;
		} else {
			Destroy();
		}
		GoToState('');
	}
}

DefaultProperties
{

}