//-----------------------------------------------------------
// ThieveryProMod - ThProProjectileFlashbomb by Immortius
// Flashbomb with tweaked blinding behaviour
//-----------------------------------------------------------
class ThProProjectileFlashbomb expands ThProjectileFlashbomb;

function BlindPeople(vector v) {
	local Pawn p;

    for (p = Level.PawnList; p != none; p = p.nextPawn)
    {
        if (p.IsA('TBaseBot'))
        {
            BlindBot(TBaseBot(p), v);
        }
        else if (class'ThieveryProModSettings'.default.bUseNewFlashCalculation && p.IsA('ThieveryProPawn'))
        {
            BlindPlayerNew(ThieveryProPawn(p), v);
        }
        else if (p.IsA('ThieveryPPawn'))
        {
            BlindPlayerOld(ThieveryPPawn(p), v);
        }
    }
}

function BlindBot(TBaseBot b, vector v)
{
    local float dist;
	local vector PlayersHead;
    local float dotproduct;
    local actor Result;
    local vector hitloc, hitnorm;

    PlayersHead=b.location;
	PlayersHead.Z+=b.EyeHeight;
	dist=VSize(v-PlayersHead);

    if (dist < 700)
    {
	   Result=Trace(hitloc, hitnorm, PlayersHead,v, false);

	   dotproduct=Normal(v-PlayersHead) dot vector(b.Rotation);		// check nothing is blocking
	   if ((Result==none) || (Result==b))
       {
	       dist=(700-dist)/2.0;

	       if (dotproduct<-0.25) dist*=0.5;
		   else if (dotproduct<0.25) dist*=0.8;	// adjust if player is looking other way
		   dist/=15;
		   b.SetBlindness(dist);					// set their blindness
	    }
	}
}

function BlindPlayerNew(ThieveryProPawn p, vector v)
{
    local float dist, radius, strength;
	local vector PlayersHead;
    local float dotproduct;
    local actor Result;
    local vector hitloc, hitnorm;

    radius = class'ThieveryProModSettings'.default.FlashRadius;
    PlayersHead=p.location;
	PlayersHead.Z+=p.EyeHeight;
	dist=VSize(v-PlayersHead);

    if (dist < radius && P.Health > 0 && P.PlayerReplicationInfo.Team!=255)
    {
        Result=Trace(hitloc, hitnorm, PlayersHead,v, false);		// check nothing is blocking

	    if ((Result==none) || (Result==p))
        {
		    dotproduct=Normal(v-PlayersHead) dot vector(p.Rotation);

            strength = (radius) - (dist);

            if (dotproduct<-0.25) strength*=0.5;
		    else if (dotproduct<0.25) strength*=0.8;	// adjust if player is looking other way

            if (P.PlayerReplicationInfo.Team==0)
            {
			     if (!ThieveryGameReplicationInfo(Level.Game.GameReplicationInfo).bThiefMatch
			 		 || p==Owner) strength*=class'ThieveryProModSettings'.default.selfFlashModifier;	// half blindness for thieves
		    }
            else if (P.PlayerReplicationInfo.Team==0)
            {
			    strength*=0.75;
		    }
		    strength = FClamp(strength - 20, 0, radius) / (radius - 20);
		    strength = 1 - (1 - strength) * (1 - strength);
			p.setClientBlindness(class'ThieveryProModSettings'.default.maxFlashTime * 40 * strength);				// set their blindness
    		p.VisCapacitor=1.0;			// make visible briefly
	    }
	}
}

function BlindPlayerOld(ThieveryPPawn p, vector v)
{
    local float dist;
	local vector PlayersHead;
    local float dotproduct;
    local actor Result;
    local vector hitloc, hitnorm;

    PlayersHead=p.location;
	PlayersHead.Z+=p.EyeHeight;
	dist=VSize(v-PlayersHead);
	if (dist < 700)
	{
        Result=Trace(hitloc, hitnorm, PlayersHead,v, false);		// check nothing is blocking

	    if ((Result==none) || (Result==p))
        {
		    dotproduct=Normal(v-PlayersHead) dot vector(p.Rotation);

            dist=(700-dist)/2.0;

            if (dotproduct<-0.25) dist*=0.5;
		    else if (dotproduct<0.25) dist*=0.8;	// adjust if player is looking other way

            if (P.PlayerReplicationInfo.Team==0)
            {
			 if (!ThieveryGameReplicationInfo(Level.Game.GameReplicationInfo).bThiefMatch
			 			|| p==Owner) dist*=0.5;	// half blindness for thieves
		    }
            else if (P.PlayerReplicationInfo.Team==0)
            {
			    dist*=0.75;
		    }
		    if (P.Health > 0 && P.PlayerReplicationInfo.Team!=255)
            {
		    	p.setClientBlindness(dist);				// set their blindness
		    }
	        p.VisCapacitor=1.0;			// make visible briefly
	    }
	}
}

DefaultProperties
{

}