// ============================================================
// Sound ideas:
// - Doors make lock pick sound or opens/closes it
// - Hitting guards shake them and make BJ sound
// - Hitting ground makes a decoy image (also walking noises?)
// - Hitting a wall makes a landing sound beneath it
// - Illusion of supply chest breaking
// - Hitting a whistler sets it off
// - Hitting crack cloud makes a coughing sound
// - Hitting a mine makes an explosion sound
// - Hitting a caltrop makes a caltrop pain sound.
// - Hitting watcher - triggers watcher

// - Hitting water - triggers splashing sound
// ============================================================

class ThProProjectileNoiseArrow expands ThieveryProjectileArrows;

var Sound surfaceSound;

simulated function PostBeginPlay()
{
    local Hud hud;
    super.PostBeginPlay();
    if (Level.NetMode != NM_DedicatedServer)
    {
         foreach AllActors(class'HUD', hud)
         {
            break;
         }
         if (hud != none && hud.PlayerOwner != none && hud.PlayerOwner.PlayerReplicationInfo.Team == 0)
         {
            DrawType = DT_Mesh;
            mesh = LodMesh'ThieveryMod.ThProjectileFootstepArrow';
         }
         else
         {
            DrawType = DT_None;
         }
    }
}

simulated singular function Touch(Actor Other)
{
    local actor HitActor;
	local vector HitLocation, HitNormal, TestLocation;

	if ( Other.IsA('BlockAll') )
	{
		HitWall( Normal(Location - Other.Location), Other);
		return;
	}
	if ( Other.bProjTarget || (Other.bBlockActors && Other.bBlockPlayers) )
	{
		//get exact hitlocation
	 	HitActor = Trace(HitLocation, HitNormal, Location, OldLocation, true);
		if (HitActor == Other)
		{
			if ( Other.bIsPawn
				&& !Pawn(Other).AdjustHitLocation(HitLocation, Velocity) )
					return;
			ProcessTouch(Other, HitLocation);
		}
		else
			ProcessTouch(Other, Other.Location + Other.CollisionRadius * Normal(Location - Other.Location));
	}
	else
    {
        SoftTouch(other);
    }
}

event ZoneChange( ZoneInfo NewZone ) {
	super.ZoneChange(NewZone);
	if (Role == ROLE_Authority && !hasLanded)
	{
	   if (NewZone.bWaterZone) {
	   	   PlaySound(NewZone.EntrySound, SLOT_Misc, 2 * FClamp(0.000025 * class'ThieveryPPawn'.default.mass * (300 - 0.5 * -350), 1.0, 4.0 ));
           MakeNoise(1.0);
           HasLanded = true;
           AmbientSound=none;
           Destroy();
	   }
	}
}

simulated function SoftTouch(Actor other)
{
    if (Role == ROLE_Authority)
    {
        if (!hasLanded)
        {
            if (ThGreenSmokeCloud(other) != none)
            {
                CrackRuse(ThGreenSmokeCloud(other));
            }
            else if (ThObjectMine(other) != none)
            {
                MineRuse(ThObjectMine(other));
            }
            else if (ThObjectCaltrop(other) != none)
            {
                CaltropRuse(ThObjectCaltrop(other));
            }
            else
            {
                return;
            }
            HasLanded = true;
            AmbientSound=none;
            Destroy();

        }
    }
}

simulated function ProcessTouch( Actor Other, Vector HitLocation ) {
    local vector hitloc, hitnorm;

    if (Role == ROLE_Authority)
    {
        if (other == instigator)
            return;
        if (!hasLanded)
        {
            if (ThDoor(Other) != none)
            {
                DoorRuse(ThDoor(Other));
            }
            else if (ThObjectWhistler(Other) != none)
            {
                WhistlerRuse(ThObjectWhistler(Other));
            }
            else if (ThieveryPPawn(Other) != none)
            {
                BJRuse(ThieveryPPawn(Other));
            }
            else if (TMachine(Other) != none)
            {
                MachineRuse(TMachine(Other));
            }
            else if (TBot(Other) != none)
            {
                BJBotRuse(TBot(Other));
            }
            else if (ThObjectSupplyChest(Other) != none)
            {
                SupplyChestRuse(ThObjectSupplyChest(Other));
            }
            else
            {
                Trace(hitloc, hitnorm, location + Velocity * 10, location, true);
                HitWall(hitnorm, other);
            }
        }
        HasLanded = true;
        AmbientSound=none;
        Destroy();
    }
}

function MachineRuse(TMachine machine)
{
    local vector enemyLoc;
    local pawn p;
    if (machine.GetStateName() != 'Tracking' && machine.GetStateName() != 'TurnedOff')
    {
        enemyloc = location;
        enemyloc.X += (FRand()-0.5) * 64;
    	enemyloc.Y += (FRand()-0.5) * 64;
        p = spawn(class'ThSoundPawn',,,enemyloc);
        machine.SetEnemy(p);
        machine.SetAlertness(1.0f,true);
        machine.AquiredEnemy();
        p.Destroy();
    }
}

function CaltropRuse(ThObjectCaltrop caltrop)
{
    PlaySound(class'ThieveryPPawn'.default.HitSound1, SLOT_Pain,16,,,Frand()*0.15+0.9);
}

function MineRuse(ThObjectMine mine)
{
    spawn(class'ThSpriteBallExplosion',mine,,mine.location,mine.rotation);
}

function CrackRuse(ThGreenSmokeCloud crackCloud)
{
    crackCloud.PlayGassedSound(self);
}

function SupplyChestRuse(ThObjectSupplyChest Other)
{
    Other.PlaySound(sound'ThieveryData.BigWdMetal');

	// can only damage the chest if it is working
	if (other.bActivated) {
		spawn(class'UT_SpriteSmokePuff',,,other.Location);
		other.Frag(Class'ThWoodFragments',Velocity,1.0,12);
	}
}

function BJRuse(ThieveryPPawn pawn)
{
    if (pawn.PlayerReplicationInfo.Team == 255)
    {
        pawn.TakeDamage(1000, none, Vect(0,0,0), Vect(0,0,0), 'Crushed');
    }
    else if (pawn.PlayerReplicationInfo.Team != 0)
    {
        pawn.GiveKOEffect();
        pawn.PlaySound(sound'ThieveryData.BJBody1',SLOT_Misc);
    }
}

function BJBotRuse(TBot pawn)
{
    if (pawn.PlayerReplicationInfo.Team != 0)
    {
        pawn.RaiseAlertness(1.0, none);
        // if bot is not too busy
        if (pawn.Enemy == none || !pawn.TLineOfSightTo(pawn.Enemy))
        {
            pawn.InvestigateSpot = Location;
            pawn.InvestigateSpot.X += (FRand()-0.5) * 64;
			pawn.InvestigateSpot.Y += (FRand()-0.5) * 64;
			pawn.GotoState('Investigating', 'TookDamage');
        }
        pawn.PlaySound(sound'ThieveryData.BJBody1',SLOT_Misc);
    }
}

function WhistlerRuse(ThObjectWhistler whistler)
{
    local TBaseBot p;

    if (!whistler.bWhistling)
    {
        whistler.bWhistling=true;
    	whistler.SmokeGen=spawn(class'SmokeGenerator',whistler,'',whistler.Location+(vector(whistler.Rotation)*20)-vect(0,0,8));
		whistler.SmokeGen.BasePuffSize=0.5;
		whistler.SmokeGen.SizeVariance=0.5;
		whistler.SmokeGen.TotalNumPuffs=150;
		whistler.SmokeGen.SmokeDelay=0.05;
		whistler.SmokeGen.SetTimer(whistler.SmokeGen.SmokeDelay,true);
		whistler.PlaySound(sound(DynamicLoadObject("ThvryTrain.nWhistle6", class'Sound')), SLOT_None, 1.0);
		whistler.PlaySound(sound(DynamicLoadObject("ThvryTrain.nWhistle6", class'Sound')), SLOT_None, 1.0);
		whistler.PlaySound(sound(DynamicLoadObject("ThvryTrain.nWhistle6", class'Sound')), SLOT_None, 1.0);
		foreach AllActors(class'TBaseBot', p)
			p.TPreHearNoise(10.0, whistler);
		// lightup
		whistler.LightType = LT_Steady;
		whistler.LightBrightness = 192;
		whistler.LightRadius = 8;
		whistler.LightSaturation = 110;
		whistler.LightHue = 90;
		whistler.AmbientGlow=128;
		whistler.SetTimer(3,false);
    }
}

function DoorRuse(ThDoor door)
{
    if (door.bOpening)
    {
        door.DoClose();
    }
    else if (!door.bLocked)
    {
        door.DoOpen();
    }
    else if (door.bPickable)
    {
        PlaySound(door.LockpickNoises[1],SLOT_Interact,0.5,,class'ThieveryProModSettings'.default.lockpickSoundRadius);
		PlaySound(door.LockpickNoises[1],SLOT_None,0.5,,class'ThieveryProModSettings'.default.lockpickSoundRadius);
    }
    else
    {
        LandedRuse();
    }
}

simulated function Landed ( vector HitNormal ) {
	HitWall(HitNormal, none);
}

simulated function HitWall( vector HitNormal, actor Wall ) {
	if (Role == ROLE_Authority)
    {
	   if (!HasLanded) {
	       if (ThDoor(Wall) != none)
           {
                DoorRuse(ThDoor(Wall));
           }
           else
           {
              if (HitNormal.Z < 0.7)
              {
                  LandedRuse();
              }
              else
              {
                  DecoyRuse();
              }
           }
	   }
    }
    AmbientSound=none;
	hasLanded=true;
	Destroy();
}

function bool DecoyRuse()
{
	local ThieveryFakeThief fake;
	local vector v, HitLocation, Hitnormal;
	Trace(HitLocation, HitNormal, Location-vect(0,0,3000), Location);
	fake=spawn(class'ThProFakeThief',Owner,,HitLocation+vect(0,0,1)*46);
	fake.Instigator=Pawn(Owner);
	if (fake == none)
	{
	   log("Failed to spawn fake");
	}
}

function LandedRuse()
{
    local vector EndTrace;
	local texture tex;
	local rotator r;
	local TextureTracer Tracer;
	local Sound snd;
	local float noise;
	local vector hitLoc, hitNorm;

    Tracer=ThieveryDeathmatchPlus(Level.Game).GetTextureTracer();
	EndTrace=Location-Vect(0,0,1000);
	Trace(hitLoc, hitNorm,endtrace, location, true);
	SetLocation(hitLoc);
    tex=Tracer.TextureTrace(EndTrace,Location);
	snd=DetermineLandedSound(tex, noise);
	if (snd != none)
    {
        PlaySound(snd);;
        TMakeNoise(noise, string(snd));
    }
}

function Timer() {
	TMakeNoise(2.0,string(surfaceSound));
	PlaySound(surfaceSound);
}

function AddArrowToInventory(PlayerPawn Other) {
	ThieveryDeathmatchPlus(Level.Game).AddAmmoToInventory(Other, "ThieveryMod.ThAmmoBroadheadArrows", 1);
	Other.ClientMessage("You got a broadhead arrow.");
}

simulated function Sound DetermineStepSound(Texture tex, out float TMakeNoiseValue)
{
    local float decision;
    local string stringstep, TextureSoundString;

    if (tex == none)
    {
        TextureSoundString="ThiefFootsteps.FT_Rock.THRockStep1";
    }
    else
    {
        if (tex.FootstepSound==none)
        {
         	tex.FootstepSound=sound(DynamicLoadObject("ThiefFootsteps.FT_Rock.THRockStep1", class'Sound'));
        }

        // grab all but the last digit of the sound
        TextureSoundString=string(tex.FootstepSound);
    }
    stringstep=Left(TextureSoundString, Len(TextureSoundString)-1);

    // adjust bot alertness level depending on texture
    TMakeNoiseValue*=class'ThieveryProPawn'.default.FootstepScale;
    if (stringstep~="ThiefFootsteps.FT_Metal.THMetalStep") TMakeNoiseValue*=class'ThieveryProPawn'.default.FootstepScaleMetal;
    if (stringstep~="ThiefFootsteps.FT_Tile.THTileStep") TMakeNoiseValue*=class'ThieveryProPawn'.default.FootstepScaleTile;
    if (stringstep~="ThiefFootsteps.FT_Rock.THRockStep") TMakeNoiseValue*=class'ThieveryProPawn'.default.FootstepScaleRock;
    if (stringstep~="ThiefFootsteps.FT_Wood.THWoodStep") TMakeNoiseValue*=class'ThieveryProPawn'.default.FootstepScaleWood;
    if (stringstep~="ThiefFootsteps.FT_Dirt.THDirtStep") TMakeNoiseValue*=class'ThieveryProPawn'.default.FootstepScaleDirt;
    if (stringstep~="ThiefFootsteps.FT_Carpet.THCarpetStep") TMakeNoiseValue*=class'ThieveryProPawn'.default.FootStepScaleCarpet;
    if (stringstep~="ThiefFootsteps.FT_Gravel.THGravelStep") TMakeNoiseValue*=class'ThieveryProPawn'.default.FootstepScaleGravel;
    if (stringstep~="ThiefFootsteps.FT_Snow.THftsnow") TMakeNoiseValue*=class'ThieveryProPawn'.default.FootStepScaleSnow;

    //if (stringstep~="ThEdsTex.Deco.brick_wall_puddle") wetPrints=3+Rand(3);
    // add on a digit 1-4 based on the random number to make random footstep noises
    decision=FRand();
    if (decision<0.25)
        stringstep=stringstep$"1";
    else if (decision<0.5)
        stringstep=stringstep$"2";
    else if (decision<0.75)
        stringstep=stringstep$"3";
    else
        stringstep=stringstep$"4";
    return sound(DynamicLoadObject(stringstep, class'Sound'));
}

simulated function Sound DetermineLandedSound(Texture tex, out float TMakeNoiseValue)
{
    local Sound TextureJumpSound;
    local string TextureSoundString, stringjump;

    TMakeNoiseValue = 1.0;
    TextureJumpSound=sound(DynamicLoadObject("ThiefFootsteps.FT_Rock.THRockJump", class'Sound'));
    if (tex != none)
    {
        if (tex.FootstepSound!=none)
        {
          	TextureSoundString=string(tex.FootstepSound);               // grab the footstep sound
          	stringjump=Left(TextureSoundString, Len(TextureSoundString)-5);      // chop the end off

            if (stringjump~="ThiefFootsteps.FT_Metal.THMetalStep") TMakeNoiseValue*=class'ThieveryProPawn'.default.FootstepScaleMetal;
            if (stringjump~="ThiefFootsteps.FT_Tile.THTileStep") TMakeNoiseValue*=class'ThieveryProPawn'.default.FootstepScaleTile;
            if (stringjump~="ThiefFootsteps.FT_Rock.THRockStep") TMakeNoiseValue*=class'ThieveryProPawn'.default.FootstepScaleRock;
            if (stringjump~="ThiefFootsteps.FT_Wood.THWoodStep") TMakeNoiseValue*=class'ThieveryProPawn'.default.FootstepScaleWood;
            if (stringjump~="ThiefFootsteps.FT_Dirt.THDirtStep") TMakeNoiseValue*=class'ThieveryProPawn'.default.FootstepScaleDirt;
            if (stringjump~="ThiefFootsteps.FT_Carpet.THCarpetStep") TMakeNoiseValue*=class'ThieveryProPawn'.default.FootStepScaleCarpet;
            if (stringjump~="ThiefFootsteps.FT_Gravel.THGravelStep") TMakeNoiseValue*=class'ThieveryProPawn'.default.FootstepScaleGravel;
            if (stringjump~="ThiefFootsteps.FT_Snow.THft")
            {
               	TMakeNoiseValue*=class'ThieveryProPawn'.default.FootStepScaleSnow;
               	stringjump=stringjump$"snow";
            }

            stringjump=stringjump$"Jump"; // add the word "jump" to end
            TextureJumpSound=sound(DynamicLoadObject(stringjump, class'Sound'));     // load the sound
        }
    }
    return textureJumpSound;
}

defaultproperties
{
     ItemName="Ruse Arrow"
     bCountsTowardsRangedStats=False
     Damage=5.000000
     Style=STY_Translucent
     AmbientSound=none
     DrawType=DT_None
     ScaleGlow=0.500000
     bUnlit=True
     bBounce=True
}
