//-----------------------------------------------------------
//
//-----------------------------------------------------------
class ThProScoreBoard expands ThieveryScoreBoard;

// for the main game
simulated function MainGameShowScores( canvas Canvas )
{
	local PlayerReplicationInfo PRI;
	local int PlayerCount, i, j, MaxPlayersOnATeam;
	local float LoopCountTeam[4];
	local float XL, YL, XOffset, YOffset, XStart;
	local int PlayerCounts[4];
	local int LongLists[4];
	local int BottomSlot[4];
	local font CanvasFont;
	local bool bCompressed;
	local float r;
	local ThieveryGameReplicationInfo GRI;

	OwnerInfo = Pawn(Owner).PlayerReplicationInfo;
	OwnerGame = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	Canvas.Style = ERenderStyle.STY_Normal;
	CanvasFont = Canvas.Font;

	ThievesLootTotal=0;	LootY=0;

	// Header
	DrawShortHeader(Canvas);
	//Canvas.CurY=128;


	// order and sort players
	for ( i=0; i<32; i++ )
		Ordered[i] = None;

	for ( i=0; i<32; i++ )
	{
		if (PlayerPawn(Owner).GameReplicationInfo.PRIArray[i] != None)
		{
			PRI = PlayerPawn(Owner).GameReplicationInfo.PRIArray[i];
			if ( !PRI.bIsSpectator && (PRI.Team!=255) && (PRI.Team<4) && !PRI.bIsABot)
			{
				Ordered[PlayerCount] = PRI;
				PlayerCount++;
				PlayerCounts[PRI.Team]++;
			}
		}
	}
	SortScores(PlayerCount);
	MaxPlayersOnATeam=Max(PlayerCounts[0], PlayerCounts[1]);

	if (ThieveryPPawn(Owner).bDumpScoreboardInfo) {
		ThieveryPPawn(Owner).bDumpScoreboardInfo=false;
		for ( i=0; i<32; i++ )
		{
			log("Ordered["$i$"]="$Ordered[i]$" name="$Ordered[i].PlayerName);
			ThieveryPPawn(Owner).ClientMessage("Ordered["$i$"]="$Ordered[i]$" name="$Ordered[i].PlayerName);
		}

		for ( i=0; i<32; i++ )
		{
			PRI = PlayerPawn(Owner).GameReplicationInfo.PRIArray[i];
			log("PRIArray["$i$"]="$PRI$" name="$PRI.PlayerName);
			ThieveryPPawn(Owner).ClientMessage("PRIArray["$i$"]="$PRI$" name="$PRI.PlayerName);
		}
		log("Playercount="$PlayerCount);
		log("PlayerCounts[0]="$PlayerCounts[0]);
		log("PlayerCounts[1]="$PlayerCounts[1]);
		ThieveryPPawn(Owner).ClientMessage("Playercount="$PlayerCount);
		ThieveryPPawn(Owner).ClientMessage("PlayerCounts[0]="$PlayerCounts[0]);
		ThieveryPPawn(Owner).ClientMessage("PlayerCounts[1]="$PlayerCounts[1]);
	}

	// decide on big or small font, depending on number of players on the largest team
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
	Canvas.StrLen("TEXT", XL, YL);
	ScoreStart = Canvas.CurY + YL;
	if ( ScoreStart + MaxPlayersOnATeam * YL * 2 > Canvas.ClipY-32 ) {
		//Canvas.Font = font'SmallFont';
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		r = YL;
		Canvas.StrLen("TEXT", XL, YL);
	}
	Canvas.DrawColor = AltTeamColor[0];
	DrawTitles(Canvas, ScoreStart-YL);

	// draw thieves
	bCompressed=(OwnerInfo.Team!=0);
	for ( I=0; I<PlayerCount; I++ ) {
		if ( Ordered[I].Team ==0 ) {
			//XOffset = (Canvas.ClipX / 4) - (Canvas.ClipX / 8);
			XOffset = ThiefTeamOffset(Canvas);
			Canvas.StrLen("TEXT", XL, YL);
			Canvas.DrawColor = AltTeamColor[Ordered[I].Team];
			YOffset = ScoreStart + (LoopCountTeam[Ordered[I].Team] * YL) + 2;
			// Draw Name and Ping
			if ( (BottomSlot[Ordered[I].Team] == 0))
			{
				LongLists[Ordered[I].Team] = 1;
				DrawNameAndPing( Canvas, Ordered[I], XOffset, YOffset, bCompressed);
			}
			else if (LoopCountTeam[Ordered[I].Team] < 2)
				DrawNameAndPing( Canvas, Ordered[I], XOffset, YOffset, bCompressed);
			if ( bCompressed )
				LoopCountTeam[Ordered[I].Team] += 1;
			else
				LoopCountTeam[Ordered[I].Team] += 2;
		}
	}
	// draw guards
	bCompressed=(OwnerInfo.Team!=1);
	for ( I=0; I<PlayerCount; I++ ) {
		if ( Ordered[I].Team == 1 ) {
			//XOffset = ((Canvas.ClipX / 4) * 3) - (Canvas.ClipX / 8);
			XOffset=GuardTeamOffset(Canvas);
			Canvas.StrLen("TEXT", XL, YL);
			Canvas.DrawColor = AltTeamColor[Ordered[I].Team];
			YOffset = ScoreStart + (LoopCountTeam[Ordered[I].Team] * YL) + 2;
			// Draw Name and Ping
			if ( (BottomSlot[Ordered[I].Team] == 0))
			{
				LongLists[Ordered[I].Team] = 1;
				DrawNameAndPing( Canvas, Ordered[I], XOffset, YOffset, bCompressed);
			}
			else if (LoopCountTeam[Ordered[I].Team] < 2)
				DrawNameAndPing( Canvas, Ordered[I], XOffset, YOffset, bCompressed);
			if ( bCompressed )
				LoopCountTeam[Ordered[I].Team] += 1;
			else
				LoopCountTeam[Ordered[I].Team] += 2;
		}
	}

	for ( i=0; i<4; i++ )
	{
		Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
		if ( PlayerCounts[i] > 0 )
		{
			if ( i % 2 == 0 )
				XOffset = ThiefTeamOffset(Canvas);
			else
				XOffset = GuardTeamOffset(Canvas);
			YOffset = ScoreStart - YL + 2;

			if ( i > 1 )
				if (PlayerCounts[i-2] > 0)
					YOffset = ScoreStart + YL*10;

			// team name shown as graphic, no score yet

			//Canvas.SetPos(XOffset, YOffset);
			//Canvas.StrLen(TeamName[i], XL, YL);
			//Canvas.DrawText(TeamName[i], false);

			GRI=ThieveryGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
			if ((PlayerPawn(Owner).PlayerReplicationInfo.Team==0) && (i==0) && (ThievesLootTotal>0) && !GRI.bThiefmatch) {
				Canvas.DrawColor = TeamColor[i];
				Canvas.StrLen("Total loot: "$ThievesLootTotal, XL, YL);
				Canvas.SetPos(XOffset + (Canvas.ClipX/4) - XL, LootY);
				Canvas.DrawText("Total loot: "$ThievesLootTotal, false);
			}

			if ( PlayerCounts[i] > 4 )
			{
				if ( i < 2 )
					YOffset = ScoreStart + YL*8;
				else
					YOffset = ScoreStart + YL*19;
				Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
				Canvas.SetPos(XOffset, YOffset);
				if (LongLists[i] == 0)
					Canvas.DrawText(PlayerCounts[i] - 4 @ PlayersNotShown, false);
			}
		}
	}

	// Trailer
	if ( !Level.bLowRes )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		DrawTrailer(Canvas);

	}
	DrawSpectators(Canvas);
	Canvas.Font = CanvasFont;
	Canvas.DrawColor = WhiteColor;
}

// draws the column titles for the scoreboard
simulated function DrawTitles(Canvas Canvas, float YPosition) {
    local ThProGRI proGRI;
	local float cx, cy;

	proGRI = ThProGRI(PlayerPawn(Owner).GameReplicationInfo);

	if (ThieveryGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo).bThiefMatch)
    {
		Canvas.TextSize("Lives", cx, cy);
		Canvas.SetPos(ThiefTeamOffset(Canvas)+GetCScoreOffset(Canvas)-cx, YPosition);
		Canvas.DrawText("Lives");

		Canvas.TextSize("Lives", cx, cy);
		Canvas.SetPos(ThiefTeamOffset(Canvas)+GetScoreOffset(Canvas)-cx, YPosition);
		Canvas.DrawText("Kills");

		Canvas.SetPos(GuardTeamOffset(Canvas)+GetScoreOffset(Canvas)-cx, YPosition);
		Canvas.DrawText("Kills");
	} else {
		if (proGRI != none && proGRI.usingWaves)
		{
		    Canvas.TextSize("Lives", cx, cy);
		    Canvas.SetPos(ThiefTeamOffset(Canvas)+GetCScoreOffset(Canvas)-cx, YPosition);
		    Canvas.DrawText("Lives");
		}
		else if (PlayerPawn(Owner).PlayerReplicationInfo.Team==0)
	    {
		    Canvas.TextSize("Score", cx, cy);
		    Canvas.SetPos(ThiefTeamOffset(Canvas)+GetCScoreOffset(Canvas)-cx, YPosition);
		    Canvas.DrawText("Score");
		}

        if (PlayerPawn(Owner).PlayerReplicationInfo.Team==0)
        {
			Canvas.TextSize("Loot", cx, cy);
			Canvas.SetPos(ThiefTeamOffset(Canvas)+GetScoreOffset(Canvas)-cx, YPosition);
			Canvas.DrawText("Loot");
		}

		if (PlayerPawn(Owner).PlayerReplicationInfo.Team==1)
        {
			Canvas.TextSize("Score", cx, cy);
			Canvas.SetPos(GuardTeamOffset(Canvas)+GetCScoreOffset(Canvas)-cx, YPosition);
			Canvas.DrawText("Score");
		}

		Canvas.TextSize("Kills", cx, cy);
		Canvas.SetPos(GuardTeamOffset(Canvas)+GetScoreOffset(Canvas)-cx, YPosition);
		Canvas.DrawText("Kills");
	}
}

function DrawNameAndPing(Canvas Canvas, PlayerReplicationInfo PRI, float XOffset, float YOffset, bool bCompressed)
{
	local float XL, YL, XL2, YL2, YB, charwidth, tx,ty;
	local BotReplicationInfo BRI;
	local String S, O, L, namestring;
	local Font CanvasFont;
	local bool bAdminPlayer;
	local PlayerPawn PlayerOwner;
	local int Time, numchars;
	local ThieveryGameReplicationInfo GRI;
	local ThProGRI proGRI;
	local int waveLives;

	if (YOffset>Canvas.ClipY-64)
		return;

	PlayerOwner = PlayerPawn(Owner);

	GRI=ThieveryGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	proGRI = ThProGRI(gri);

	bAdminPlayer = PRI.bAdmin;

	Canvas.DrawColor = WhiteColor;

	if ((PRI.bWaitingPlayer) || ((PRI.Deaths>0) && (PRI.bIsABot)))
		Canvas.DrawColor=GrayColor;

	// Draw Name
	if (PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName)
		Canvas.DrawColor = GoldColor;

	if ( bAdminPlayer )
		Canvas.DrawColor = RedColor;

	Canvas.SetPos(XOffset, YOffset);

	namestring=PRI.PlayerName;
	if ((PRI.bIsABot) || (PRI.IsA('BotReplicationInfo'))) {
		namestring="(AI) "$PRI.PlayerName;
	} else {
		if (PRI.IsA('ThieveryPlayerReplicationInfo')) {
			if (ThieveryPlayerReplicationInfo(PRI).bHasSupplyChest) {
				if (PRI.Team==PlayerOwner.PlayerReplicationInfo.Team)
					namestring=namestring$" (chest)";
			}
		}
	}
	// if text goes over the right hand side, chop some letters off
	Canvas.TextSize(namestring, XL, YB);
	if (Canvas.CurX<Canvas.ClipX/2) {
		if (Canvas.CurX+XL>=XOffset+Canvas.ClipX*0.3) {
			Canvas.TextSize("l",charwidth, YB);

			numchars=((Canvas.CurX+XL-(XOffset+Canvas.ClipX*0.25))/charwidth)+2;
			namestring=Left(namestring, Len(namestring)-numchars);
		}
	} else {
		if (Canvas.CurX+XL>=XOffset+Canvas.ClipX*0.3) {

			Canvas.TextSize("l",charwidth, YB);
			numchars=((Canvas.CurX+XL-(XOffset+Canvas.ClipX*0.25))/charwidth)+2;

			namestring=Left(namestring, Len(namestring)-numchars);
		}
	}
	Canvas.DrawText(namestring, false);
	Canvas.StrLen(namestring, XL, YB);

	if ( Canvas.ClipX > 512 )
	{
		CanvasFont = Canvas.Font;
		Canvas.Font = Font'SmallFont';
		Canvas.DrawColor = WhiteColor;

		if (Level.NetMode != NM_Standalone)
		{
			if ( !bCompressed || (Canvas.ClipX > 640) )
			{
				// Draw Time
				Time = Max(1, (Level.TimeSeconds + PlayerOwner.PlayerReplicationInfo.StartTime - PRI.StartTime)/60);
				Canvas.StrLen(TimeString$":     ", XL, YL);
				Canvas.SetPos(XOffset - XL - 6, YOffset);
				Canvas.DrawText(TimeString$":"@Time, false);
			}

			// Draw Ping
			Canvas.StrLen(PingString$":     ", XL2, YL2);
			Canvas.SetPos(XOffset - XL2 - 6, YOffset + (YL+1));
			Canvas.DrawText(PingString$":"@PRI.Ping, false);
		}
		Canvas.Font = CanvasFont;
	}

	// Draw Score
	if (PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName)
		Canvas.DrawColor = GoldColor;
	else
		Canvas.DrawColor = TeamColor[PRI.Team];

	if ((PRI.Team==0) && ((PlayerOwner.PlayerReplicationInfo.Team==0 || PlayerOwner.PlayerReplicationInfo.Team==255) || (PlayerOwner.GetStateName()=='GameEnded'))) {
		if (GRI.bThiefMatch)
			DrawScore(Canvas, ThieveryPlayerReplicationInfo(PRI).ThiefKills, XOffset, YOffset);
		else
			DrawScore(Canvas, ThieveryPlayerReplicationInfo(PRI).Loot, XOffset, YOffset);
		ThievesLootTotal+=ThieveryPlayerReplicationInfo(PRI).Loot;
	} else if (PRI.Team==1 || PlayerOwner.PlayerReplicationInfo.Team==255) {
		DrawScoreGuards(Canvas, ThieveryPlayerReplicationInfo(PRI).ThiefKills, XOffset, YOffset);
	}


    if (proGRI != none && proGRI.usingWaves && PRI.Team == 0)
    {
         waveLives = (proGRI.totalWaves - proGRI.wave) * proGRI.livesPerWave;
         // Draw player lives
         DrawLives(Canvas, (ThieveryPlayerReplicationInfo(PRI).PlayerLives), waveLives, XOffset, YOffset);
    }
	else if (PlayerOwner.PlayerReplicationInfo.Team==PRI.Team || PlayerOwner.PlayerReplicationInfo.Team==255) {
		if (GRI.bThiefMatch)
			DrawCScore(Canvas, ThieveryPlayerReplicationInfo(PRI).PlayerLives, XOffset, YOffset);
		else
			DrawCScore(Canvas, PRI.Score, XOffset, YOffset);
	}

	if (Canvas.ClipX < 512)
		return;

	// Draw location, Order

	if ( !bCompressed && (PRI.Team == OwnerInfo.Team) && !GRI.bThiefMatch )
	{
		CanvasFont = Canvas.Font;
		Canvas.Font = Font'SmallFont';
		Canvas.DrawColor=GrayColor;

		if ( PRI.PlayerLocation != None )
			L = PRI.PlayerLocation.LocationName;
		else if ( PRI.PlayerZone != None )
			L = PRI.PlayerZone.ZoneName;
		else
			L = "";
		if ( L != "" )
		{
			L = InString@L$"  ";
			Canvas.SetPos(XOffset, YOffset + YB);
			Canvas.StrLen(L, XL2, YL2);
			Canvas.DrawText(L, False);
		}

		Canvas.Font = CanvasFont;
	}
}

simulated function DrawLives(Canvas Canvas, int lives, int waveLives, float XOffset, float YOffset)
{
	local float XL, YL;
	local string livesString;

	livesString = string(lives);
	if (waveLives > 0)
	{
	   livesString = livesString$"("$waveLives$")";
	}

	Canvas.StrLen(livesString, XL, YL);
	Canvas.SetPos(XOffset + GetCScoreOffset(Canvas) - XL, YOffset);
	Canvas.DrawText(livesString, False);
}

function DrawTrailer( canvas Canvas )
{
	local int Hours, Minutes, Seconds;
	local float XL, YL;
	local PlayerPawn PlayerOwner;
	local ThProGRI proGRI;

	proGRI = ThProGRI(PlayerPawn(Owner).GameReplicationInfo);

    if (proGRI == none || !proGRI.usingWaves)
    {
        super.DrawTrailer(Canvas);
        return;
    }

	Canvas.bCenter = true;
	Canvas.StrLen("Test", XL, YL);
	Canvas.DrawColor = WhiteColor;
	PlayerOwner = PlayerPawn(Owner);
	Canvas.SetPos(0, Canvas.ClipY - 2 * YL);

	Canvas.DrawText(Level.Title, true);

	Canvas.SetPos(0, Canvas.ClipY - YL);
	if ( bTimeDown || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) )
	{
		bTimeDown = true;
		if (proGRI.wave < proGRI.totalWaves && proGRI.nextWaveTime > 0)
		{
		    Minutes = (proGRI.RemainingTime - proGRI.nextWaveTime)/60;
			Seconds = (proGRI.RemainingTime - proGRI.nextWaveTime) % 60;
			Canvas.DrawText("Next Wave:"@TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
		}
        else if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 0 )
			Canvas.DrawText(RemainingTime@"00:00", true);
		else
		{
			Minutes = PlayerOwner.GameReplicationInfo.RemainingTime/60;
			Seconds = PlayerOwner.GameReplicationInfo.RemainingTime % 60;
			Canvas.DrawText(RemainingTime@TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
		}
	}
	else
	{
		Seconds = PlayerOwner.GameReplicationInfo.ElapsedTime;
		Minutes = Seconds / 60;
		Hours   = Minutes / 60;
		Seconds = Seconds - (Minutes * 60);
		Minutes = Minutes - (Hours * 60);
		Canvas.DrawText(ElapsedTime@TwoDigitString(Hours)$":"$TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
	}

	if ( PlayerOwner.GameReplicationInfo.GameEndedComments != "" )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		if ( Level.NetMode == NM_Standalone )
			Canvas.DrawText(Ended@Continue, true);
		else
			Canvas.DrawText(Ended, true);
	}
	else if ( (PlayerOwner != None) && (PlayerOwner.Health <= 0) )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		Canvas.DrawText(Restart, true);
	}
	Canvas.bCenter = false;
}

DefaultProperties
{

}