//-----------------------------------------------------------
// ThieveryProMod - ThProSoundPawn by Immortius
// Modified Sound system with sharper volume falloff and low
// volume filter
//-----------------------------------------------------------
class ThProSoundPawn expands ThSoundPawn;

simulated function float GetProNewVolume(vector soundSource, Actor Listener, float Volume, float radius, optional float HearingSkill) {
	local float distance;
	local PlayerPawn pp;
	local Actor ViewActor;
	local Vector cameraLoc;
	local Rotator cameraRot;
	local float innerRadius;

	innerRadius = 0.2 * radius;

	if (bVerbose) log("[ThSoundPawn] GetNewVolume(from:"$soundSource$",to:"$Listener$",vol:"$volume$")");
	if (!Listener.FastTrace(soundSource)) {	// world geometry between listener and sound source
		if (VSize(soundSource-Listener.Location)>150) {
			//SetLocation(Listener.Location);
			pp = PlayerPawn(Listener);
			// If is a PlayerPawn, and not looking through own eyes / at self
			if(pp!=None && pp.ViewTarget!=None && pp.ViewTarget!=pp) {
				pp.PlayerCalcView(ViewActor, cameraLoc, cameraRot);
				SetLocation(cameraLoc);
			} else {
				SetLocation(Listener.Location);
			}
			distance=GetDistanceTo(soundSource);
			if (distance==0) {	// no path could be found
				if (bVerbose) log("[ThSoundPawn]     No LOS or path, volume scaled by 0.1");
				Volume*=0.1;	// make sound really quiet
			} else {
				if (HearingSkill!=0) {
					distance=FMin(distance,HearingSkill);
					Volume*=1.0-(distance/HearingSkill);
					if (bVerbose) log("[ThSoundPawn]     No LOS. HearingSkill="$HearingSkill$" Path distance="$distance$" New volume:"$Volume);
				} else {
					if (distance>=innerRadius) {
						//distance=FMin(distance,4000);
						//Volume*=1.0-((distance-800)/3300);
						distance=FMin(distance,radius);
						Volume*=1.0-((distance-innerRadius)/(radius - innerRadius))*((distance-innerRadius)/(radius - innerRadius));
					}
					if (bVerbose) log("[ThSoundPawn]     No LOS. No HearingSkill. Path distance="$distance$" New volume:"$Volume);
				}
			}
		} else {
			if (bVerbose) log("[ThSoundPawn]     No LOS, but sound very close. No volume change.");
		}
	} else {
	    if (distance > innerRadius)
	    {
    	   distance=FMin(distance,radius);
		  Volume*=1.0-((distance-innerRadius)/(radius-innerRadius))*((distance-innerRadius)/(radius-innerRadius));
		}
		if (bVerbose) log("[ThSoundPawn]     Straight LOS, no volume change.");
	}
	if (Volume < 5) Volume = 0;
	return Volume;
}

DefaultProperties
{
}