//-----------------------------------------------------------
// ThieveryProMod - ThProSupplyChest by Keggie and Immortius
// Supply chest with variable resupply rate based on number of
// human guard players
//-----------------------------------------------------------
class ThProSupplyChest expands ThObjectSupplyChest;

var int timePerHumanGuard;
var int minResupplyTime;

function bool AllowedToResupply(Pawn Frobber)
{
    RecalculateResupplyTime();
    return super.AllowedToResupply(Frobber);
}

function bool ReallyForceThrow(float ThrowPower) {
    local ThieveryPPawn tpp;
    tpp=ThieveryPPawn(Owner);
    if (tpp != none)
    {
       ThieveryPlayerReplicationInfo(tpp.PlayerReplicationInfo).bHasSupplyChest=false;
    }
    super.ReallyForceThrow(throwPower);
}

function RecalculateResupplyTime()
{
    local int numHumanGuards;
    local Pawn pawn;
    local ThieveryPPawn thPawn;

    pawn = level.PawnList;
    while (pawn != none)
    {
        thPawn = ThieveryPPawn(pawn);
        if (thPawn != none && thPawn.PlayerReplicationInfo != none && thPawn.PlayerReplicationInfo.Team == 1)
        {
            numHumanGuards++;
        }
        pawn = pawn.nextPawn;
    }

    ResupplyTime = Max(minResupplyTime, numHumanGuards * timePerHumanGuard);
}

DefaultProperties
{
    minResupplyTime=120
    timePerHumanGuard=60
}