//=============================================================================
//	UWSpawnReplacer
//	Replaces the Thievery sword, mace and crossbow with UW equivalents.
//	By Mortal Monkey
//=============================================================================
class ThProTenCrossbowReplacer expands SpawnNotify;

// Replacements
var() config Class<ThieveryWeapon> CrossbowReplacement;
var() config Class<ThieveryWeapon> CrossbowReplacementOrig;

// Bolt meshes and textures
var(UWBolts) config LodMesh ParalyseBoltMesh;
var(UWBolts) config Texture ParalyseBoltTex;
var(UWBolts) config LodMesh TagBoltMesh;
var(UWBolts) config Texture TagBoltTex;
var(UWBolts) config LodMesh FireBoltMesh;
var(UWBolts) config Texture FireBoltTex;
var(UWBolts) config LodMesh BoltMesh;
var(UWBolts) config Texture BoltTex;

simulated event Actor SpawnNotification(Actor A)
{
	local Actor replacement;
	local class<ThieveryWeapon> new_weapon_class;
	local ThieveryProjectile new_projectile;
	local LodMesh bolt_mesh;
	local Texture bolt_tex;
	local ThieveryShop shop;

	if (A.isA('ThieveryWeapon'))
	{
		if (Role != ROLE_Authority)
			return A;
		
		// We only want to replace the standard Thievery issues
		switch (A.Class)
		{
			case Class'ThieveryMod.ThWeaponCrossbow':

		//Thievery Tenth: Replace crossbow with ten crossbow, except on old soldier maps.
		if (Level.Title == "Skeltston Head" || Level.Title == "Crows Nest" || Level.Title == "Souls Harbor")
		{
				new_weapon_class = CrossbowReplacementOrig;
		}
		else
		{

				new_weapon_class = CrossbowReplacement;
		}
				break;
			default:
				return A;
		}
		replacement = Spawn(new_weapon_class, A.Owner,, A.Location, A.Rotation);
		replacement.Instigator = A.Instigator;
		A.Destroy();
		return replacement;
	}
		
		// Since this is mostly a cosmetic mod, we'll want to change the
		// bolt models of potential subclasses (e.g. from other mutators) too
		if (A.isA('ThProjectileStandardBolt'))
		{
			bolt_mesh = BoltMesh;
			bolt_tex = BoltTex;
		}
		else if (A.isA('ThProjectileFireBolt'))
		{
			bolt_mesh = FireBoltMesh;
			bolt_tex = FireBoltTex;
		}
		else if (A.isA('ThProjectileParalyseBolt'))
		{
			bolt_mesh = ParalyseBoltMesh;
			bolt_tex = ParalyseBoltTex;
		}
		else if (A.isA('ThProjectileTagBolt'))
		{
			bolt_mesh = TagBoltMesh;
			bolt_tex = TagBoltTex;
		}
		else
			return A;
		
		A.Mesh = bolt_mesh;
		A.MultiSkins[0] = bolt_tex;
		A.MultiSkins[1] = bolt_tex;
		A.MultiSkins[2] = bolt_tex;
		A.MultiSkins[3] = bolt_tex;
		
		return A;
	}

defaultproperties
{
	// Replacements
	CrossbowReplacement=Class'ThProTenWeaponCrossbow'
	CrossbowReplacementOrig=Class'ThieveryMod.ThWeaponCrossbow'

	// Bolt meshes and textures
	ParalyseBoltMesh=lodmesh'UWParaBoltMesh'
	ParalyseBoltTex=texture'UwParaBoltTex0'
	TagBoltMesh=lodmesh'UWTagBoltMesh'
	TagBoltTex=texture'UwTagBoltTex0'
	FireBoltMesh=lodmesh'UWFireBoltMesh'
	FireBoltTex=texture'UwFireBoltTex0'
	BoltMesh=lodmesh'UWBoltMesh'
	BoltTex=texture'UwBoltTex0'
	
    ActorClass=Class'Engine.Actor'
}
