//-----------------------------------------------------------
// ThieveryProMod - ThProMaceReplacer by Immortius
// Replaces the ThWeaponMace with the ThProWeaponMace
//-----------------------------------------------------------
class ThProTenMaceReplacer expands SpawnNotify;

simulated event Actor SpawnNotification( Actor A )
{
    local ThProWeaponMace ma;

    if (Role < ROLE_Authority)
	   Return A;

    if (A.isA('ThWeaponMace'))
    {
		//Thievery Tenth: Replace pro mace with ten mace, except on old soldier maps.
		if (Level.Title == "Skeltston Head" || Level.Title == "Crows Nest" || Level.Title == "Souls Harbor")
		{
        ma = Spawn(class'ThProWeaponMace', A.Owner,, A.Location, A.Rotation);
		}
		else
		{
		ma = Spawn(class'ThProTenWeaponMace', A.Owner,, A.Location, A.Rotation);
        }
		
		if (ma != None)
        {
           ma.Instigator = A.Instigator;
           A.Destroy();
           return ma;
        }
    }
    return A;
}

DefaultProperties
{

}
