//-----------------------------------------------------------
// ThieveryProMod - ThieveryProPawn by Immortius
// Changes:
//   - Slight protection against changing mouse sensitivity
//     while paralysed.
//   - Prevent behind view while scouting orbing
//   - Optionally disable behind view entirely
//   - Alters the radius of lockpicking sounds
//-----------------------------------------------------------
class ThProTenPawn expands ThieveryProPawn;

//Thievery Tenth: Added audio import line.
#exec AUDIO IMPORT NAME="climb1F" FILE="Sounds\climb1F.wav"

//Thievery Tenth: Added in Underworld code for weapon changes.

// Snakes on a plane^Wcode!
// Let's do it here instead '
function bool ChangeWeaponAmmo(Weapon w, Class<Ammo> a)
{
	local ThProTenWeaponCrossbow crossbow;
	local Class<ThieveryAmmo> tha;

	if (!Super.ChangeWeaponAmmo(w, a))
		return false;

	crossbow = ThProTenWeaponCrossbow(w);
	tha = Class<ThieveryAmmo>(a);
	if (crossbow != None && tha != None)
		crossbow.SetModel(tha.default.ProjectileClass);

	return true;
}

// ***********************************
// *** PLAYERCLASS CHANGING STUFFS
// ***********************************
simulated function ThSetMesh() {
	local ThieveryPlayerReplicationInfo TPri;
	
	TPri=ThieveryPlayerReplicationInfo(PlayerReplicationInfo);
	
	
	if ( PlayerReplicationInfo.Team == 0 )
	{
		Super.ThSetMesh();

		DefaultSkinName="";
		DefaultPackage="ThTenth.";
		FaceSkin=1;
		TeamSkin1=2;
		TeamSkin2=3;
		SkelAnim=none;
		if ( TPri.ThMesh!=none )		// check the player's PRI for a special mesh
			Mesh=TPri.ThMesh;

		if (Level.Title == "Skeltston Head" || Level.Title == "Crows Nest")
		{
			Mesh=SkeletalMesh'ThTenth.ThCityThiefPirateMesh';
			MultiSkins[0]=Texture(DynamicLoadObject("ThTenth.Skins.ThPirateTex0", class'Texture'));
			MultiSkins[1]=none;
			MultiSkins[2]=none;
			MultiSkins[3]=none;
			bIsFemale=False;
		}
		else if (Level.Title == "Nostalgia")
		{	
			Mesh=SkeletalMesh'ThTenth.ThTafferGirlMesh';
			MultiSkins[0]=Texture(DynamicLoadObject("ThTenth.Skins.ThTafferGirlTex0", class'Texture'));
			MultiSkins[1]=none;
			MultiSkins[2]=none;
			MultiSkins[3]=none;	
			bIsFemale=True;
		}
		else if (Level.Title == "Residency")
		{	
			Mesh=SkeletalMesh'ThTenth.ThCityThiefFemaleNewMesh';
			MultiSkins[0]=Texture(DynamicLoadObject("ThTenth.Skins.ThCityThiefFemaleTex0", class'Texture'));
			MultiSkins[1]=none;
			MultiSkins[2]=none;
			MultiSkins[3]=none;	
			bIsFemale=True;
		}
		else
		{
			Mesh=SkeletalMesh'ThTenth.ThCityThiefNewMesh';	
			MultiSkins[0]=Texture(DynamicLoadObject("ThTenth.Skins.ThGillanTex0", class'Texture'));
			MultiSkins[1]=none;
			MultiSkins[2]=none;
			MultiSkins[3]=none;			
			bIsFemale=False;
		}
		ThCarcassType=Class'ThProCarcass';
	}
	// Start of guard code
	else if ( PlayerReplicationInfo.Team == 1 )
	{
	
		SkelAnim=none;
		FaceSkin=1;
		TeamSkin1=2;
		TeamSkin2=3;
		DefaultSkinName="ThieverySGirl.farm";
		DefaultPackage="ThTenth.";
		
			// Guard
		if (Level.Title == "Bourgeois" || Level.Title == "City Museum" || Level.Title == "Residency" || Level.Title == "Highway Inn" || Level.Title == "Nostalgia" || Level.Title == "The Theatre")
		{
			Mesh=SkeletalMesh'ThTenth.ThCityGuardNewMesh';
			MultiSkins[0]=Texture(DynamicLoadObject("ThTenth.Skins.ThCityGuardNewTex0", class'Texture'));
			MultiSkins[1]=Texture(DynamicLoadObject("ThTenth.Skins.ThCityGuardNewTex1", class'Texture'));
			MultiSkins[2]=none;
			MultiSkins[3]=none;
			bIsFemale=False;
		}
		else if (Level.Title == "Skeltston Head" || Level.Title == "Crows Nest")
		{
			Mesh=LodMesh'ThieveryMod.ThSoldierMesh';
			MultiSkins[0]=Texture(DynamicLoadObject("ThMuzGuard1.Skins.mtgrd1-1-1", class'Texture'));
			MultiSkins[1]=Texture(DynamicLoadObject("ThMuzGuard1.Skins.mtgrd1-0-2", class'Texture'));
			MultiSkins[2]=Texture(DynamicLoadObject("ThMuzGuard1.Skins.mtgrd1-0-3", class'Texture'));
			MultiSkins[3]=Texture(DynamicLoadObject("ThMuzGuard1.Skins.mtgrd1-1-4", class'Texture'));
			bIsFemale=False;
		}
		else if (Level.Title == "Souls Harbor")
		{
			Mesh=LodMesh'ThieveryMod.ThSoldierMesh';
			MultiSkins[0]=Texture(DynamicLoadObject("ThHauntSkins.Skins.hauntbody02", class'Texture'));
			MultiSkins[1]=Texture(DynamicLoadObject("ThHauntSkins.Skins.hauntleg02", class'Texture'));
			MultiSkins[2]=Texture(DynamicLoadObject("ThHauntSkins.Skins.hauntarm02", class'Texture'));
			MultiSkins[3]=Texture(DynamicLoadObject("ThHauntSkins.Skins.hauntdone06", class'Texture'));
			bIsFemale=False;
		}
		else
		{
			Mesh=SkeletalMesh'ThTenth.TUT_GuardMesh';
			MultiSkins[0]=Texture(DynamicLoadObject("ThTenth.Skins.TUT_GuardTex0", class'Texture'));
			MultiSkins[1]=Texture(DynamicLoadObject("ThTenth.Skins.TUT_GuardTex1", class'Texture'));
			MultiSkins[2]=Texture(DynamicLoadObject("ThTenth.Skins.TUT_GuardTex2", class'Texture'));
			MultiSkins[3]=none;	
			bIsFemale=False;
		}
		// !!! Folowing piece of code is OBSOLETE OBSOLETE !!!
		// For using new models, there should be aditional mesh unhelmeted to be dynamicaly switched 
		// when helmet is of or broken by blackjacking !!!
		if ( ThieveryPlayerReplicationInfo(PlayerReplicationInfo).bHelmet )
		{
			// switch to helmeted mesh and appropriate texture(s)
		}
		else
		{
			// switch to unhelmeted mesh and appropriate texture(s)
		}
		// !!! Also above mentioned should be rather piece of code of previously selected dynamical mesh...
		// The helmeted/unhelmeted mesh is dependant on the selected mesh !!!
		ThCarcassType=Class'ThProCarcass';
	}
	else if ( PlayerReplicationInfo.Team == 255 )
	{
		Super.ThSetMesh();
    }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//  Start of new make guard.
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////

function MakeGuard() 
{
	bBehindView=false;
	Super.MakeGuard();
	ThSetMesh();
	ThCarcassType=Class'ThProCarcass';
}


function MakeThief() {
    bBehindView=false;
    super.MakeThief();
	ThSetMesh();
	ThCarcassType=Class'ThProCarcass';
	
	if ( bIsFemale == true)
	{
	Deaths[0]=default.Deaths[0];
	Deaths[1]=default.Deaths[1];
	Deaths[2]=default.Deaths[2];
	Deaths[3]=default.Deaths[3];
	Deaths[4]=default.Deaths[4];
	Deaths[5]=default.Deaths[5];
	drown=Sound'UnrealShare.Female.mdrown2fem';
	breathagain=Sound'UnrealShare.Female.hgasp3fem';
	HitSound1=Sound'UnrealShare.Female.linjur1fem';
	HitSound2=Sound'UnrealShare.Female.linjur2fem';
	HitSound3=Sound'UnrealShare.Female.linjur3fem';
	HitSound4=Sound'UnrealShare.Female.linjur1fem';
	Die=Sound'UnrealShare.Female.death1dfem';
	Die2=Sound'UnrealShare.Female.death2afem';
	Die3=Sound'UnrealShare.Female.death3cfem';
	Die4=Sound'UnrealShare.Female.death4cfem';
	Deaths[0]=Sound'UnrealShare.Female.death1dfem';
	Deaths[1]=Sound'UnrealShare.Female.death2afem';
	Deaths[2]=Sound'UnrealShare.Female.death2afem';
	Deaths[3]=Sound'UnrealShare.Female.death3cfem';
	Deaths[4]=Sound'UnrealShare.Female.death1dfem';
	Deaths[5]=Sound'UnrealShare.Female.death3cfem';
	GaspSound=Sound'UnrealShare.Female.lgasp1fem';
	UWHit1=Sound'UnrealShare.Female.FUWHit1';
	UWHit2=Sound'UnrealShare.Female.FUWHit1';
	}
	else
	{
	Deaths[0]=default.Deaths[0];
	Deaths[1]=default.Deaths[1];
	Deaths[2]=default.Deaths[2];
	Deaths[3]=default.Deaths[3];
	Deaths[4]=default.Deaths[4];
	Deaths[5]=default.Deaths[5];
	drown=default.drown;
	breathagain=default.breathagain;
	HitSound1=default.HitSound1;
	HitSound2=default.HitSound2;
	HitSound3=default.HitSound3;
	HitSound4=default.HitSound4;
	Die=default.Die;
	Die2=default.Die2;
	Die3=default.Die3;
	Die4=default.Die4;
	Deaths[0]=default.Deaths[0];
	Deaths[1]=default.Deaths[1];
	Deaths[2]=default.Deaths[2];
	Deaths[3]=default.Deaths[3];
	Deaths[4]=default.Deaths[4];
	Deaths[5]=default.Deaths[5];
	GaspSound=default.GaspSound;
	UWHit1=default.UWHit1;
	UWHit2=default.UWHit2;
	}
}



//Thievery Tenth: All this just to allow female mantle sounds.
// *****************************
// *** STATE:PLAYERWALKING
// *****************************

// normal state the player is in during play

state PlayerWalking
{
ignores SeePlayer, HearNoise, Bump;

	// render the spectator HUD if you're a rat
	event PostRender( canvas Canvas ) {
		super.PostRender(Canvas);
	}

     exec function FeignDeath() {
     }

     function ServerFeignDeath() {
      super.ServerFeignDeath();
     }

     function ZoneChange( ZoneInfo NewZone ) {
     super.ZoneChange(NewZone);
     }

     function AnimEnd() {
	 super.AnimEnd();
     }

     function Landed(vector HitNormal) {
       super.Landed(HitNormal);
     }

        // using dodge to climb ladders
        function Dodge(eDodgeDir DodgeMove)
	{
		super.Dodge(DodgeMove);
	}

     function TProcessMove(float DeltaTime, vector NewAccel, eDodgeDir DodgeMove, rotator DeltaRot, byte VelCap) {
          super.TProcessMove(DeltaTime,NewAccel,DodgeMove,DeltaRot,VelCap);
     }
	 
     event PlayerTick( float DeltaTime ) {
     	local vector wx,wy,wz,Loc;

     	CheckWaterSound();

				if (InfraHandler==none)	InfraHandler=spawn(class'InfraController', self);
				InfraHandler.Update(deltatime, bUpdatePosition, true);
          // drip water
          if (wet>0) {
               if (wetDelay>0) {
                    wetDelay-=DeltaTime;
                    if (wetDelay<0) wetDelay=0;
               } else {
                    if (DeltaTime*FRand()<0.01) {
                         //log("wet-- in tick");
                         wet--;
                         DripWater();
                    }
               }
          }

          if (JumpRecover>0) {
          	JumpRecover=FMax(0,JumpRecover-deltatime);
          	if (Region.Zone.bWaterZone) JumpRecover=0;
          }

          // start mantling?
          if ((bJumping) && (bJumpKey>0) && (!bAlreadyMantled)) {
          		GetAxes(Rotation,wx,wy,wz); wx.Z=0;
							if( !FastTrace(Location+wx*MantleGapSize,Location)){ // wall in front of player
								Loc=Location;
								Loc.Z+=MaxMantleHeight-CollisionHeight;
								if (FastTrace(Loc+wx*MantleGapSize,Loc)) { // gap at head height
									bAlreadyMantled=true;
									StartMantleLocation=Location;
          				if (PlayerReplicationInfo.Team!=255) 
						{
							if ((bIsFemale))
							{
							PlaySound(sound'climb1f',SLOT_None,1.0);
							}
							else
							{
							PlaySound(sound'climb1',SLOT_None,1.0);
							}
						}
          				bMantling=true;
          			}
          		}
          	//}
          }

          // picking
	if ((DesiredSelectedItemOffsetX==-1000) && (DesiredSelectedItemOffsetY==-750)) { // at centre?
		//log("at centre");
		if ((DesiredSelectedItemOffsetX==SelectedItemOffsetX) && (DesiredSelectedItemOffsetY==SelectedItemOffsetY)) {
			//log(" lpick test selected item:"$SelectedItem$" FrobTarget:"$FrobTarget$" bFrob="$bFrob);
			if ((bFrob!=0) && (GetSelectedItem().isA('ThPickupLockpicks'))) {
				//log("trying to lockpick");
				if ((FrobTarget!=none) && ((FrobTarget.isA('ThObjectMine')) || (FrobTarget.isA('ThObjectFootlocker')) || (FrobTarget.isA('ThDoor')))) {
					pickTime+=deltatime;
					if (pickTime>1.0) {
						pickTime=0;
						ServerSinglePick(FrobTarget,deltatime);
					}
				}
			} else if (BFrob!=0 && GetSelectedItem().IsA('ThieveryPickup') && ThieveryPickup(GetSelectedItem()).bHoldToUseFrobItem) {
				if (FrobTarget!=none && ThieveryPickup(GetSelectedItem()).ValidHoldToUseTarget(FrobTarget)) {
					pickTime+=deltatime;
					if (pickTime>1.0) {
						pickTime=0;
						ServerHoldingToUse(ThieveryPickup(GetSelectedItem()), FrobTarget, deltatime);
					}
				}
			}
		}
	}
     }

     // check for a gap in front of you, and to the sides
     function bool GapInFront(vector Loc, vector wx) {
     	super.GapInFront(Loc,wx);
     }

     // There has to be a gap at foot level, and up to half your height, for this to return true
     function bool GapInFrontSingle(vector Loc, vector wx) {
     	super.GapInFrontSingle(Loc,wx);
     }

     function PlayerMove( float DeltaTime ) {
          super.PlayerMove(DeltaTime);
     }

     function BeginState() {
     	super.BeginState();
     }

     function EndState() {
     		super.EndState();
     }
	 
	 event HeadZoneChange(ZoneInfo newHeadZone)
     {
     	super.HeadZoneChange(newHeadZone);
     }
}
// *****************************(state:playerwalking)
//Thievery Tenth: End of Changes!!

DefaultProperties
{
}