//=============================================================================
// ThProjectileScoutingOrbSticky.
//=============================================================================
class ThProTenProjectileSpyOrb expands ThProjectileScoutingOrbD;

var Pawn AttachedTo;

replication {
	reliable if (Role == ROLE_Authority)
		AttachedTo;
}

simulated function ProcessTouch (Actor Other, vector HitLocation)
{
	if ( Other != instigator ) {
		if (Other.IsA('Pawn')) {
			AttachedTo = pawn(Other);
			if ( Role == ROLE_Authority && !bScouting) {
				StartScouting();
			}
			SetPhysics(PHYS_None);
			SetCollision(true,false,false);
			Velocity=vect(0,0,0);
			Acceleration=vect(0,0,0);
		}
		else
			HitWall(vect(0,0,0), none);
	}
}

simulated function tick(float deltatime) {
	if (Role==ROLE_Authority) {
		if (Physics==PHYS_None && !bScouting) {
			StartScouting();
		}
	}
	if (AttachedTo != None) {
		if(AttachedTo.health <= 0 || ThieveryPPawn(Instigator).ViewTarget != Self)
			Destroy();
		SetLocation(AttachedTo.location);
	}
	
}

function StartScouting() {
	Super.StartScouting();
	if(AttachedTo != None)
		ThieveryPPawn(Instigator).bBehindView = True;
}