//-----------------------------------------------------------
// ThieveryProMod - ThProSwordReplacer by Immortius
// Replaces the ThWeaponSword with the ThProWeaponSword
//-----------------------------------------------------------
class ThProTenSwordReplacer expands SpawnNotify;

simulated event Actor SpawnNotification( Actor A )
{
    local ThProWeaponSword ma;

    if (Role < ROLE_Authority)
	   Return A;

    if (A.isA('ThWeaponSword'))
    {
		//Thievery Tenth: Replace pro sword with ten sword, except on old soldier maps.
		if (Level.Title == "Skeltston Head" || Level.Title == "Crows Nest" || Level.Title == "Souls Harbor")
		{
        ma = Spawn(class'ThProWeaponSword', A.Owner,, A.Location, A.Rotation);
		}
		else
		{		
		ma = Spawn(class'ThProTenWeaponSword', A.Owner,, A.Location, A.Rotation);
        }
		
		if (ma != None)
        {
           ma.Instigator = A.Instigator;
           A.Destroy();
           return ma;
        }
    }
    return A;
}

DefaultProperties
{

}
