// ThTitan2.
//=============================================================================
class ThProTenTitan expands TGuard;

var() Float DurationSeconds; // How long the spell lasts. 0.0 is instantaneous. 
var() class CastingEffect; // The effect that is spawned when spell is cast. 
var() Sound CastingSound; // Sound that is played when cast. 
var Int DurationCounter;
var() byte SlapDamage,
	PunchDamage;
	
var bool bStomp;
var bool bLavaTitan;
var float realSpeed;
var() name StompEvent;
var(Sounds) sound StompSound;
var(Sounds) sound slap;
var(Sounds) sound swing;
var(Sounds) sound throw;
var(Sounds) sound chest;
var(Sounds) sound threaten;
var(Sounds) sound roam;
var(Sounds) sound Fear;
var(Sounds) sound aquire;
 

function Spawned() {
//if (CastingEffect != None) Spawn(CastingEffect, PlayerPawn(Owner),,PlayerPawn(Owner).Location, //PlayerPawn(Owner).Rotation); 
//if (CastingSound != None) PlaySound(CastingSound); 
//StartSpell(); 
SetTimer(15, True); // Well if the spell's duration is 0.0 or less, we'd better tell it // to bugger off now, because everything it was meant to do // was done in StartSpell. Note that this will call EndSpell() // because it calls Destroyed(). This will become clear soon. } 
}
//////////////////////
////////////////////

function SpawnRock()
{
	local Projectile Proj;
	local vector X,Y,Z, projStart;
	GetAxes(Rotation,X,Y,Z);
	
	MakeNoise(1.0);
	if (FRand() < 0.4)
	{
		projStart = Location + CollisionRadius * X + 0.4 * CollisionHeight * Z;
		Proj = spawn(class 'ShockProj' ,self,'',projStart,AdjustAim(1000, projStart, 400, false, true));
		if( Proj != None )
			Proj.SetPhysics(PHYS_Projectile);
		return;
	}
	
	projStart = Location + CollisionRadius * X + 0.4 * CollisionHeight * Z;
	Proj = spawn(class 'ShockProj' ,self,'',projStart,AdjustAim(1000, projStart, 400, false, true));
	if( Proj != None )
		Proj.SetPhysics(PHYS_Projectile);

	projStart = Location + CollisionRadius * X -  40 * Y + 0.4 * CollisionHeight * Z;
	Proj = spawn(class 'ShockProj' ,self,'',projStart,AdjustAim(1000, projStart, 400, true, true));
	if( Proj != None )
		Proj.SetPhysics(PHYS_Projectile);

	if (FRand() < 0.2 * skill)
	{
		projStart = Location + CollisionRadius * X + 40 * Y + 0.4 * CollisionHeight * Z;
		Proj = spawn(class 'ShockProj' ,self,'',projStart,AdjustAim(1000, projStart, 2000, false, true));
		if( Proj != None )
			Proj.SetPhysics(PHYS_Projectile);
	}
}
singular event BaseChange()
{
	local float decorMass;
	if (Pawn(Base) != None)
	{
		Base.TakeDamage( 10, Self,Location,0.5 * Velocity , 'stomped');
		JumpOffPawn();
	}
	else if ( (Decoration(Base) != None) && (Velocity.Z < -400) )
	{
		decorMass = FMax(Decoration(Base).Mass, 1);
		Base.TakeDamage(10, Self, Location, 0.5 * Velocity, 'stomped');
	}
}



////////////////////
///////////////////




//////////////
/*----------------------------------------------------------------
This is called by...  well, I dunno, but it's called when
 certain specified frames are reached in the Nali animation
See Nali.uc, the lines that have an "#EXEC blah blah FUNCTION=Step"
----------------------------------------------------------------*/
function Step()
	{
	//PlaySound_FootStep();
PlaySound(Sound'roam1Ti', SLOT_Talk,, true);
		PlaySound(Sound'roam1Ti', SLOT_Misc,, true);
	}


/*----------------------------------------------------------------
From Krall.
----------------------------------------------------------------*/

// The guard is just standing there
function PlayStanding()
	{
	local float animspeed;

	animspeed = 0.4 + 0.6 * FRand();
 	LoopAnim('TBrea001', animspeed);
	PlaySound(Slap, SLOT_Interact);
		PlaySound(Slap, SLOT_Misc);
	}

// The guard is walking/patrolling
function PlayCreeping()
	{
	PlayWalking();
	}

// The guard is walking/patrolling
function PlayWalking()
	{
	LoopAnim('TWalk001', -1.0/GroundSpeed,,0.4);
PlaySound(StompSound, SLOT_Talk);			
		PlaySound(StompSound, SLOT_Misc);
	}

// The guard is running
function PlayRunning()
	{
	LoopAnim('TWalk001', -1.0/GroundSpeed,,0.4);
PlaySound(StompSound, SLOT_Talk);			
		PlaySound(StompSound, SLOT_Misc);
	}

// The guard is looking around (i.e. hand above the eyes)
function PlayLooking()
	{
	local float animspeed;

	animspeed = 0.4 + 0.6 * FRand();
	LoopAnim('TShuffle', animspeed);
	}

// The guard just got suprised (jumps with surprise)
function PlaySurprised()
	{
	PlayAnim('TChest', 0.4 + 0.7 * FRand(), 0.5);
		PlaySound(Chest, SLOT_Interact);
		PlaySound(Chest, SLOT_Misc);
	}

// The guard shake's it's fist (i.e. when can't reach player)
function PlayAngry()
	{
	PlayAnim('TStom001', 1);
	PlaySound(Threaten, SLOT_Talk,, true);
		PlaySound(Threaten, SLOT_Misc,, true);
	}

// The guard fiddles with it's sword, adjust it's feet, whatever
function PlayIdleAnim()
	{
	local float decision;
	local float animspeed;

	animspeed = 0.4 + 0.6 * FRand();
	decision = FRand();
	if(decision < 0.33)
		PlayAnim('TFist', animspeed);
	else if(decision < 0.66)
		PlayAnim('TStom001', animspeed);
	else
		PlayAnim('TSnif001', animspeed);
	}

// The guard just got hit by a sword or arrow, etc
function PlayGotHit(float tweentime, vector HitLoc, int damage)
	{
	PlayAnim('TChest', 1);
	}

// The guard is pressing a button on the wall
function PlayFrob()
	{
	PlayAnim('TFist', 0.5);
	}

// The guard is talking
function PlayTalking()
	{
	PlayStanding();
	}

// The guard is yelling
function PlayYelling()
	{
	PlayStanding();
	}

// The guard is talking
function PlayInvestigating()
	{
	LoopAnim('TWalk001', 1);
	}

// The guard is a-choppin' and a-loppin'
function PlayMeleeAttack(optional float fSwingTime)
	{
	// TODO:  work in proper anim time
	
	local float decision;
	
	decision = FRand();
	if(decision < 0.33)
		{
//	PlaySound(Acquire, SLOT_Talk,, true); 
	//	PlaySound(Acquire, SLOT_Misc,, true);
		PlayAnim('TPunc001');
		return;
		}
	else if(decision < 0.66)
		{
PlaySound(swing, SLOT_Interact);			
		PlaySound(swing, SLOT_Misc);	
		PlayAnim('TSlap001');
		return;
		}
	else
		{
PlaySound(swing, SLOT_Interact);			
		PlaySound(swing, SLOT_Misc);	
		PlayAnim('TChest');
		return;
		}
	}

// The guard is poppin' caps
function PlayRangedAttack()
	{
	local float tweenin;

	if(AnimSequence == 'TThro001')
		tweenin = 0.3 * FRand();
	else
		tweenin = 0.35;
	PlayAnim('TThro001', 1.0, tweenin);
	}

// The guard is getting into the sleeping position
function PlayLayingDown()
	{
	PlayAnim('TSit', 1);
	}

// The guard is getting out of the sleeping position
function PlayWakingUp()
	{
	AnimSequence = 'Crouch';
	AnimFrame = 0.0;
	TweenAnim('TBrea001', 1);
	}

// The guard is sleeping
function PlaySleeping()
	{
	LoopAnim('TDeat001');
	}

// The guard is airborne
function PlayInAir()
	{
	TweenAnim('TSit', 0.2);
	}

function PlayLanded(float impactVel)
	{
	TweenAnim('TGetUp', 0.1);
	}

// The bot has killed a foe
function PlayTaunting()
	{
	PlayStanding();
	}

// The bot has been flashbombed
function PlayBlinded()
	{
	if(AnimSequence == 'TShuffle')
		LoopAnim('TShuffle', FRand()*0.5 + 0.75);
	else
		TweenAnim('TShuffle', 0.25);
	}

// The bot has been cracked, and is rubbing his eyes or stumbling
//  about a bit or whatever
function PlayCracked()
	{
	PlayBlinded();
	}


// Deaths

function PlayBigDeath(name DamageType)
	{
	PlayAnim('TDeath002',0.7,0.1);
	}


function PlayLeftDeath(name DamageType)
	{
	PlayAnim('TDeat003',0.7, 0.1);
	}

function PlayRightDeath(name DamageType)
	{
	PlayAnim('TDeat001',0.7,0.1);
	}

function PlayGutDeath(name DamageType)
	{
	if ( Velocity.Z > 100 )
		PlayAnim('TDeat003',0.7,0.1);
	else
		PlayAnim('TDeat001',0.7,0.1);
	}

/*----------------------------------------------------------------
// Tweening
----------------------------------------------------------------*/

function TweenToStand(float tweentime)
	{
	TweenAnim('TBrea001', tweentime);
	}

function TweenToFalling()
	{
	TweenAnim('TGetUp', 0.5);
	}

/*----------------------------------------------------------------
----------------------------------------------------------------*/
function PlayDying(name DamageType, vector HitLocation)
{
	local float decision;
local Effects FX;
	Decision = FRand();
	if (Decision <= 0.1)
		FX = spawn(class'ShieldBeltEffect');
	else if (Decision >= 0.2)
		FX = spawn(class'Tazerexplosion');
	else
		FX = spawn(class'UT_Comboring');
	
	PlaySound(Die, SLOT_Talk);	
	PlaySound(Die, SLOT_Misc);	
}


function Timer()
 {
local Effects FX2;
PlayerTimeOut();
		FX2 = spawn(class'UT_Comboring');
}

defaultproperties
{
     DurationSeconds=30.000000
     CastingEffect=Class'Botpack.TranslocGreen'
     CastingSound=Sound'UnrealI.Razorjack.beam'
     SlapDamage=20
     PunchDamage=20
     HelmetedHeadTexture=None
     UnhelmetedHeadTexture=None
     bRandomHeadSkin=False
     RandomHeadTextures(0)=None
     RandomHeadTextures(1)=None
     RandomHeadTextures(2)=None
     RandomHeadTextures(3)=None
     RandomVoiceSets(0)=""
     RandomVoiceSets(1)=""
     RandomVoiceSets(2)=""
     RandomVoiceSets(3)=""
     AttitudeToPlayerClass(0)=ETAT_Hate
     AttitudeToPlayerClass(1)=ETAT_Hate
     AttitudeToPlayerClass(2)=ETAT_Hate
     AttitudeToPlayerClass(3)=ETAT_Hate
     AttitudeToPlayerClass(4)=ETAT_Hate
     AttitudeToPlayerClass(5)=ETAT_Hate
     AttitudeToPlayerClass(6)=ETAT_Hate
     AttitudeToPlayerClass(7)=ETAT_Hate
     Team=5
     FootstepSoundPackage=""
     drown=Sound'UnrealI.Titan.death1t'
     breathagain=Sound'UnrealI.Titan.roam1Ti'
     HitSound3=Sound'UnrealI.Titan.injur1t'
     HitSound4=Sound'UnrealI.Titan.injur2t'
     GaspSound=Sound'UnrealI.Titan.roam1Ti'
     LandGrunt=Sound'UnrealI.Titan.fall1Ti'
     JumpSound=Sound'UnrealI.Titan.stomp4t'
     bInvulnerable=True
     Orders=Roam
     Formation=None
     DefaultLoadoutClass=None
     bThrowsFlares=False
     FlareClass=None
     BotName="an Easter Egg."
     RangedProjectile=Class'ThieveryMod.ThProjectileMossArrow'
     Skill=1.000000
     LifeSpan=30.000000
     Style=STY_Translucent
     Mesh=LodMesh'UnrealI.Titan1'
     DrawScale=0.250000
     MultiSkins(0)=FireTexture'UnrealShare.Belt_fx.Damage.Pulsehit'
     MultiSkins(1)=None
     MultiSkins(2)=None
     MultiSkins(3)=None
     CollisionRadius=30.000000
     CollisionHeight=30.000000
     bCollideActors=False
     bBlockActors=False
     bBlockPlayers=False
}
