// ============================================================
// ThProjectileSpecialWaterArrow: Splashes water on detonate to put out torches
// ============================================================

class ThProTenWaterArrow expands ThieveryProjectileArrows;

#exec MESH IMPORT MESH=ThProjectileWaterArrow ANIVFILE=MODELS\arrow\waterarrow_a.3d DATAFILE=MODELS\arrow\waterarrow_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=ThProjectileWaterArrow X=0 Y=0 Z=0 YAW=-64

#exec MESH SEQUENCE MESH=ThProjectileWaterArrow SEQ=All STARTFRAME=0 NUMFRAMES=13
//#exec MESH SEQUENCE MESH=waterarrow SEQ=??? STARTFRAME=0 NUMFRAMES=13

#exec MESHMAP NEW MESHMAP=ThProjectileWaterArrow MESH=ThProjectileWaterArrow
#exec MESHMAP SCALE MESHMAP=ThProjectileWaterArrow X=0.04 Y=0.04 Z=0.08

#exec MESHMAP SETTEXTURE MESHMAP=ThProjectileWaterArrow NUM=1 TEXTURE=wateraJtex1


simulated function ProcessTouch( Actor Other, Vector HitLocation ) {
	local int hitdamage;
	local TSuspiciousThing st;

	if ( Other != self && Other != MOwner && !HasLanded && Other!=Owner) {
		//log(self$" touched by:"$Other);
		if ( Role == ROLE_Authority ) {
			Other.TakeDamage(damage, instigator,HitLocation,
				(MomentumTransfer * Normal(Velocity)), 'RangedArrow');
			DoExplosion();
			st = Spawn(class'TSTWater', , , location, Rotator(Vect(0,0,-1)));
		}
		Destroy();
	}
}

simulated function HitWall( vector HitNormal, actor Wall ) {
	local TSuspiciousThing st;
	if ( Role == ROLE_Authority ) {
		SetLocation(Location+HitNormal*5);
		DoExplosion();
		//st = Spawn(class'TSTWater', , , location, Rotator(Vect(0,0,-1)));
		st = Spawn(class'TSTWater', , , location, rotator(-HitNormal));
	}
	Super.Hitwall(HitNormal, Wall);
}

// water arrows always burst and get destroyed
simulated function CheckForDestroy() {
	Destroy();
}

function DoExplosion() {
	local ThieveryTorchTrigger a;
	local ThObjectWhistler w;
	local FireArrowFlameGenerator t;
	local TSuspiciousThing st;
	local ThObjectBurningFlare flare;
	local ThieveryDamageActor dam;
	local TBaseBot tb;
	local ThieveryPPawn tpp;
	local ThObjectMossPiece bmp;

	//log("Splashing water");
	spawn(class'WaterArrowSplashGenerator');
	PlaySound(sound'ThieveryData.WaterArrow', SLOT_None, 0.5);
	foreach RadiusActors(class'ThieveryTorchTrigger',a,50) {
		//if (a.LightType!=LT_None) {
			//a.bAlwaysRelevant=true;
			//a.NetPriority=1.4;
			//a.NetUpdateFrequency=10;
			//a.LightType=LT_None;
		//}

		if (FastTrace(Location, a.Location)) a.ActivateTrigger(Owner);
	}
	foreach RadiusActors(class'FireArrowFlameGenerator',t,50) {
		t.Destroy();
	}
	foreach RadiusActors(class'TSuspiciousThing',st,50) {
		if (st.bWaterDestroys) {
			st.Destroy();
		}
	}
	// if splash a whistler, disable it
	foreach RadiusActors(class'ThObjectWhistler',w,50) {
		w.WaterSplashed();
	}
	// if splash a burning flare, put it out
	foreach RadiusActors(class'ThObjectBurningFlare',flare,50) {
		flare.Disable('Timer');
		flare.PutOutFlare();
	}
		// splashing bots
	foreach RadiusActors(class'TBaseBot',tb,50) {
		tb.Splashed();
		ThieveryDeathMatchPlus(Level.Game).PawnSplashed(tb, Instigator);
	}

	// put out any effects attached to this player
	foreach RadiusActors(class'ThieveryPPawn',tpp,50) {
		tpp.Splashed();
		ThieveryDeathMatchPlus(Level.Game).PawnSplashed(tpp, Instigator);
	}
         //  Water splashes on moss grows plants
	foreach RadiusActors(class'ThObjectMossPiece',bmp,2) {
		bmp.DrawScale=2.0;
	}
}

simulated function Timer() {
	local Particle p;
	if ((class'ThieveryMod.ThieveryConfigClient'.default.ArrowTrails) &&
		(Owner!=none) && (Owner.IsA('PlayerPawn')) && ((Owner.Role==ROLE_AutonomousProxy) || (Owner.Role==ROLE_Authority))) {
		p=spawn(TrailParticleClass);
		p.Texture=texture'DarkBlueParticle';
	}
	if (Physics!=PHYS_Falling) {
		Disable('Timer');
		//if (class'ThieveryMod.ThieveryConfigClient'.default.ArrowTrails) SetTimer(0.005,false);
	}
}

defaultproperties
{
    ItemName="Water Arrow"
    bCountsTowardsRangedStats=False
    Damage=1.00
    ImpactSound=None
    Mesh=LodMesh'ThieveryMod.ThProjectileWaterArrow'
}
