//===============================================================================
//	Underworld Crossbow
//	Contains the crossbow models as well as the bolt models. Changes the bolt model
//	to the Underworld equivalent in ProjectileFire().
//===============================================================================
class ThProTenWeaponCrossbow extends ThWeaponCrossbow config(Underworld);

/////////////////////////////////////////////// STANDARD 1st Per Bolt XBow//////////////////////////////////////////////////////////////////
#exec MESH  MODELIMPORT MESH=TUT_Bow_BoltMesh MODELFILE=models\TUT_Bow_Bolt.PSK LODSTYLE=10
#exec MESH  ORIGIN MESH=TUT_Bow_BoltMesh X=0 Y=0 Z=0 YAW=192 PITCH=0 ROLL=0
#exec ANIM  IMPORT ANIM=TUT_Bow_BoltAnims ANIMFILE=models\TUTXbow.PSA COMPRESS=1 MAXKEYS=999999
#exec MESHMAP   SCALE MESHMAP=TUT_Bow_BoltMesh X=1.0 Y=1.0 Z=1.0
#exec MESH  DEFAULTANIM MESH=TUT_Bow_BoltMesh ANIM=TUT_Bow_BoltAnims

// Animation sequences. These can replace or override the implicit (exporter-defined) sequences.
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_BoltAnims SEQ=Down STARTFRAME=0 NUMFRAMES=11 RATE=11.0000 COMPRESS=1.00 GROUP=None
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_BoltAnims SEQ=DownSimple STARTFRAME=11 NUMFRAMES=11 RATE=11.0000 COMPRESS=1.00 GROUP=None
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_BoltAnims SEQ=Select STARTFRAME=22 NUMFRAMES=11 RATE=11.0000 COMPRESS=1.00 GROUP=None
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_BoltAnims SEQ=Still STARTFRAME=33 NUMFRAMES=1 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_BoltAnims SEQ=Idle STARTFRAME=34 NUMFRAMES=1 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_BoltAnims SEQ=Empty STARTFRAME=35 NUMFRAMES=1 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_BoltAnims SEQ=Firing STARTFRAME=36 NUMFRAMES=32 RATE=30.0000 COMPRESS=1.00 GROUP=None 

// Digest and compress the animation data. Must come after the sequence declarations.
// 'VERBOSE' gives more debugging info in UCC.log 
#exec ANIM DIGEST ANIM=TUT_Bow_BoltAnims  VERBOSE

#EXEC TEXTURE IMPORT NAME=TUT_Bow_BoltTex0  FILE=TEXTURES\First_Person_Xbow_Bolt.bmp  GROUP=Skins

#EXEC MESHMAP SETTEXTURE MESHMAP=TUT_Bow_BoltMesh NUM=0 TEXTURE=TUT_Bow_BoltTex0

// Original material [0] is [Material #71] SkinIndex: 0 Bitmap: First_Person_Xbow_Bolt.bmp  Path: C:\UnrealTournament\THXbow\Textures



////////////////////////////////////////////////////////Bow Bolt 3rd/////////////////////////////////////////////////////////
#exec MESH  MODELIMPORT MESH=TUT_Bow_Bolt_3rdMesh MODELFILE=models\TUT_Bow_Bolt_3rd.PSK LODSTYLE=10
#exec MESH  ORIGIN MESH=TUT_Bow_Bolt_3rdMesh X=0 Y=0 Z=0 YAW=64 PITCH=-32 ROLL=32
#exec ANIM  IMPORT ANIM=TUT_Bow_Bolt_3rdAnims ANIMFILE=models\TUT_Bow_Bolt_3rd.PSA COMPRESS=1 MAXKEYS=999999
#exec MESHMAP   SCALE MESHMAP=TUT_Bow_Bolt_3rdMesh X=1.0 Y=1.0 Z=1.0
#exec MESH  DEFAULTANIM MESH=TUT_Bow_Bolt_3rdMesh ANIM=TUT_Bow_Bolt_3rdAnims

// Animation sequences. These can replace or override the implicit (exporter-defined) sequences.
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_Bolt_3rdAnims SEQ=Plain STARTFRAME=0 NUMFRAMES=1 RATE=30.0000 COMPRESS=1.00 GROUP=None 

// Digest and compress the animation data. Must come after the sequence declarations.
// 'VERBOSE' gives more debugging info in UCC.log 
#exec ANIM DIGEST ANIM=TUT_Bow_Bolt_3rdAnims  VERBOSE

#EXEC TEXTURE IMPORT NAME=TUT_Bow_Bolt_3rdTex0  FILE=TEXTURES\XBow_3rdPerson.bmp  GROUP=Skins

#EXEC MESHMAP SETTEXTURE MESHMAP=TUT_Bow_Bolt_3rdMesh NUM=0 TEXTURE=TUT_Bow_Bolt_3rdTex0

// Original material [0] is [Material #61] SkinIndex: 0 Bitmap: XBow_3rdPerson.bmp  Path: C:\UnrealTournament\Underworld\Textures
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////Fire Mesh 1st////////////////////////////////////////////////////////////
#exec MESH  MODELIMPORT MESH=TUT_Bow_FireMesh MODELFILE=models\TUT_Bow_Fire.PSK LODSTYLE=10
#exec MESH  ORIGIN MESH=TUT_Bow_FireMesh X=0 Y=0 Z=0 YAW=192 PITCH=0 ROLL=0
#exec ANIM  IMPORT ANIM=TUT_Bow_FireAnims ANIMFILE=models\TUTXbow_fire.PSA COMPRESS=1 MAXKEYS=999999
#exec MESHMAP   SCALE MESHMAP=TUT_Bow_FireMesh X=1.0 Y=1.0 Z=1.0
#exec MESH  DEFAULTANIM MESH=TUT_Bow_FireMesh ANIM=TUT_Bow_FireAnims

// Animation sequences. These can replace or override the implicit (exporter-defined) sequences.
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_FireAnims SEQ=Idle STARTFRAME=0 NUMFRAMES=11 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_FireAnims SEQ=Still STARTFRAME=11 NUMFRAMES=1 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_FireAnims SEQ=Firing STARTFRAME=12 NUMFRAMES=32 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_FireAnims SEQ=Down STARTFRAME=44 NUMFRAMES=11 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_FireAnims SEQ=DownSimple STARTFRAME=55 NUMFRAMES=11 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_FireAnims SEQ=Select STARTFRAME=66 NUMFRAMES=11 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_FireAnims SEQ=Empty STARTFRAME=77 NUMFRAMES=1 RATE=30.0000 COMPRESS=1.00 GROUP=None 

// Digest and compress the animation data. Must come after the sequence declarations.
// 'VERBOSE' gives more debugging info in UCC.log 
#exec ANIM DIGEST ANIM=TUT_Bow_FireAnims  VERBOSE

#EXEC TEXTURE IMPORT NAME=TUT_Bow_FireTex0  FILE=TEXTURES\First_Person_Xbow_fire.bmp  GROUP=Skins

#EXEC MESHMAP SETTEXTURE MESHMAP=TUT_Bow_FireMesh NUM=0 TEXTURE=TUT_Bow_FireTex0

// Original material [0] is [3 - D] SkinIndex: 0 Bitmap: First_Person_Xbow_fire.bmp  Path: C:\UnrealTournament\THXbow\Textures
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////Fire 3rd///////////////////////////////////////////////////////////////
#exec MESH  MODELIMPORT MESH=TUT_Bow_Fire_3rdMesh MODELFILE=models\TUT_Bow_Fire_3rd.PSK LODSTYLE=10
#exec MESH  ORIGIN MESH=TUT_Bow_Fire_3rdMesh X=0 Y=0 Z=0 YAW=64 PITCH=-32 ROLL=32
#exec ANIM  IMPORT ANIM=TUT_Bow_Fire_3rdAnims ANIMFILE=models\TUT_Bow_Bolt_3rd.PSA COMPRESS=1 MAXKEYS=999999
#exec MESHMAP   SCALE MESHMAP=TUT_Bow_Fire_3rdMesh X=1.0 Y=1.0 Z=1.0
#exec MESH  DEFAULTANIM MESH=TUT_Bow_Fire_3rdMesh ANIM=TUT_Bow_Fire_3rdAnims

// Animation sequences. These can replace or override the implicit (exporter-defined) sequences.
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_Fire_3rdAnims SEQ=Plain STARTFRAME=0 NUMFRAMES=1 RATE=30.0000 COMPRESS=1.00 GROUP=None 

// Digest and compress the animation data. Must come after the sequence declarations.
// 'VERBOSE' gives more debugging info in UCC.log 
#exec ANIM DIGEST ANIM=TUT_Bow_Fire_3rdAnims  VERBOSE

#EXEC TEXTURE IMPORT NAME=TUT_Bow_Fire_3rdTex0  FILE=TEXTURES\XBow_3rdPerson.bmp  GROUP=Skins

#EXEC MESHMAP SETTEXTURE MESHMAP=TUT_Bow_Fire_3rdMesh NUM=0 TEXTURE=TUT_Bow_Fire_3rdTex0

// Original material [0] is [Material #61] SkinIndex: 0 Bitmap: XBow_3rdPerson.bmp  Path: C:\UnrealTournament\Underworld\Textures
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////TAG MESH 1st////////////////////////////////////////////////////////////
#exec MESH  MODELIMPORT MESH=TUT_Bow_TAGMesh MODELFILE=models\TUT_Bow_TAG.PSK LODSTYLE=10
#exec MESH  ORIGIN MESH=TUT_Bow_TAGMesh X=0 Y=0 Z=0 YAW=192 PITCH=0 ROLL=0
#exec ANIM  IMPORT ANIM=TUT_Bow_TAGAnims ANIMFILE=models\TUTXbow_Para.PSA COMPRESS=1 MAXKEYS=999999
#exec MESHMAP   SCALE MESHMAP=TUT_Bow_TAGMesh X=1.0 Y=1.0 Z=1.0
#exec MESH  DEFAULTANIM MESH=TUT_Bow_TAGMesh ANIM=TUT_Bow_TAGAnims

// Animation sequences. These can replace or override the implicit (exporter-defined) sequences.
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_TAGAnims SEQ=Empty STARTFRAME=0 NUMFRAMES=1 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_TAGAnims SEQ=Idle STARTFRAME=1 NUMFRAMES=11 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_TAGAnims SEQ=Still STARTFRAME=12 NUMFRAMES=1 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_TAGAnims SEQ=Firing STARTFRAME=13 NUMFRAMES=32 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_TAGAnims SEQ=Down STARTFRAME=45 NUMFRAMES=11 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_TAGAnims SEQ=DownSimple STARTFRAME=56 NUMFRAMES=11 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_TAGAnims SEQ=Select STARTFRAME=67 NUMFRAMES=11 RATE=30.0000 COMPRESS=1.00 GROUP=None 

// Digest and compress the animation data. Must come after the sequence declarations.
// 'VERBOSE' gives more debugging info in UCC.log 
#exec ANIM DIGEST ANIM=TUT_Bow_TAGAnims  VERBOSE

#EXEC TEXTURE IMPORT NAME=TUT_Bow_TAGTex0  FILE=TEXTURES\First_Person_Xbow_Tag.bmp  GROUP=Skins

#EXEC MESHMAP SETTEXTURE MESHMAP=TUT_Bow_TAGMesh NUM=0 TEXTURE=TUT_Bow_TAGTex0

// Original material [0] is [Material #71] SkinIndex: 0 Bitmap: First_Person_Xbow_Tag.bmp  Path: C:\UnrealTournament\THXbow\Textures
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////TAGMESH 3rd/////////////////////////////////////////////////////////////////////
#exec MESH  MODELIMPORT MESH=TUT_Bow_Tag_3rdMesh MODELFILE=models\TUT_Bow_Tag_3rd.PSK LODSTYLE=10
#exec MESH  ORIGIN MESH=TUT_Bow_Tag_3rdMesh X=0 Y=0 Z=0 YAW=64 PITCH=-32 ROLL=32
#exec ANIM  IMPORT ANIM=TUT_Bow_Tag_3rdAnims ANIMFILE=models\TUT_Bow_Bolt_3rd.PSA COMPRESS=1 MAXKEYS=999999
#exec MESHMAP   SCALE MESHMAP=TUT_Bow_Tag_3rdMesh X=1.0 Y=1.0 Z=1.0
#exec MESH  DEFAULTANIM MESH=TUT_Bow_Tag_3rdMesh ANIM=TUT_Bow_Tag_3rdAnims

// Animation sequences. These can replace or override the implicit (exporter-defined) sequences.
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_Tag_3rdAnims SEQ=Plain STARTFRAME=0 NUMFRAMES=1 RATE=30.0000 COMPRESS=1.00 GROUP=None 

// Digest and compress the animation data. Must come after the sequence declarations.
// 'VERBOSE' gives more debugging info in UCC.log 
#exec ANIM DIGEST ANIM=TUT_Bow_Tag_3rdAnims  VERBOSE

#EXEC TEXTURE IMPORT NAME=TUT_Bow_Tag_3rdTex0  FILE=TEXTURES\XBow_3rdPerson.bmp  GROUP=Skins

#EXEC MESHMAP SETTEXTURE MESHMAP=TUT_Bow_Tag_3rdMesh NUM=0 TEXTURE=TUT_Bow_Tag_3rdTex0

// Original material [0] is [Material #61] SkinIndex: 0 Bitmap: XBow_3rdPerson.bmp  Path: C:\UnrealTournament\Underworld\Textures
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////PARA 1st Mesh IMPORT////////////////////////////////////////////////////////////////////////
#exec MESH  MODELIMPORT MESH=TUT_Bow_ParaMesh MODELFILE=models\TUT_Bow_Para.PSK LODSTYLE=10
#exec MESH  ORIGIN MESH=TUT_Bow_ParaMesh X=0 Y=0 Z=0 YAW=192 PITCH=0 ROLL=0
#exec ANIM  IMPORT ANIM=TUT_Bow_ParaAnims ANIMFILE=models\TUTXbow_Para.PSA COMPRESS=1 MAXKEYS=999999
#exec MESHMAP   SCALE MESHMAP=TUT_Bow_ParaMesh X=1.0 Y=1.0 Z=1.0
#exec MESH  DEFAULTANIM MESH=TUT_Bow_ParaMesh ANIM=TUT_Bow_ParaAnims

// Animation sequences. These can replace or override the implicit (exporter-defined) sequences.
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_ParaAnims SEQ=Empty STARTFRAME=0 NUMFRAMES=1 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_ParaAnims SEQ=Idle STARTFRAME=1 NUMFRAMES=11 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_ParaAnims SEQ=Still STARTFRAME=12 NUMFRAMES=1 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_ParaAnims SEQ=Firing STARTFRAME=13 NUMFRAMES=32 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_ParaAnims SEQ=Down STARTFRAME=45 NUMFRAMES=11 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_ParaAnims SEQ=DownSimple STARTFRAME=56 NUMFRAMES=11 RATE=30.0000 COMPRESS=1.00 GROUP=None 
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_ParaAnims SEQ=Select STARTFRAME=67 NUMFRAMES=11 RATE=30.0000 COMPRESS=1.00 GROUP=None 

// Digest and compress the animation data. Must come after the sequence declarations.
// 'VERBOSE' gives more debugging info in UCC.log 
#exec ANIM DIGEST ANIM=TUT_Bow_ParaAnims  VERBOSE

#EXEC TEXTURE IMPORT NAME=TUT_Bow_ParaTex0  FILE=TEXTURES\First_Person_Xbow_Para.bmp  GROUP=Skins

#EXEC MESHMAP SETTEXTURE MESHMAP=TUT_Bow_ParaMesh NUM=0 TEXTURE=TUT_Bow_ParaTex0

// Original material [0] is [Material #71] SkinIndex: 0 Bitmap: First_Person_Xbow_Para.bmp  Path: C:\UnrealTournament\THXbow\Textures
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////PARA IMPORT//////////////////////////////////

#exec MESH  MODELIMPORT MESH=TUT_Bow_Para_3rdMesh MODELFILE=models\TUT_Bow_Para_3rd.PSK LODSTYLE=10
#exec MESH  ORIGIN MESH=TUT_Bow_Para_3rdMesh X=0 Y=0 Z=0 YAW=64 PITCH=-32 ROLL=32
#exec ANIM  IMPORT ANIM=TUT_Bow_Para_3rdAnims ANIMFILE=models\TUT_Bow_Bolt_3rd.PSA COMPRESS=1 MAXKEYS=999999
#exec MESHMAP   SCALE MESHMAP=TUT_Bow_Para_3rdMesh X=1.0 Y=1.0 Z=1.0
#exec MESH  DEFAULTANIM MESH=TUT_Bow_Para_3rdMesh ANIM=TUT_Bow_Para_3rdAnims

// Animation sequences. These can replace or override the implicit (exporter-defined) sequences.
#EXEC ANIM  SEQUENCE ANIM=TUT_Bow_Para_3rdAnims SEQ=Plain STARTFRAME=0 NUMFRAMES=1 RATE=30.0000 COMPRESS=1.00 GROUP=None 

// Digest and compress the animation data. Must come after the sequence declarations.
// 'VERBOSE' gives more debugging info in UCC.log
#exec ANIM DIGEST ANIM=TUT_Bow_Para_3rdAnims  VERBOSE

#EXEC TEXTURE IMPORT NAME=TUT_Bow_Para_3rdTex0  FILE=TEXTURES\XBow_3rdPerson.bmp  GROUP=Skins

#EXEC MESHMAP SETTEXTURE MESHMAP=TUT_Bow_Para_3rdMesh NUM=0 TEXTURE=TUT_Bow_Para_3rdTex0

// Original material [0] is [Material #61] SkinIndex: 0 Bitmap: XBow_3rdPerson.bmp  Path: C:\UnrealTournament\Underworld\Textures
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////



// Bolts

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#exec MESH  MODELIMPORT MESH=UwBoltMesh MODELFILE=models\UwBolt.PSK LODSTYLE=10
#exec MESH  ORIGIN MESH=UwBoltMesh X=0 Y=0 Z=0 YAW=192 PITCH=0 ROLL=0
#exec ANIM  IMPORT ANIM=UwBoltAnims ANIMFILE=models\UwBolt.PSA COMPRESS=1 MAXKEYS=999999 IMPORTSEQS=1
#exec MESHMAP   SCALE MESHMAP=UwBoltMesh X=0.75 Y=0.50 Z=0.75
#exec MESH  DEFAULTANIM MESH=UwBoltMesh ANIM=UwBoltAnims
// Digest and compress the animation data. Must come after the sequence declarations.
// 'VERBOSE' gives more debugging info in UCC.log 
#exec ANIM DIGEST ANIM=UwBoltAnims USERAWINFO VERBOSE
#EXEC TEXTURE IMPORT NAME=UwBoltTex0  FILE=TEXTURES\Bolt.bmp  GROUP=Skins
#EXEC MESHMAP SETTEXTURE MESHMAP=UwBoltMesh NUM=0 TEXTURE=UwBoltTex0
// Original material [0] is [3 - Default] SkinIndex: 0 Bitmap: Bolt.bmp  Path: C:\UnrealTournament\Underworld\Textures

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#exec MESH  MODELIMPORT MESH=UwFireBoltMesh MODELFILE=models\UwFireBolt.PSK LODSTYLE=10
#exec MESH  ORIGIN MESH=UwFireBoltMesh X=0 Y=0 Z=0 YAW=192 PITCH=0 ROLL=0
#exec ANIM  IMPORT ANIM=UwFireBoltAnims ANIMFILE=models\UwFireBolt.PSA COMPRESS=1 MAXKEYS=999999 IMPORTSEQS=1
#exec MESHMAP   SCALE MESHMAP=UwFireBoltMesh X=0.75 Y=0.50 Z=0.75
#exec MESH  DEFAULTANIM MESH=UwFireBoltMesh ANIM=UwFireBoltAnims
#exec ANIM DIGEST ANIM=UwFireBoltAnims USERAWINFO VERBOSE
#EXEC TEXTURE IMPORT NAME=UwFireBoltTex0  FILE=TEXTURES\Firebolt.bmp  GROUP=Skins
#EXEC MESHMAP SETTEXTURE MESHMAP=UwFireBoltMesh NUM=0 TEXTURE=UwFireBoltTex0
// Original material [0] is [Material #71] SkinIndex: 0 Bitmap: Firebolt.bmp  Path: C:\UnrealTournament\Underworld\Textures 

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#exec MESH  MODELIMPORT MESH=UwParaBoltMesh MODELFILE=models\UwParaBolt.PSK LODSTYLE=10
#exec MESH  ORIGIN MESH=UwParaBoltMesh X=0 Y=0 Z=0 YAW=192 PITCH=0 ROLL=0
#exec ANIM  IMPORT ANIM=UwParaBoltAnims ANIMFILE=models\UwParaBolt.PSA COMPRESS=1 MAXKEYS=999999 IMPORTSEQS=1
#exec MESHMAP   SCALE MESHMAP=UwParaBoltMesh X=0.75 Y=0.50 Z=0.75
#exec MESH  DEFAULTANIM MESH=UwParaBoltMesh ANIM=UwParaBoltAnims
#exec ANIM DIGEST ANIM=UwParaBoltAnims USERAWINFO VERBOSE
#EXEC TEXTURE IMPORT NAME=UwParaBoltTex0  FILE=TEXTURES\Poisonbolt.bmp  GROUP=Skins
#EXEC MESHMAP SETTEXTURE MESHMAP=UwParaBoltMesh NUM=0 TEXTURE=UwParaBoltTex0
// Original material [0] is [Material #71] SkinIndex: 0 Bitmap: Poisonbolt.bmp  Path: C:\UnrealTournament\Underworld\Textures 

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#exec MESH  MODELIMPORT MESH=UwTagBoltMesh MODELFILE=models\UwTagBolt.PSK LODSTYLE=10
#exec MESH  ORIGIN MESH=UwTagBoltMesh X=0 Y=0 Z=0 YAW=192 PITCH=0 ROLL=0
#exec ANIM  IMPORT ANIM=UwTagBoltAnims ANIMFILE=models\UwTagBolt.PSA COMPRESS=1 MAXKEYS=999999 IMPORTSEQS=1
#exec MESHMAP   SCALE MESHMAP=UwTagBoltMesh X=0.75 Y=0.50 Z=0.75
#exec MESH  DEFAULTANIM MESH=UwTagBoltMesh ANIM=UwTagBoltAnims
#exec ANIM DIGEST ANIM=UwTagBoltAnims USERAWINFO VERBOSE
#EXEC TEXTURE IMPORT NAME=UwTagBoltTex0  FILE=TEXTURES\Tagbolt.bmp  GROUP=Skins
#EXEC MESHMAP SETTEXTURE MESHMAP=UwTagBoltMesh NUM=0 TEXTURE=UwTagBoltTex0
// Original material [0] is [Material #71] SkinIndex: 0 Bitmap: Tagbolt.bmp  Path: C:\UnrealTournament\Underworld\Textures 

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


// Bow meshes
var(UWCrossbow) config SkeletalMesh ParalyseMesh;
var(UWCrossbow) config SkeletalMesh TagMesh;
var(UWCrossbow) config SkeletalMesh FireMesh;
var(UWCrossbow) config SkeletalMesh StandardBoltMesh;
var(UWCrossbow) config SkeletalMesh ParalyseMesh3rd;
var(UWCrossbow) config SkeletalMesh TagMesh3rd;
var(UWCrossbow) config SkeletalMesh FireMesh3rd;
var(UWCrossbow) config SkeletalMesh StandardBoltMesh3rd;

/* ** Moved to UWSpawnReplacer **
// Bolt meshes and textures
var(UWBolts) config LodMesh ParalyseBoltMesh;
var(UWBolts) config Texture ParalyseBoltTex;
var(UWBolts) config LodMesh TagBoltMesh;
var(UWBolts) config Texture TagBoltTex;
var(UWBolts) config LodMesh FireBoltMesh;
var(UWBolts) config Texture FireBoltTex;
var(UWBolts) config LodMesh BoltMesh;
var(UWBolts) config Texture BoltTex;
*/


// Change the view model to match the munition type
// Called by ChangeWeaponAmmo() in UnderworldPlayerPawn
simulated function SetModel(Class<Projectile> by_projectile)
{
	// I figure it's not really worth checking if the ProjectileClass has
	// actually changed since last time

	switch (by_projectile)
	{
		case class'ThProjectileParalyseBolt':
			Mesh = ParalyseMesh;
			ThirdPersonMesh = ParalyseMesh3rd;
			break;
		case class'ThProjectileTagBolt':
			Mesh = TagMesh;
			ThirdPersonMesh = TagMesh3rd;
			break;
		case class'ThProjectileFireBolt':
			Mesh = FireMesh;
			ThirdPersonMesh = FireMesh3rd;
			break;
		default:
			Mesh = StandardBoltMesh;
			ThirdPersonMesh = StandardBoltMesh3rd;
	}
}

/* ** Moved to UWSpawnReplacer **
// Make the bolt look like its Underworld equivalent
function Projectile TransmogrifyBolt(Projectile bolt)
{
	local LodMesh bolt_mesh;
	local Texture bolt_tex;

	switch (bolt.Class)
	{
		case class'ThProjectileStandardBolt':
			bolt_mesh = BoltMesh;
			bolt_tex = BoltTex;
			break;
		case class'ThProjectileFireBolt':
			bolt_mesh = FireBoltMesh;
			bolt_tex = FireBoltTex;
			break;
		case class'ThProjectileParalyseBolt':
			bolt_mesh = ParalyseBoltMesh;
			bolt_tex = ParalyseBoltTex;
			break;
		case class'ThProjectileTagBolt':
			bolt_mesh = TagBoltMesh;
			bolt_tex = TagBoltTex;
			break;
		default:
			return bolt;
	}
	bolt.Mesh = bolt_mesh;
	bolt.MultiSkins[0] = bolt_tex;
	bolt.MultiSkins[1] = bolt_tex;
	bolt.MultiSkins[2] = bolt_tex;
	bolt.MultiSkins[3] = bolt_tex;

	return bolt;
}

function Projectile ProjectileFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn)
{
	return TransmogrifyBolt(Super.ProjectileFire(ProjClass, ProjSpeed, bWarn));
}
*/

state Reloading {
	function Fire( float Value ) { }
	simulated function bool ClientFire( float Value ) { return false; }

	simulated function Tick(float deltaTime) {
		Super.Tick(deltaTime);
	}

	simulated function BeginState() {
		ReloadingTime = DelayBetweenShots;
		if (AmmoType.AmmoAmount < 1) {
			PlayerPawn(owner).SwitchWeapon(1);
			GotoState('DownWeapon');
		} else {
			PlayAnim('Down'); // This one was TweenAnim
		}
	}

	simulated function AnimEnd() {
		Super.AnimEnd();
	}
}

function TBotFire(float Charge)
{
	SetModel(ProjectileClass);
	Super.TBotFire(Charge);
}

defaultproperties
{
	// UWCrossbow
	ParalyseMesh=SkeletalMesh'ThTenth.TUT_Bow_ParaMesh'
	ParalyseMesh3rd=skeletalmesh'ThTenth.TUT_Bow_Para_3rdMesh'
	TagMesh=SkeletalMesh'ThTenth.TUT_Bow_TagMesh'
	TagMesh3rd=skeletalmesh'ThTenth.TUT_Bow_Tag_3rdMesh'
	FireMesh=SkeletalMesh'ThTenth.TUT_Bow_FireMesh'
	FireMesh3rd=skeletalmesh'ThTenth.TUT_Bow_Fire_3rdMesh'
	StandardBoltMesh=SkeletalMesh'ThTenth.TUT_Bow_BoltMesh'
	StandardBoltMesh3rd=skeletalmesh'ThTenth.TUT_Bow_Bolt_3rdMesh'

	// UWBolts
	// ParalyseBoltMesh=lodmesh'UWParaBoltMesh'
	// ParalyseBoltTex=texture'UwParaBoltTex0'
	// TagBoltMesh=lodmesh'UWTagBoltMesh'
	// TagBoltTex=texture'UwTagBoltTex0'
	// FireBoltMesh=lodmesh'UWFireBoltMesh'
	// FireBoltTex=texture'UwFireBoltTex0'
	// BoltMesh=lodmesh'UWBoltMesh'
	// BoltTex=texture'UwBoltTex0'
	
	// Superclasses
	PlayerViewOffset=(X=16.000000,Y=-6.000000,Z=-5.000000)
	PlayerViewMesh=SkeletalMesh'ThTenth.TUT_Bow_BoltMesh';
	PlayerViewScale=0.400000;
	PickupViewMesh=SkeletalMesh'ThTenth.TUT_Bow_Bolt_3rdMesh';
	PickupViewScale=0.600000;
	ThirdPersonMesh=SkeletalMesh'ThTenth.TUT_Bow_Bolt_3rdMesh';
	ThirdPersonScale=0.400000;
	Mesh=SkeletalMesh'ThTenth.TUT_Bow_BoltMesh';
}
