//-----------------------------------------------------------
// ThieveryProMod - ThProWeaponBlackjack by Immortius
// Modified Blackjack with rear arc determined based on
// wielders visibility
//-----------------------------------------------------------
class ThProWeaponBlackjack expands ThWeaponBlackjack;

// Calculates arc to use
static function float CalcArc(ThieveryProPawn tpp)
{
    local float arc, visibility;

    if (tpp == none)
    {
        return 180;
    }

    // Hard coded version of Thievery Mutator's CalculateCurrentVisibility to prevent cheating.
    visibility = tpp.ScaleGlow*0.650000*5.000000;
    if (visibility < 0.1)
    {
        arc = 180;
    }
    else if (visibility < 0.45)
    {
        arc = 170;
    }
    else if (visibility < 0.82)
    {
        arc = 155;
    }
    else
    {
        arc = 130;
    }

    return arc;
}

simulated function CheckAlongSword1(float position) {
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X, Y, Z;
	local actor Other;
	local float angle, dotproduct;
	local rotator rang;
	local bool bAboveVictim, bBehindVictim;
	local float TimeStamp;

	if (Owner.IsA('PlayerPawn')) TimeStamp=PlayerPawn(Owner).CurrentTimeStamp; else TimeStamp=0;

	rang=rot(0,0,0);
	rang.pitch+=35000; // drops the angle back x ish degrees from right hand side of view
	rang.pitch-=30384*position; // assume a 90+ degree swing


	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation, X, Y, Z);
	StartTrace = Owner.Location + CalcDrawOffset() + FireOffset2.Y * Y + FireOffset2.Z * Z + FireOffset2.X * X;
	EndTrace = StartTrace + (((MeleeRange+abs(0.5-position)*(MeleeRange/2.0)) * vector(rang)) >> Pawn(Owner).ViewRotation);
	Other = Pawn(Owner).TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

	// draw the trace in the air
	if (class'ThieveryConfigClient'.default.DebugWeapons) {
		if (Other==none)
			HightLightVector(StartTrace,EndTrace);
		else
			HightLightVector(StartTrace,HitLocation);
	}

	PunchDamage=0;
	if (Other==none) return;

	ThProcessTraceHit(Other, HitLocation, HitNormal, vector(pawn(owner).viewrotation), Y, Z, PunchDamage);

	if (Other.IsA('Pawn')) {
		dotproduct=(Normal((Owner.Location-Other.Location) * vect(1,1,0)))
			 dot
			Normal(vector(Other.Rotation) * vect(1,1,0)); // how near the front the attack is

		bAboveVictim=(HitLocation.Z>Other.Location.Z);
		bBehindVictim=(dotproduct < -cos(PI * CalcArc(ThieveryProPawn(Owner)) / 360));
		ServerProcessPawnHit(Pawn(Other), PunchDamage, bAboveVictim, bBehindVictim, TimeStamp);
	} else {
		ServerProcessTraceHit(Other, HitLocation, PunchDamage, TimeStamp);
	}
}
simulated function CheckAlongSword2(float position) {
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X, Y, Z;
	local actor Other;
	local float angle, dotproduct;
	local rotator rang;
	local bool bAboveVictim, bBehindVictim;
	local float TimeStamp;

	if (Owner.IsA('PlayerPawn')) TimeStamp=PlayerPawn(Owner).CurrentTimeStamp; else TimeStamp=0;

	rang=rot(0,0,0);
	rang.yaw-=9000; // drops the angle back x ish degrees from right hand side of view
	rang.yaw+=20384*position; // assume a 90+ degree swing
	rang.pitch+=10000; // drops the angle back x ish degrees from right hand side of view
	rang.pitch-=18384*position; // assume a 180ish degree swing

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation, X, Y, Z);
	StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.Y * Y + FireOffset.Z * Z + FireOffset.X * X;
	EndTrace = StartTrace + ((MeleeRange2 * vector(rang)) >> Pawn(Owner).ViewRotation);
	Other = Pawn(Owner).TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

	// draw the trace in the air
	if (class'ThieveryConfigClient'.default.DebugWeapons) {
		if (Other==none)
			HightLightVector(StartTrace,EndTrace);
		else
			HightLightVector(StartTrace,HitLocation);
	}
	if (Other==none) return;

	PunchDamage=1;
	ThProcessTraceHit(Other, HitLocation, HitNormal, vector(pawn(owner).viewrotation), Y, Z, PunchDamage);
	if (Other.IsA('Pawn')) {
		dotproduct=(Normal((Owner.Location-Other.Location) * vect(1,1,0)))
			 dot
			Normal(vector(Other.Rotation) * vect(1,1,0)); // how near the front the attack is

		bAboveVictim=(HitLocation.Z>Other.Location.Z);
		bBehindVictim=(dotproduct < -cos(PI * CalcArc(ThieveryProPawn(Owner)) / 360));
		ServerProcessPawnHit(Pawn(Other), PunchDamage, bAboveVictim, bBehindVictim, TimeStamp);
	} else {
		ServerProcessTraceHit(Other, HitLocation, PunchDamage, TimeStamp);
	}
}

DefaultProperties
{

}