//-----------------------------------------------------------
//
//-----------------------------------------------------------
class ThProWeaponBow expands ThWeaponBow;

state ChangeArrow {
	simulated function BeginState() {
		//log("Entered Changing Arrow");
		if (Role<ROLE_Authority) ServerGotoChangeArrow();
		PlayAnim('Down');
		bCanClientFire=false;
	}
}

state ServerChangeArrow {
	function Fire(float F) { }
	function BeginState() {
		//log("ServerChangearrow");
	}
	function EndState() {
		//log("leaving ServerChangeArrow");
	}
	function ServerFireArrow(float Charge) {}
}

function ServerFireArrow(float Charge) {
	local Projectile p;
	local rotator r;

	if (AmmoType.AmmoAmount<=0) {
		PlayerPawn(owner).SwitchWeapon(1);
		return;
	}

	Charge*=1;
	CurrentChargeTime=Charge;
	if (!ThieveryAmmo(AmmoType).default.ProjectileClass.default.bQuietBow)
	{
	   PlayOwnedSound(FireSound, SLOT_Misc, 1.7);
	}

	p=ProjectileFire(ThieveryAmmo(AmmoType).default.ProjectileClass, ThieveryAmmo(AmmoType).default.ProjectileClass.default.Speed*((Charge/0.5)+0.5), false);

	// some experimental stuff to play with changing the arrow's arc
	if (ExperimentSpeed!=0) {
		p.Velocity=ExperimentSpeed*vector(p.rotation)*((Charge/0.5)+0.5);
		p.Acceleration=ExperimentAccel;
	} else {
		// normal velocity thing
		p.Velocity=ThieveryAmmo(AmmoType).default.ProjectileClass.default.Speed*vector(p.rotation)*((Charge/0.5)+0.5);
	}

	AmmoType.AmmoAmount--;	// lower ammo
	if (AmmoType.AmmoAmount<1) {
		PlayerPawn(owner).SwitchWeapon(1);
	}
	r=p.Rotation; r.Roll=16384; p.SetRotation(r); // rotate arrow 90 degrees
	if (!IsInState('DownWeapon')) GoToState('FireBlast');
}

function Projectile ProjectileFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn)
{
	local Vector Start, X,Y,Z, LeanVector, HitLocation, HitNormal;
	local PlayerPawn PlayerOwner;
	local rotator rotSide;

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	//Start = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z;
	Start = Owner.Location + CalcArrowStart();
	AdjustedAim = pawn(owner).AdjustAim(ProjSpeed, Start, AimError, True, bWarn);

	PlayerOwner = PlayerPawn(Owner);

	if (PlayerOwner.IsA('ThieveryPPawn') && class<ThieveryProjectile>(ProjClass).default.bCountsTowardsRangedStats) {
		ThieveryPPawn(PlayerOwner).Stats.NumberOfRangedShots++;
	}

	if (PlayerOwner.IsA('ThieveryPPawn') && (!class<ThieveryProjectile>(projClass).default.bQuietBow || projClass == class'ThProjectileWaterArrow'))
    {
        ThieveryPPawn(PlayerOwner).ClearInvis();
    }
	//log("Fired an arrow with owner:"$Owner);

	// stop firing through walls
	if (Trace(HitLocation, HitNormal, Start, PlayerOwner.Location, false)!=none) {
		Start=HitLocation;
	}

	return (Spawn(ProjClass,Owner,, Start,AdjustedAim));
}

DefaultProperties
{

}