//-----------------------------------------------------------
// ThieveryProMod - ThieveryProModSettings by Immortius
// Configuration class
//-----------------------------------------------------------
class ThieveryProModSettings expands Info config(ThieveryProMod);

// Should there be a period of time before frob wakeup can be used?
var globalconfig bool bUseMinFrobWakeupTime;
// How long before frob wakeup kicks in?
var globalconfig float MinFrobWakeupTime;
// Are players allowed to toggle behind view (besides spectators)?
var globalconfig bool bAllowBehindView;

// Multiplier for rear broadhead hits
var globalconfig float broadheadRearHitDamageMultiplier;
// Size (in degrees) of the guard rear arc for broadheads
var globalconfig float broadheadRearArcSize;

// Enables the new pro sound system
var globalconfig bool bUseProModSoundSystem;
// Sets the lockpick sound radius
var globalconfig float lockpickSoundRadius;
// Is crouched and creep movement silent for thieves
var globalconfig bool bUseSilentCreepMovement;
// Should resupply times increase with each human guard player?
var globalconfig bool bIncreaseSupplyChestRespawnTimeWithPlayerCount;
// Use Crack immunity giving breath potions
var globalconfig bool bBreathPotionsGiveCrackImmunity;
var globalconfig int breathPotionCost;
var globalconfig int breathPotionItemLimit;

// Use new flash calculation and radius?
var globalconfig bool bUseNewFlashCalculation;
var globalconfig float flashRadius;
var globalconfig float maxFlashTime;
var globalconfig float selfFlashModifier;
var globalconfig int flashBombCost;
var globalconfig int flashBombItemLimit;

var globalconfig bool ropeHangMovementFix;
var globalconfig bool bUseNewBJ;

// Catfall potions
var globalconfig bool bSilentCatPotions;
var globalconfig float catfallDuration;
var globalconfig int catfallPotionCost;
var globalconfig int catfallPotionItemLimit;

var globalconfig bool balancedSpeedPots;
var globalconfig bool reduceFlareRadiusWhenThrown;

var globalconfig bool bUseNewFireBolts;

var globalconfig bool bLimitAIInfo;

var globalconfig bool bReplaceDecoyWithRuse;
var globalconfig bool bPreventOverlappingPotionEffects;

var globalconfig int healthPotionCost;
var globalconfig int healthPotionItemLimit;
var globalconfig bool bSilentInvisPotions;
var globalconfig int invisPotionCost;
var globalconfig int invisPotionItemLimit;
var globalconfig int speedPotionCost;
var globalconfig int speedPotionItemLimit;

var globalconfig int crackLifespan;

var globalconfig int thiefSwordCost;
var globalconfig int guardSwordCost;

var globalconfig int maceCost;

var globalconfig bool bLimitGuardingAI;
var globalconfig int minGuardingAI;
var globalconfig int maxGuardingAI;
var globalconfig int guardingPenaltyPerPlayer;

DefaultProperties
{
      bAllowBehindView=true
      bUseMinFrobWakeupTime=false
      MinFrobWakeupTime=60
      bUseProModSoundSystem=false
      lockpickSoundRadius=0
      bUseSilentCreepMovement=false
      bIncreaseSupplyChestRespawnTimeWithPlayerCount=false
      bBreathPotionsGiveCrackImmunity=false
      breathPotionCost=50
      breathPotionItemLimit=99
      bUseNewFlashCalculation=false
      flashRadius=700
      maxFlashTime=8
      selfFlashModifier=0.5
      flashBombCost=100
      flashBombItemLimit=3
      broadheadRearArcSize=180
      broadheadRearHitDamageMultiplier=2
      ropeHangMovementFix=false
      bUseNewBJ=false
      bSilentCatPotions=false
      catfallPotionCost=30
      catfallPotionItemLimit=99
      balancedSpeedPots=false
      reduceFlareRadiusWhenThrown=false
      bUseNewFireBolts=false
      catfallDuration=20
      bLimitAIInfo=false
      bReplaceDecoyWithRuse=false
      bPreventOverlappingPotionEffects=false
      healthPotionCost=50
      healthPotionItemLimit=8
      invisPotionCost=100
      invisPotionItemLimit=2
      speedPotionCost=100
      speedPotionItemLimit=2
      crackLifespan=40
      bSilentInvisPotions=false
      guardSwordCost=250
      thiefSwordCost=250
      bLimitGuardingAI=false
      minGuardingAI=1
      maxGuardingAI=5
      guardingPenaltyPerPlayer=1
      maceCost=300

}