//-----------------------------------------------------------
// ThieveryProMod - ThieveryProPawn by Immortius
// Changes:
//   - Slight protection against changing mouse sensitivity
//     while paralysed.
//   - Prevent behind view while scouting orbing
//   - Optionally disable behind view entirely
//   - Alters the radius of lockpicking sounds
//-----------------------------------------------------------
class ThieveryProPawn expands ThieveryPPawnTen;

// Previous behind view value before using scouting orb
var bool prevBehindView;
var bool bAllowBehindView;
var bool bUseProSoundSystem;
var ThProSoundPawn proSoundPawn;
var bool bUseSilentMovement;
var bool bOnCrackImmune;
var float BreathPotionDuration;
var bool bUseNewFlashCalculation;
var int ropeFixCycle;
var bool ropeHangFix;
var bool balancedSpeedPots;
var ThProAIDirectorInfo aiDirector;

replication
{
    reliable if (Role == ROLE_Authority && bNetOwner)
        bAllowBehindView, bUseProSoundSystem, bUseSilentMovement, bOnCrackImmune, bUseNewFlashCalculation, ropeHangFix, balancedSpeedPots;
    unreliable if (Role==ROLE_Authority && bNetOwner)
        BreathPotionDuration;
    reliable if (Role==ROLE_Authority)
   		ClientMakeTeamSpectator;
   	reliable if (Role< ROLE_Authority)
   	    ServerReadyNotify;
}

function ServerReadyNotify() {
    if (ThieveryProTvG(level.game) != none)
    {
        ThieveryProTvG(level.game).PlayerReady(self);
    }
}

exec function ThSwitchWeapon(byte F) {
	local Ammo ammoT;
	// if holding something, only allow weapon 1
	if ((HeldItem!=none) && (F!=1)) {
		if (!ServerThrowHeldItem())
		return;
	}

	if (!bHumanAbilities)		// non-humans can't change weapons
		return;

	if (bUsingScope && F!=1)	// turn off the telescope if you pull out a weapon
		TelescopeOff();

	LastSelectedWeapon=F;

	if (PlayerReplicationInfo.Team==1) {
		// guard
		if (F<=3) {	// normal weapons
			SwitchWeapon(F);
		} else {		// arrows
			if (Weapon.IsA('ThWeaponCrossbow')) {
					ammoT=Weapon.AmmoType;
					if (ThieveryDeathMatchPlus(Level.Game).SetCrossbowProjectile(self, F)) {
						if (Weapon.AmmoType!=ammoT)
                        {
                            ChangeArrow();
                        }
					}
			} else {
				if (ThieveryDeathMatchPlus(Level.Game).SetCrossbowProjectile(self, F)) {
					SwitchWeapon(4);
				}
			}
		}
	} else {
		// thief
		if (F<4) {	// normal weapons
			SwitchWeapon(F);
		} else {		// arrows
			if (Weapon.IsA('ThWeaponBow')) {
				ammoT=Weapon.AmmoType;
				if (ThieveryDeathMatchPlus(Level.Game).SetBowProjectile(self, F)) {
					if (Weapon.AmmoType!=ammoT)
                    {
                        if (level.NetMode == NM_DedicatedServer) {
                            Weapon.GotoState('ServerChangeArrow');
                        }
                        ChangeArrow();
                    }
				}
			} else {
				if (ThieveryDeathMatchPlus(Level.Game).SetBowProjectile(self, F)) {
					SwitchWeapon(4);
				}
			}
		}
	}
}

function BotOrderOption(int OrderNum) {
    aiDirector.OrderBot(self, OrderingBot, orderNum);
}

function BotPatrolOrderOption(int PatrolNum) {
    aiDirector.OrderBotPatrol(self, OrderingBot, patrolNum);
}

simulated function PreBeginPlay() {
    if (proSoundPawn==none && bUseProSoundSystem) {
		proSoundPawn=spawn(class'ThProSoundPawn');
	}

	Super.PreBeginPlay();
}

simulated function PostBeginPlay()
{
    Super.PostBeginPlay();
    if ( Level.NetMode != NM_Client && class'ThieveryProModSettings'.default.bLimitAIInfo)
	{
		ScoringType = class'ThProScoreBoard';
	}
}

// function for selecting and using an item in your inventory immediately
// Overriden to use existing bind for pro pickups
exec function ThUsePickup(class<Pickup> C) {
	if (HeldItem!=none)
		return;

    if (C == class'ThPickupFlashBomb')
    {
        super.ThUsePickup(class'ThProFlashBomb');
    }
    else if (C == class'ThPickupPotionBreath')
    {
        super.ThUsePickup(class'ThProPotionBreath');
    }
    else if (C == class'ThPickupPotionCatfall')
    {
        super.ThUsePickup(class'ThProPotionCatfall');
    }
    else if (C == class'ThPickupPotionHealth')
    {
        super.ThUsePickup(class'ThProPotionHealth');
    }
    else if (C == class'ThPickupPotionInvisibility')
    {
        super.ThUsePickup(class'ThProPotionInvisibility');
    }
    else if (C == class'ThPickupPotionSpeed')
    {
        super.ThUsePickup(class'ThProPotionSpeed');
    }
    else
    {
        super.ThUsePickup(C);
    }
}

//*****************************************
// Mario Fix
//*****************************************

/*
function LandOnPlayer() {
	local ThieveryPPawn tpp;
	local TBaseBot tb;
	local vector HitLocation;

	tpp=ThieveryPPawn(Base);
	tb=TBaseBot(Base);
	if (tpp!=none && tpp.PlayerReplicationInfo!=none && CanMario(tpp.PlayerReplicationInfo.Team,PlayerReplicationInfo.Team)) {
		if (tpp.PlayerReplicationInfo.Team==255) {	// crush rats
			tpp.TakeDamage(20, self, HitLocation, vect(0,0,0), 'Crushed');						// hits them there with KO damage
			return;
		}
		// landed on a player on the other team
		if (Velocity.Z<-450) {
			// KO them
			HitLocation=ThieveryDeathMatchPlus(Level.Game).ConvertToLocation(tpp, true, true);	// grabs a spot behind their head
			if (PlayerReplicationInfo.Team==0)	// thieves do KO damage
				tpp.TakeDamage(200, self, HitLocation, vect(0,0,0), 'KnockedOutHeavy');						// hits them there with KO damage
			else if (PlayerReplicationInfo.Team==1)		// guards do pain
				tpp.TakeDamage(100, self, HitLocation, vect(0,0,0), 'Crushed');						// hits them there with KO damage
		}
	} else if (tb!=none && tb.PlayerReplicationInfo!=none && tb.PlayerReplicationInfo.Team!=PlayerReplicationInfo.Team) {
		// landed on a bot on the other team
		if (Velocity.Z<-450) {
			// KO them
			HitLocation=ThieveryDeathMatchPlus(Level.Game).ConvertToLocation(tb, true, true);	// grabs a spot behind their head
			if (PlayerReplicationInfo.Team==0)	// thieves do KO damage
				tb.TakeDamage(200, self, HitLocation, vect(0,0,0), 'KnockedOutHeavy');						// hits them there with KO damage
			else if (PlayerReplicationInfo.Team==1)		// guards do pain
				tb.TakeDamage(100, self, HitLocation, vect(0,0,0), 'Crushed');						// hits them there with crush damage
		}
	}
}
*/

//*****************************************
// Sound Handling
//****************************************/
simulated event ClientHearSound (actor Actor, int Id, sound S, vector SoundLocation, vector Parameters) {
	local float distance;
	local bool bSpecialSimpleSound;
	local string soundname;

    // Pass through the end push sound, as it is needed to end the looped push sound.
    if (S == Sound'UnrealShare.General.Endpush')
    {
        Parameters.x = 0.01;
        super(Pawn).ClientHearSound(actor, id, S, SoundLocation, Parameters);
        return;
    }

    if (!bUseProSoundSystem)
    {
        super.ClientHearSound(actor, id, s, SoundLocation, Parameters);
        return;
    }

	if (proSoundPawn==none) proSoundPawn=spawn(class'ThProSoundPawn');

	if (S!=none) {
		// certain sound effects bypass the pathing method
		soundname=string(S.name);
		if (Right(soundname, 6)~="simple") bSpecialSimpleSound=true;

		if ((!bSimpleSound) && (!bSpecialSimpleSound)) {  // if not simplesound, path the sound to lessen the volume if things in the way
		    if (Parameters.Y == 0)
		    {
		        Parameters.Y = 2048;
		    }
			if (SoundPawn!=none)
            {
				Parameters.X=ProSoundPawn.GetProNewVolume(SoundLocation, self, Parameters.X, Parameters.Y);
			}
		}
	}
	if (Parameters.X > 0)
	{
	   super(TMale1).ClientHearSound(Actor, Id, S, SoundLocation, Parameters);
	}
}

// Alter Pick Sound volume
function ServerSinglePick(Actor d, float deltatime)
{
    local float oldTransientSoundRadius;
    local ThDoor door;
    local ThObjectFootLocker locker;
    local ThObjectMine mine;

    // Guards can be noisy.
    if (PlayerReplicationInfo.Team==1)
    {
        super.ServerSinglePick(d, deltaTime);
        return;
    }

    door = ThDoor(d);
    if (door == none)
    {
        locker = ThObjectFootLocker(d);
        if (locker == none)
        {
            mine = ThObjectMine(d);
        }
    }

    oldTransientSoundRadius = d.TransientSoundRadius;
    if (door != none)
    {
        if (door.lockPickCount + 1 < door.lockDifficulty)
        {
            d.TransientSoundRadius = class'ThieveryProModSettings'.default.lockpickSoundRadius;
        }
        door.singlePick(self, deltatime);
    }
    else if (locker != none)
    {
        if (locker.lockPickCount + 1 < locker.lockDifficulty)
        {
            d.TransientSoundRadius = class'ThieveryProModSettings'.default.lockpickSoundRadius;
        }
        locker.singlePick(self, deltatime);
    }
    else if (mine != none)
    {
        // No sound to avoid, nice
        d.TransientSoundRadius = class'ThieveryProModSettings'.default.lockpickSoundRadius;
        mine.singlePick(self, deltatime);
    }
    d.TransientSoundRadius = oldTransientSoundRadius;
}

function ServerFootStepping()
{
    FootSteppingCommon(false);
}

simulated function FootStepping()
{
 	if (Level.NetMode==NM_ListenServer)
    {
	    FootSteppingCommon(false);
    }
    else
    {
        FootSteppingCommon(true);
    }
}

simulated function PlayFootStep()
{
    if (GameReplicationInfo == none)
        return;

    super.PlayFootStep();
}

// Footsteps
simulated function FootSteppingCommon(bool owned)
{
    local sound step;
    local texture tex;
    local float volume;
    local float TMakeNoiseValue;
    local TSTFootPrint placedfootprint;
    local bool bSilentMove;
    local bool bCreeping;

    if (!bHumanAbilities) return;	// non-humans don't have footsteps

    DistanceSinceLastFootstep=0;
    volume=(VSize(Velocity)/((MSpeed/100.0)*default.GroundSpeed));
    bCreeping = volume < 0.26;
    TMakeNoiseValue=volume;
    TVolume=volume; // For debugging

    tex = DetermineFootstepTexture();
    if (tex != none)
        WalkTexture = tex;

    if (( FootRegion.Zone.bWaterZone ) || (string(tex)~="THPUDDLES.BRICK_WALL_RIPPLE"))
    {
        PlayWaterStep(volume, owned);
    }
    else
    {
        step = DetermineStepSound(WalkTexture, TMakeNoiseValue);
        if (step == none)
        {
            step = sound(DynamicLoadObject("ThiefFootsteps.FT_Rock.THRockStep1", class'Sound'));;   // in case the step assign has gone wrong somewhere, default to this sound
        }

        CheckInhibitFootsteps();
        bSilentMove = bUseSilentMovement && PlayerReplicationInfo.Team == 0 && bCreeping;
        if (InhibitFootsteps < 1 && !bOnCatfall && !bSilentMove)
        {
            if (Level.NetMode != NM_Client)
            {
                TMakeNoise(TMakeNoiseValue*TMakeNoiseScale);
            }
            else if (!ThieveryGameReplicationInfo(GameReplicationInfo).bServerSimulateFootsteps)
            {
                ServerFootStepping();
            }

         	while (TMakeNoiseValue > 0)
            {
                 if (owned)
                 {
                     PlaySound(step, SLOT_None, TMakeNoiseValue*FootstepScaleFirstPerson, false);
                 }
                 else
                 {
     		         PlayOwnedSound(step, SLOT_None, TMakeNoiseValue, false);
     		     }
     		     TMakeNoiseValue -= 1;
     	    }
        }

        if (wetPrints > 0) {
            //log("wet print");
            wetPrints--;
            if (Level.NetMode != NM_Client)
            {
                DripWater();
            }
            PlayOwnedSound(Sound'UnrealShare.Generic.LSplash', SLOT_None, wetprints*0.25, false, 500.0, 1.0);
        }

        if (bPlayerInColdArea)
        {
            placedfootprint = Footprint();
        }

        if (nBloodyFootprints>0)
        {
     	   placedfootprint = BloodyFootprint(FMin(float(nBloodyFootprints)/10.0, 1.0));
     	   nBloodyFootprints--;
     	}

        // Chain our footprints together
        if(placedfootprint != None) {
            if(LastFootPrint != None) {
                LastFootPrint.NextFootPrint = placedfootprint;
                placedfootprint.PrevFootPrint = LastFootPrint;
            }
            LastFootPrint = placedfootprint;
        } else {
            // Break the current chain (if any)
            LastFootPrint = None;
        }
    }

}

simulated function Sound DetermineStepSound(Texture tex, out float TMakeNoiseValue)
{
    local float decision;
    local string stringstep, TextureSoundString;

    if (tex == none)
    {
        TextureSoundString="ThiefFootsteps.FT_Rock.THRockStep1";
    }
    else
    {
        if (tex.FootstepSound==none)
        {
         	tex.FootstepSound=sound(DynamicLoadObject("ThiefFootsteps.FT_Rock.THRockStep1", class'Sound'));
        }

        // grab all but the last digit of the sound
        TextureSoundString=string(tex.FootstepSound);
    }
    stringstep=Left(TextureSoundString, Len(TextureSoundString)-1);
    bPlayerInColdArea = (stringstep~="ThiefFootsteps.FT_Snow.Thftsnow");

    // adjust bot alertness level depending on texture
    TMakeNoiseValue*=FootstepScale;
    if (stringstep~="ThiefFootsteps.FT_Metal.THMetalStep") TMakeNoiseValue*=FootstepScaleMetal;
    if (stringstep~="ThiefFootsteps.FT_Tile.THTileStep") TMakeNoiseValue*=FootstepScaleTile;
    if (stringstep~="ThiefFootsteps.FT_Rock.THRockStep") TMakeNoiseValue*=FootstepScaleRock;
    if (stringstep~="ThiefFootsteps.FT_Wood.THWoodStep") TMakeNoiseValue*=FootstepScaleWood;
    if (stringstep~="ThiefFootsteps.FT_Dirt.THDirtStep") TMakeNoiseValue*=FootstepScaleDirt;
    if (stringstep~="ThiefFootsteps.FT_Carpet.THCarpetStep") TMakeNoiseValue*=FootStepScaleCarpet;
    if (stringstep~="ThiefFootsteps.FT_Gravel.THGravelStep") TMakeNoiseValue*=FootstepScaleGravel;
    if (stringstep~="ThiefFootsteps.FT_Snow.THftsnow") TMakeNoiseValue*=FootStepScaleSnow;

    //if (stringstep~="ThEdsTex.Deco.brick_wall_puddle") wetPrints=3+Rand(3);
    // add on a digit 1-4 based on the random number to make random footstep noises
    decision=FRand();
    if (decision<0.25)
        stringstep=stringstep$"1";
    else if (decision<0.5)
        stringstep=stringstep$"2";
    else if (decision<0.75)
        stringstep=stringstep$"3";
    else
        stringstep=stringstep$"4";
    if ((PlayerClass>=32) && (PlayerClass<=63))
    { // guard
        stringstep="GuardFootsteps"$mid(stringstep,14);
    }
    return sound(DynamicLoadObject(stringstep, class'Sound'));
}

simulated function texture DetermineFootstepTexture()
{
    local float distance, f;
    local vector ChosenLocation, tempVector;
    local rotator tempRot;

    ChosenLocation=Location;
	distance=FloorDistance(ChosenLocation);
	if (distance>30) { // chosen footstep is too far away, try some more
		f=FloorDistance(Location); if (f<distance) { distance=f; ChosenLocation=Location; } // log("[tpp:"$self$"] FootStepping() Smaller!"$f);
		f=FloorDistance(Location-tempVector); if (f<distance) { distance=f; ChosenLocation=Location-tempVector; } // log("[tpp:"$self$"] FootStepping() Smaller!"$f);
		tempRot=Rotation; tempRot.Pitch=0; tempRot.Roll=0;
		tempVector=vector(tempRot)*CollisionRadius;
		f=FloorDistance(Location-tempVector); if (f<distance) { distance=f; ChosenLocation=Location-tempVector; } // log("[tpp:"$self$"] FootStepping() Smaller!"$f);
		f=FloorDistance(Location+tempVector); if (f<distance) { distance=f; ChosenLocation=Location+tempVector; } // log("[tpp:"$self$"] FootStepping() Smaller!"$f);
	}
	// if floor is miles away, don't bother footstepping
	if (distance>50) return none;
	return FootStepAt(ChosenLocation);
}

simulated function PlayWaterStep(float volume, bool owned)
{
    if (PlayerReplicationInfo.Team!=255)
    {
        wetPrints=3+Rand(3);
    }
    if ( !bIsWalking )
    {
        PlayFootStepSound(WaterStep, owned, SLOT_Interact, volume, false, 1000, 1);
    }
    else
    {
        PlayFootStepSound(WaterStep, owned, SLOT_Interact, 0.5*volume, false, 1000, 1);
    }
    if (Level.NetMode==NM_Client && !ThieveryGameReplicationInfo(GameReplicationInfo).bServerSimulateFootsteps)
    {
      	ServerFootStepping(); // play noises and suchlike in the server
    }
    else
    {
        TMakeNoise(volume*FootstepScale*TMakeNoiseScale);
    }
}

simulated function PlayFootStepSound(sound	Sound,
    bool owned,
	optional ESoundSlot Slot,
	optional float		Volume,
	optional bool		bNoOverride,
	optional float		Radius,
	optional float		Pitch)
{
    if (!owned)
    {
         PlayOwnedSound(sound, slot, volume, bNoOverride, Radius, Pitch);
    }
    else
    {
        PlaySound(sound, slot, volume, bNoOverride, Radius, Pitch);
    }
}

// Changed min velocity to cause noise to 210.
function PlayLanded(float impactVel) {
     local string stringjump,TextureSoundString;  //  DALAI
     local sound TextureJumpSound;                //  misc vars for working out the landing sound
     local float TMakeNoiseValue;
     local bool snow;
     local vector StartTrace, EndTrace;
     local float originalImpactVel, jumpSoundVolume;
     local TSTFootprint placedfootprint;

     SimpleMakeSafe();
     originalImpactVel=impactVel;

     jumpSoundVolume=FMax(Abs(originalImpactVel)/650,0);
     if (bIsCrouching) jumpSoundVolume*=0.4;
     if (abs(originalImpactVel) < 210) jumpSoundVolume=0;	// don't make a noise if the drop is small
     TMakeNoiseValue=jumpSoundVolume;

     impactVel = impactVel/JumpZ;
     impactVel = 0.1 * impactVel * impactVel;
     if (bIsCrouching)
     		BaseEyeHeight = 0;
   	 else
     		BaseEyeHeight = DefaultBaseEyeHeight;

     if (!bHumanAbilities) {	// if not human, don't play landing noises, just alter the anims
     	if ( (impactVel > 0.06) || (GetAnimGroup(AnimSequence) == 'Jumping') || (GetAnimGroup(AnimSequence) == 'Ducking') )
	{
          if ( (Weapon == None) || (Weapon.Mass < 20) )
               TweenAnim('LandSMFR', 0.12);
          else
               TweenAnim('LandLGFR', 0.12);
	}
	else if ( !IsAnimating() )
	{
          if ( GetAnimGroup(AnimSequence) == 'TakeHit' )
          {
               SetPhysics(PHYS_Walking);
               AnimEnd();
          }
          else
          {
               if ( (Weapon == None) || (Weapon.Mass < 20) )
                    TweenAnim('LandSMFR', 0.12);
               else
                    TweenAnim('LandLGFR', 0.12);
          }
	}
	return;
     }

     if ( !FootRegion.Zone.bWaterZone && (impactVel > 0.01) ) {
          // grab latest texture
          StartTrace=Location; StartTrace.Z-=(CollisionHeight-10);
	  EndTrace=Location; EndTrace.Z-=(CollisionHeight+30);
	  WalkTexture = Tracer.TextureTrace(EndTrace, StartTrace);

          TextureJumpSound=sound(DynamicLoadObject("ThiefFootsteps.FT_Rock.THRockJump", class'Sound'));
          if (WalkTexture!=none) {
          	if (WalkTexture.FootstepSound!=none) {
          		TextureSoundString=string(WalkTexture.FootstepSound);               // grab the footstep sound
          		stringjump=Left(TextureSoundString, Len(TextureSoundString)-5);      // chop the end off

          		// check if landing on snow
          		if (stringjump~="ThiefFootsteps.FT_Snow.Thft") snow=true; else snow=false;

          		// tmakenoise stuffs
          		TMakeNoiseValue*=FootstepScale;
               		if (stringjump~="ThiefFootsteps.FT_Metal.THMetalStep") TMakeNoiseValue*=FootstepScaleMetal;
               		if (stringjump~="ThiefFootsteps.FT_Tile.THTileStep") TMakeNoiseValue*=FootstepScaleTile;
               		if (stringjump~="ThiefFootsteps.FT_Rock.THRockStep") TMakeNoiseValue*=FootstepScaleRock;
               		if (stringjump~="ThiefFootsteps.FT_Wood.THWoodStep") TMakeNoiseValue*=FootstepScaleWood;
               		if (stringjump~="ThiefFootsteps.FT_Dirt.THDirtStep") TMakeNoiseValue*=FootstepScaleDirt;
               		if (stringjump~="ThiefFootsteps.FT_Carpet.THCarpetStep") TMakeNoiseValue*=FootStepScaleCarpet;
               		if (stringjump~="ThiefFootsteps.FT_Gravel.THGravelStep") TMakeNoiseValue*=FootstepScaleGravel;
               		if (stringjump~="ThiefFootsteps.FT_Snow.THft") {
               			TMakeNoiseValue*=FootStepScaleSnow;
               			//log("snow string prejump is: "$stringjump);
               			stringjump=stringjump$"snow";
               		}


               		stringjump=stringjump$"Jump";                              // add the word "jump" to end
               		if ((PlayerClass>=32) && (PlayerClass<=63)) { // guard
               			stringjump="GuardFootsteps"$mid(stringjump,14);
              			}
               		TextureJumpSound=sound(DynamicLoadObject(stringjump, class'Sound'));     // load the sound
               	}
          }
          //log("Original impact velocity:"$originalImpactVel$" impactVel:"$impactVel$" vol:"$jumpSoundVolume);

          jumpSoundVolume*=JumpNoiseScale/2.0;
          if (TextureJumpSound==none) {                              // play it
               //PlayOwnedSound(Land, SLOT_Talk, FClamp(4 * impactVel,0.5,5), true,1000, 1.0);
               if (InhibitFootsteps<1) {
         	      	while (jumpSoundVolume>0) {
     								PlayOwnedSound(sound(DynamicLoadObject("ThiefFootsteps.FT_Rock.THRockJump", class'Sound')), SLOT_None, jumpSoundVolume, true,1000, 1.0);
     								jumpSoundVolume-=1.0;
     							}
               	} else {
               		CheckInhibitFootsteps();
               	}
          } else {
               if (InhibitFootsteps<1) {
               		while (jumpSoundVolume>0) {
     								PlayOwnedSound(TextureJumpSound, SLOT_None, jumpSoundVolume, true,1000, 1.0);
     								jumpSoundVolume-=1.0;
     							}
               } else {
               	CheckInhibitFootsteps();
              }
          }
          //log("[tpp:"$self$"] PlayLanded() TMakeNoiseValue:"$TMakeNoiseValue$" stringjump:"$stringjump);
          if (InhibitFootsteps<1) TMakeNoise(TMakeNoiseValue*TMakeNoiseScale*JumpNoiseScale);
					else CheckInhibitFootsteps();
          // snow footprints
     	  if (snow) {
          	placedfootprint = Footprint();
          	bPlayerInColdArea=true;
     	  } else {
     	  		bPlayerInColdArea=false;
     	  }
     } else {
          //log("[tpp:"$self$"] LANDING:not play sound water:"$FootRegion.Zone.bWaterZone$" impactvel:"$impactVel);
     }
     if ( (impactVel > 0.06) || (GetAnimGroup(AnimSequence) == 'Jumping') || (GetAnimGroup(AnimSequence) == 'Ducking') )
     {
          if ( (Weapon == None) || (Weapon.Mass < 20) )
               TweenAnim('LandSMFR', 0.12);
          else
               TweenAnim('LandLGFR', 0.12);
     }
     else if ( !IsAnimating() )
     {
          if ( GetAnimGroup(AnimSequence) == 'TakeHit' )
          {
               SetPhysics(PHYS_Walking);
               AnimEnd();
          }
          else
          {
               if ( (Weapon == None) || (Weapon.Mass < 20) )
                    TweenAnim('LandSMFR', 0.12);
               else
                    TweenAnim('LandLGFR', 0.12);
          }
     }
  // Chain our footprints together
  if(placedfootprint != None) {
   if(LastFootPrint != None) {
    LastFootPrint.NextFootPrint = placedfootprint;
    placedfootprint.PrevFootPrint = LastFootPrint;
   }
   LastFootPrint = placedfootprint;
  } else {
   // Break the current chain (if any)
   LastFootPrint = None;
  }
}

//********************************
// Breath Pot handling
//*******************************/

function ResetPlayerEffects()
{
    BreathPotionDuration=0;
    super.ResetPlayerEffects();
}

function GiveCrackArrowEffect()
{
    if (!bOnCrackImmune)
    {
	    Spawn(class'ThProCrackEffect', self,,Location, Rotation);
	    if (class'ThieveryConfigClient'.default.bCoverCrack)
	    {
		    setClientBlindness(ExperimentCrackCover);
	    }
	}
}

//*******************************
// Spawn Wave support
//******************************/

function ClientMakeTeamSpectator()
{
    GotoState('EnterTeamSpectating');
}

simulated function MakeTeamSpectator()
{
    GotoState('EnterTeamSpectating');
}

state EnterTeamSpectating
{
    function BeginState()
    {
        if (PlayerReplicationInfo == none) log ("No PRI Yet");
	//log("[tpp:"$self$"] MakeRat()");
	bHidden=true;
	PlayerClass=74;	// rat
	if (ThieveryPlayerReplicationInfo(PlayerReplicationInfo)!=none) ThieveryPlayerReplicationInfo(PlayerReplicationInfo).PlayerClass=PlayerClass;
	PlayerReplicationInfo.bIsSpectator=true;
	ThSetMesh();
	MSpeed=75;
	Health=0;
	JumpRecoverTime=0.5;
	GroundSpeed = default.GroundSpeed * (MSpeed / 100);
	WaterSpeed = default.WaterSpeed * (MSpeed / 100);
	AccelRate = default.AccelRate * (MSpeed / 100);
	LadderSpeed=170;
	AirSpeed = 400;	// make rats have some air control for easy step climbing
	AirControl=100;
	MantleSpeed=140.0;
	MaxMantleHeight=64.0;
	EyeHeight=10;
	BaseEyeHeight=10;
	MaxHealth=1;
	DefaultBaseEyeHeight=10;
	DefaultEyeHeight=10;
	//default.Health=10;
	//default.BaseEyeHeight=10;
	//default.EyeHeight=10;
	BobScale=0;	// breathing
	SetCollisionSize(10, 3);
	DefaultCollisionHeight=3;
	TargetCollisionHeight=3;
	bIsCrouching=false;
	PrePivot=default.PrePivot;
	MaxStepHeight=25;
	JumpZ=275;
	FOVAngle=120;
	DesiredFOV=120;
	bHumanAbilities=false;
	BobRangeScale=0.6;
	BobSpeedScale=2.0;
	BobXMax=3.000000;
	SelectedItem=none;
	HeldItem=none;
	Mass=50.0;
	Buoyancy=49;
	Deaths[0]=none;
	Deaths[1]=none;
	Deaths[2]=none;
	Deaths[3]=none;
	Deaths[4]=none;
	Deaths[5]=none;
	Die=none;
	Die2=none;
	Die3=none;
	Die4=none;
	drown=none;
	breathagain=none;
	HitSound1=none;
	HitSound2=none;
	HitSound3=none;
	HitSound4=none;
	Die=none;
	Die2=none;
	Die3=none;
	Die4=none;
	GaspSound=none;
	UWHit1=none;
	UWHit2=none;
	ThCarcassType=Class'ThieveryMod.ThObjectCarcassRat';
	Weapon=Weapon(FindInventoryType(class'ThWeaponRatClaws'));
	if (Weapon==none && Role==ROLE_Authority) {
		ThieveryDeathMatchPlus(Level.Game).AddWeaponToInventory(self, "ThieveryMod.ThWeaponRatClaws");
		Weapon=Weapon(FindInventoryType(class'ThWeaponRatClaws'));
	}
    ClientShowObjectives(0);
    bShowObjectives=0;
    TeamFollowCam();
    }


}

function MakeThief() {
    bBehindView=false;
    super.MakeThief();
}

state PlayerWaiting {
    function EndState()
    {
        if (Role==ROLE_Authority)
        {
			CountBuyZones();
			ClientShowObjectives(0);
			bShowObjectives=0;
			ThSetMesh();
			if (PlayerReplicationInfo.Team!=255 && !PlayerReplicationInfo.bIsSpectator)
            {
				PlayerReplicationInfo.bIsSpectator = false;
				PlayerReplicationInfo.bWaitingPlayer = false;
				if (PlayerReplicationInfo.Team==0)
                {
					ClientMakeThief();

					// spawn protection
					if (Level.NetMode!=NM_Standalone)
                    {
						bOnInvisibility=true;
						InvisibilityPotionDuration=10;
						ClientGiveInvisibility(10);
					}
				}
				else if (PlayerReplicationInfo.Team==1) ClientMakeGuard();
			}
            else if (PlayerReplicationInfo.Team==255)
            {
				ClientMakeRat();		// needed to make sure the eyeheight and such is set properly when the player is forced into rat after being a reconnecting lamer-type ;)
				ClientMessage("Hunt down other rats!  Press frob to switch to chase-cam.");
				//RatHuntMessage();
			}

			ThieveryPlayerReplicationInfo(PlayerReplicationInfo).bReadyToPlay=true;
			if (ThieveryPlayerReplicationInfo(PlayerReplicationInfo).bHasSupplyChest)
            {
				if (FindInventoryType(class'ThPickupSupplyChest')==none)
                {
					ThieveryDeathMatchPlus(Level.Game).AddPickupToInventory(self, "ThieveryMod.ThPickupSupplyChest", 1);
				}
			}
		} //else {
			//DoMake();
		//}
		//bAlwaysRelevant=false;
		bReadyToPlay=true;
	    Blindness=0;
		HeldItem=none;
		SelectedItem=none;
		ClientSelectedItem=none;
		bHidden=false;
		SetPhysics(PHYS_Walking);
		nBloodyFootprints=0;

		//1.3 making rats solid
		if (PlayerReplicationInfo.Team!=255) {
			//log("Making you solid");
		    FovAngle=90;
		    DesiredFOV=90;
		}
		SetCollision(true,true,true);
		//} else {
			//log("Making sure you are not solid");
			//SetCollision(false, false, false);
		//}
		bScatteredLoot=false;

		ThieveryDeathMatchPlus(Level.Game).LeftWaiting(self);
    }

}

function int GetHighestTeamPlayerID() {
	local Pawn P;
	local int i, highest;
	local byte team;

	team = PlayerReplicationInfo.Team;

	for (P=Level.PawnList;P!=none;P=P.NextPawn) {
		if (P.PlayerReplicationInfo!=none && P.PlayerReplicationInfo.Team == team && P.PlayerReplicationInfo.PlayerID>highest) {
			highest=P.PlayerReplicationInfo.PlayerID;
		}
		i++;
		if (i>256) return 64;
	}

	return highest;
}

function bool TeamFollowPlayerID(int IDNum) {
	local Pawn P;
	local int i;
	local byte team;

	team = PlayerReplicationInfo.Team;

	for (P=Level.PawnList;P!=none;P=P.NextPawn) {
		if (P.PlayerReplicationInfo!=none && P.PlayerReplicationInfo.PlayerID==IDNum) {
			if (P.IsA('ThieveryPPawn') && P.Health>0 && P.PlayerReplicationInfo.Team==team) {
				ViewTarget=P;
				return true;
			} else {
				return false;
			}
		}
		i++;
		if (i>64) return false;
	}

	return false;
}

// cycles the player's view through players
function TeamFollowCam() {
	local int HighestPlayerID, i;

	if (LastFollowCamCommandTime!=0 && Level.TimeSeconds<LastFollowCamCommandTime+1.0) {
		return;
	}

	LastFollowCamCommandTime=Level.TimeSeconds;

	if (Region.Zone.bWaterZone)
		GotoState('PlayerSwimming');
	else
		GotoState('PlayerWalking');

	HighestPlayerID=GetHighestTeamPlayerID();
	while (!TeamFollowPlayerID(FollowCamPlayerID)) {
		FollowCamPlayerID++;

		if (FollowCamPlayerID>HighestPlayerID)
			FollowCamPlayerID=0;

		i++;
		if (i>128) {
			break;
		}
	}

    bBehindView = true;
	FOVAngle=90;
	DesiredFOV=90;
	bHidden=true;
	SetCollision(false, false, false);
	SetPhysics(PHYS_Falling);

	FollowCamPlayerID++;
}

state Dying {
	function EndState()
	{
		super.EndState();
		if (health <= 0 && PlayerReplicationInfo.Team == 0) {
    		bBehindView=true;
		}
	}
}

// clientside 'frob' function, i.e. use something, whether it be something in front of you or selected inventory item
//   checks for action that can be performed clientside, if not will call the frobServer
exec function frob() {
	if ((GetStateName()=='PlayerWalking')
			&& (PlayerReplicationInfo.bIsSpectator)) {
		if (PlayerReplicationInfo.Team==255) {
    		if (Role<ROLE_Authority) {		// check this client isn't spamming the follow button
	      		if (LastFollowCamCommandTime==0 || Level.TimeSeconds>LastFollowCamCommandTime+1.0) {
	       			LastFollowCamCommandTime=Level.TimeSeconds;
	   	       		FollowCam();
			     }
    		 } else {
	       		FollowCam();
		     }
		}
		else
		{
		     if (Role<ROLE_Authority) {		// check this client isn't spamming the follow button
	      		if (LastFollowCamCommandTime==0 || Level.TimeSeconds>LastFollowCamCommandTime+1.0) {
	       			LastFollowCamCommandTime=Level.TimeSeconds;
	   	       		TeamFollowCam();
			     }
    		 } else {
	       		TeamFollowCam();
		     }
		}
		return;
	}

	if (!bHumanAbilities) {
		return;		// only humans can frob stuff
	}
	// frobbing normally
	if (HeldItem!=none && ThDoor(FrobTarget)==none) {
		// throw the item
		if (HeldItem.IsA('ThieveryObject')) {
			FrobThrowItem();
		}

		return;
	}
	//log("[tpp:"$self$"] frob() trying to frob");
	if (TBaseBot(FrobTarget)!=none) {
		if (TBaseBot(FrobTarget).PlayerReplicationInfo!=none) {
			if (TBaseBot(FrobTarget).PlayerReplicationInfo.Team==PlayerReplicationInfo.Team) {
				OrderingBot=TBaseBot(FrobTarget);
				//OrderingBot.frob(self);
				// spawn WRI
				//Spawn(class 'OrderBotWRI',self,,Location);
				SpawnBotOrderWindow();
				frobServer(FrobTarget, none);
				return;
			}
		}
	}


	if ( ( (bClientsideInventory) && (ClientSelectedItem==none) ) || ( (!bClientsideInventory) && (SelectedItem==none) ) ) {
		if (HeldItem==none) {
			SelectedItemOffsetX=0; DesiredSelectedItemOffsetX=0;
			SelectedItemOffsetY=0; DesiredSelectedItemOffsetY=0;
		}
		if (FrobTarget!=none) { frobServer(FrobTarget, none); }
	                 	//else { log("[tpp:"$self$"] client frob() with frobtarget none"); }
	} else if (HeldItem==none) { // item selected
		if (SelectedItemIsUsedOnOthers() && ( FrobTarget==none || UsesFrobItem(FrobTarget) ) ) {

		//if ( (SelectedItemIsUsedOnOthers()) &&
			//( (FrobTarget==none) || ( (FrobTarget!=none) &&
			//( (UsesFrobItem(FrobTarget) )
			//( (FrobTarget.isA('ThDoor')) || (FrobTarget.isA('ThObjectFootLocker')) || (FrobTarget.isA('ThObjectMine')) || (FrobTarget.isA('ThObjectWhistler')) )
//			  ) ) ) { // item is used with other items
			if (SelectedItemOffsetX==-1000) { // item is in centre of screen
				if (FrobTarget!=none) {  // target to use item on
					// frob target with selected
					frobServer(FrobTarget, GetSelectedItem());
					DesiredSelectedItemOffsetX=0;
					DesiredSelectedItemOffsetY=0;
				} else { // no target, move item back to normal position
					DesiredSelectedItemOffsetX=0;
					DesiredSelectedItemOffsetY=0;
				}
			} else {
				//
				DesiredSelectedItemOffsetX=-1000;
				DesiredSelectedItemOffsetY=-750;
			}
		} else {
			SelectedItemOffsetX=0; DesiredSelectedItemOffsetX=0;
			SelectedItemOffsetY=0; DesiredSelectedItemOffsetY=0;
			if (FrobTarget!=none) { frobServer(FrobTarget, none); }
	                 	else {
	                 		//activateItem();
	                 		//log("Calling ClientActivate item");
	                 		if (class'ThieveryConfigClient'.default.bFrobUseInvItem)
	                 			ClientActivateItem();
	                 		//log("[tpp:"$self$"] client frob() with frobtarget none (cos no frobitem)");
	                 	}

		}
	}
}

//*******************************
// Misc. Changes
//******************************/

function ThObjectCarcass ThSpawnCarcass()
{
    if (ThCarcassType == class'ThObjectCarcass')
    {
        ThCarcassType=class'ThProCarcass';
    }
    super.ThSpawnCarcass();
}

function UpdateSensitivity(float F)
{
    if (!bOnParalysed)
    {
        super.UpdateSensitivity(F);
	}
}

exec function BehindView(bool behindView)
{
    if (PlayerReplicationInfo.Team == 255 || Health <= 0 || bAllowBehindView)
    {
        super.BehindView(behindView);
    }
}

state PlayerScouting
{
	function BeginState()
    {
	   super.BeginState();
	   if (Role == ROLE_Authority)
	   {
	       prevBehindView = bBehindView;
	       bBehindView = false;
	   }
	}

	function EndState()
	{
	   super.EndState();
	   if (Role == ROLE_Authority)
	   {
	       bBehindView = prevBehindView;
	   }
	}

    // Don't allow behind view while scouting
	exec function BehindView(bool behindView)
	{
   	}

}

state PlayerWalking
{
    // Changed to prevent bunny hopping
    function Landed(vector HitNormal) {
          local Vector vel;
          local float jumpRecoverSpeed;
          Super.Landed(HitNormal);
     	  if (VSize(Velocity)>=300)
          {
              JumpRecover=JumpRecoverTime;
              vel = velocity;
              vel.z = 0;
              jumpRecoverSpeed = 0.5 * default.groundSpeed * (mspeed / 100);
              if (VSize(vel) > jumpRecoverSpeed)
              {
                  velocity = Normal(vel) * jumpRecoverSpeed;
              }
          }

     }

    // Rough fix to slipping down ropes on remote clients
    function Dodge(eDodgeDir DodgeMove)
	{
		local vector X,Y,Z, wx,wy,wz;
		local float LadderPosition;
		local bool bInhibitLateralMovement;
		local vector start, end, hitlocation, hitnormal, extent, centreofrope;

		GetAxes(Rotation,X,Y,Z);
		if (DodgeMove == DODGE_Forward) {	// move up the ladder
			Velocity.Z = LadderSpeed;
			if (bOnSpeed) Velocity.Z = LadderSpeed * SpeedModifier();
			if (MyLadder!=none) {
				LadderPosition=abs(Location.Z-MyLadder.Location.Z);
				if ((LadderPosition<(MyLadder.CollisionHeight-1.2*CollisionHeight)) || ((MyLadder.IsA('ThRope')) && (Location.Z>MyLadder.Location.Z))) {
					bInhibitLateralMovement=true;
				}
				if (MyLadder.IsA('ThRope') && ThRope(MyLadder).bStickToRope) {	// lock the player to the centre of the rope
					centreofrope=MyLadder.Location;
					centreofrope.z=Location.Z;
					SetLocation(centreofrope-vector(Rotation)*vect(20,20,0));
					Velocity.X=0;
					Velocity.Y=0;
				}
			}
			if (bInhibitLateralMovement) {
				Velocity.X=0;
				Velocity.Y=0;
			}
			SetPhysics(PHYS_Flying);

			if ( Abs(OldLadderZ - Location.Z) > 72 ) {
				//log("playing ladder sound");
				if (PlayerReplicationInfo!=none && PlayerReplicationInfo.Team!=255
                   && !bOnCatfall) {
					PlayOwnedSound(ladderSound,SLOT_None,1.0);
				}
				OldLadderZ = Location.Z;
	  		}
		} else if (DodgeMove == DODGE_Back) {		// move down the ladder
			Velocity.Z = -LadderSpeed;
			if (bOnSpeed) Velocity.Z = -LadderSpeed * SpeedModifier();
			if (MyLadder!=none) {
				LadderPosition=abs(Location.Z-MyLadder.Location.Z);
				if (Location.Z<MyLadder.Location.Z) {	// bottom half of ladder
					if (LadderPosition<(MyLadder.CollisionHeight-1.2*CollisionHeight)) {
						bInhibitLateralMovement=true;
					}
				} else {
					if ((MyLadder!=none) && (MyLadder.IsA('ThRope')) && ThRope(MyLadder).bStickToRope) {
						bInhibitLateralMovement=true;
					} else {
						start=Location;  end=Location+vect(0,0,-1)*60;
						extent.X=CollisionRadius;
						extent.Y=CollisionRadius;
						extent.Z=0.1;
						if (Trace(hitlocation, hitnormal, end, start, false, extent)==none) {
							bInhibitLateralMovement=true;
						}
					}
				}
				if (MyLadder.IsA('ThRope') && ThRope(MyLadder).bStickToRope) {	// lock the player to the centre of the rope
					centreofrope=MyLadder.Location;
					centreofrope.Z=Location.Z;
					SetLocation(centreofrope-vector(Rotation)*vect(20,20,0));
					Velocity.X=0;
					Velocity.Y=0;
				}
			}
			if (bInhibitLateralMovement) {
				Velocity.X=0;
				Velocity.Y=0;
				SetPhysics(PHYS_Flying);
			} else if (MyLadder!=none && Location.Z<MyLadder.Location.Z) {
			     if (Physics==PHYS_Flying)
                    SetPhysics(PHYS_Falling);
			}
			if ( Abs(OldLadderZ - Location.Z) > 72 ) {
				if (PlayerReplicationInfo!=none && PlayerReplicationInfo.Team!=255
                   && !bOnCatfall) {
					PlayOwnedSound(ladderSound,SLOT_None,1.0);
				}
				OldLadderZ = Location.Z;
	  		}
		} else if (DodgeMove == DODGE_Left) {		// stand still on the ladder or walk normally if at ends
			if (MyLadder!=none) {
				LadderPosition=abs(Location.Z-MyLadder.Location.Z);
				if ((LadderPosition<(MyLadder.CollisionHeight-1.2*CollisionHeight)) || ((MyLadder.IsA('ThRope')) && (Location.Z>MyLadder.Location.Z))) {
					bInhibitLateralMovement=true;
				}
				if (MyLadder.IsA('ThRope') && ThRope(MyLadder).bStickToRope) {	// lock the player to the centre of the rope
					centreofrope=MyLadder.Location;
					centreofrope.z=Location.Z;
					SetLocation(centreofrope-vector(Rotation)*vect(20,20,0));
					Velocity.X=0;
					Velocity.Y=0;
				}
			}
			if (bInhibitLateralMovement) {
				Velocity.X=0;
				Velocity.Y=0;
				if (ropeHangFix)
				{
				    if (ropeFixCycle == 0)
				    {
				        Velocity.Z = 0.5;
				        SetLocation(location + vect(0,0,0.01));
				        ropeFixCycle = 1;
				    }
				    else
				    {
				        Velocity.Z = -0.5;
   				        SetLocation(location - vect(0,0,0.01));
				        ropeFixCycle = 0;
				    }
				}
				else
				{
				Velocity.Z = 0;
				}
				SetPhysics(PHYS_Flying);
			}
		} else if (DodgeMove==DODGE_Right) {	// dodge right is for mantling
			GetAxes(Rotation,wx,wy,wz); wx.z=0; wx=Normal(wx);

			Velocity.Z = MantleSpeed;
			Velocity.X = wx.x*GroundSpeed*0.5;
			Velocity.Y = wx.y*GroundSpeed*0.5;
		} else if (DodgeMove==DODGE_Active) {	// dodge active is for leaping off the ladder/rope
			// leap off ladder
			DoLeapOffLadder();
		}

	}

	function PlayerMove( float DeltaTime ) {
          local vector X,Y,Z, NewAccel, wx, wy, wz, Loc;
          local EDodgeDir OldDodge;
          local eDodgeDir DodgeMove;
          local rotator OldRotation;
          local float Speed2D,OldSpeed2D;
          local bool     bSaveJump;
          local name AnimGroupName;
          local rotator VelocityRotator;
          local int AngleDifference, i;
          local float VelocityCap,VelocityDecrease, DotProduct;
          local byte VelCap;
          local ThLadder RLadder;


          if (playerReplicationInfo != none)
          {
          GetAxes(Rotation,X,Y,Z);

					bInsideLadder=false;
					//if (PlayerReplicationInfo.Team!=255) {
	          for (i=0;i<4;i++) {
	          	if (Touching[i]!=none) {
	          		if (Touching[i].IsA('ThLadder') && Touching[i]!=LadderJumpedFrom) {
	          			bInsideLadder=true;
	          			break;
	          		}
	          	}
	          }

          aForward *= 0.4;     //aForward*=0.01;
          aStrafe  *= 0.4;     //aStrafe*=0.01;
          aLookup  *= 0.24;
          aTurn    *= 0.24;

					// make the player move around all the time if on crazy crack
					if (bOnCrack) {
						aForward=400;
						if (Level.TimeSeconds % 6 < 3)
							aStrafe=400;
						else
							aStrafe=-400;
					}

          if (bDuck>128)
          	bDuck=0;

          if (bInsideLadder) {
          	aForward*=0.1;
          	aStrafe*=0.1;
          }

          if (bOnParalysed) {	// turn slowly when paralysed
          	aLookup  *= 0.1;
			aTurn    *= 0.1;
          }

          TSpeed=2;
          if (bTWalking>0) TSpeed=1;
          if ((bTSpeedUp>0) && (TSpeed<2)) TSpeed++;
          if (bTSlowDown>0) TSpeed--;
          if (TSpeed > 1 && bOnParalysed) TSpeed = 1;

          // Limit velocity when strafing/walking backwards
          VelocityCap=1.0;

          if (VSize(Velocity)>0) {
          	DotProduct=Normal(Velocity) dot vector(Rotation);

          	if (DotProduct<-0.8) {		// backwards

          	    if (TSpeed>1)
                {
          		    VelocityCap=0.8;
          		    TSpeed=1;
          		}
          		else
          		{
          		    VelocityCap=0.5;
          		}
          	} else if (DotProduct<-0.5) {		// backwards strafing
          		if (TSpeed>1)
                {
          		    VelocityCap=0.8;
          		    TSpeed=1;
          		}
          		else
          		{
          		    VelocityCap=0.5;
          		}
          	} else if (DotProduct<0.5) {		// strafing
          		VelocityCap=0.5;
          	} else if (DotProduct<0.8) { 		// forward strafing
          		VelocityCap=0.95;
          	}
          }

          // change cap depending on tspeed
          switch (TSpeed) {
               case 0:VelocityCap*=0.22; break;  // creeping
               case 1:VelocityCap*=0.50; break;   // walking
          }

          //if ((bIsCrouching) && (TSpeed>1)) TSpeed=1; // can't run while crouching
          if (bIsCrouching) {
          	if (TSpeed>1) TSpeed=1;
          	VelocityCap*=0.35; // slow you down for crouching
          	if (PlayerReplicationInfo.Team==1) VelocityCap*=0.75;	// guards even slower crouched
          }

          // change player speed if carrying an item in hands
          if (HeldItem!=none) {
          	if (HeldItem.isA('ThieveryObject')) {
          		VelocityCap*=ThieveryObject(HeldItem).MovementScaleWhileCarrying;
          	}
          }

          // change player speed if weapon is out
          if (Weapon!=none) {
          	if (Weapon.isA('ThieveryWeapon')) {
          		if (PlayerReplicationInfo.Team==1)
          			VelocityCap*=ThieveryWeapon(Weapon).MovementScaleWhileCarryingGuard;
          		else
          			VelocityCap*=ThieveryWeapon(Weapon).MovementScaleWhileCarrying;
          	}
          }

          if (bOnSpeed && !bOnParalysed) {  // drinking a speed potion, move quicker
            VelocityCap *= SpeedModifier();
          	if (Role<ROLE_Authority) {
          		SpeedPotionDuration-=deltatime;
          		if (SpeedPotionDuration<=0) {
	          		SpeedPotionDuration=0;
	          	}
	          }
          }

          if ((JumpRecover>0) && (Physics==PHYS_Walking)) {	// slow player after landing from a jump
          	VelocityCap*=1.0-((JumpRecover/JumpRecoverTime)/2.0);
          }

		  if (bOnParalysed) {	// paralysed, move slower
          	if (Role<ROLE_Authority) {
          		ParalysedDuration-=deltatime;
          		if (ParalysedDuration<=0) {
          			ParalysedDuration=0;
          			bOnParalysed=false;
          		}
          	}
          }

		// if you're a rat, and hidden (i.e. follow camming someone else), then don't move
		if ((PlayerReplicationInfo.team==255 && bHidden) || health <= 0)
			VelocityCap=0;

          velcaptemp=VelocityCap; AngDiffTemp=AngleDifference;
          VelCap=byte(VelocityCap*100);

          // Update acceleration.
          NewAccel = aForward*X + aStrafe*Y;
          NewAccel.Z = 0;

          // use dodge moves to send ladder climbing info
          DodgeMove=DODGE_None;
          if (bInsideLadder) {
          	if (aForward>0) {
          		if ((ViewRotation.Pitch>4000) && (ViewRotation.Pitch<19000)) {	// looking up
          			DodgeMove=DODGE_Forward;	// climb up ladder
          		} else if ((ViewRotation.Pitch>48000) && (ViewRotation.Pitch<61000)) {  // looking down
          			DodgeMove=DODGE_Back;		// climb down ladder
          		}
          	} else if (aForward<0) {
          		if ((ViewRotation.Pitch>4000) && (ViewRotation.Pitch<19000)) { // looking up
          			DodgeMove=DODGE_Back;		// climb down ladder
          		} else if ((ViewRotation.Pitch>48000) && (ViewRotation.Pitch<61000)) { // looking down
          			DodgeMove=DODGE_Forward;	// climb up ladder
          		}
          	} else {
          		DodgeMove=DODGE_Left;	// player floating
          	}
          	// pitches
          	//49000 = straight down
          	//65000/0 = straight forward
          	//18000 = straight up
          	if (bOkayToJumpOffLadder && bJumpKey!=0 && Physics==PHYS_Flying) {
          		DodgeMove=DODGE_Active;	// player leaping off ladder
          		bOkayToJumpOffLadder=false;
          	} else if (!bOkayToJumpOffLadder && bJumpKey==0) {
          		bOkayToJumpOffLadder=true;
          	}
          	LastDodgeMove = DodgeMove;
          } else {
          	if (Physics==PHYS_Flying) {
				SetPhysics(PHYS_Falling);
		    }
          }

          // also use dodge move to mantle
          if (bMantling) {
          	DodgeMove=DODGE_Right;

          	GetAxes(Rotation,wx,wy,wz); wx.z=0; wx=Normal(wx);
						loc=Location;
						loc.Z-=CollisionHeight;
						if ((bJumpKey==0) || 							// let go of jump
							(GapInFront(Loc,wx)) || 					// gap at feet
								(Location.Z-StartMantleLocation.Z>MaxMantleHeight)
								|| BumpedHead()) {	// at max mantle height

							bMantling=false;
						}
          }
          }

          if (Mesh!=none)
          	AnimGroupName = GetAnimGroup(AnimSequence);
          else
          	AnimGroupName = '';
          if ( (Physics == PHYS_Walking) && (AnimGroupName != 'Dodge') ) {
               //if walking, look up/down stairs - unless player is rotating view
               if ( !bKeyboardLook && (bLook == 0) ) {
                    if ( bLookUpStairs )
                         ViewRotation.Pitch = FindStairRotation(deltaTime);
                    else if ( bCenterView )
                    {
                         ViewRotation.Pitch = ViewRotation.Pitch & 65535;
                         if (ViewRotation.Pitch > 32768)
                              ViewRotation.Pitch -= 65536;
                         ViewRotation.Pitch = ViewRotation.Pitch * (1 - 12 * FMin(0.0833, deltaTime));
                         if ( Abs(ViewRotation.Pitch) < 1000 )
                              ViewRotation.Pitch = 0;
                    }
               }

               Speed2D = Sqrt(Velocity.X * Velocity.X + Velocity.Y * Velocity.Y);
               // dalai attribute so show on hud
               Speed2Dtemp=Speed2D;
               //add bobbing when walking
               if ( !bShowMenu )
                    CheckBob(DeltaTime, Speed2D, Y);
          } else if ( !bShowMenu ) {
               BobTime = 0;
          }

          // Update rotation.
          OldRotation = Rotation;
          UpdateRotation(DeltaTime, 1);

          if ( bPressedJump && (AnimGroupName == 'Dodge') ) {
               bSaveJump = true;
               bPressedJump = false;
          }
          else
               bSaveJump = false;

	  OldAccn=NewAccel;

          if ( Role < ROLE_Authority ) { // then save this move and replicate it
               TReplicateMove(DeltaTime, NewAccel, DodgeMove, OldRotation - Rotation, VelCap);
          } else {
               	OldVelocity=Velocity;
               	TProcessMove(DeltaTime, NewAccel, DodgeMove, OldRotation - Rotation, VelCap);
	  }
          bPressedJump = bSaveJump;

     }
}

state PlayerSwimming
{
    // using dodge to climb ladders
    function Dodge(eDodgeDir DodgeMove)
	{
		local vector X,Y,Z, wx,wy,wz;
		local float LadderPosition;
		local bool bInhibitLateralMovement;
		local vector start, end, hitlocation, hitnormal, extent, centreofrope;

		//if ( bIsCrouching || (Physics != PHYS_Walking))
			//return;
		GetAxes(Rotation,X,Y,Z);
		if (DodgeMove == DODGE_Forward) {	// move up the ladder
			Velocity.Z = LadderSpeed;
			if (bOnSpeed) Velocity.Z = LadderSpeed * SpeedModifier();
			if (MyLadder!=none) {
				LadderPosition=abs(Location.Z-MyLadder.Location.Z);
				if ((LadderPosition<(MyLadder.CollisionHeight-1.2*CollisionHeight)) || ((MyLadder.IsA('ThRope')) && (Location.Z>MyLadder.Location.Z))) {
					bInhibitLateralMovement=true;
				}
				if (MyLadder.IsA('ThRope') && ThRope(MyLadder).bStickToRope) {	// lock the player to the centre of the rope
					centreofrope=MyLadder.Location;
					centreofrope.Z=Location.Z;
					SetLocation(centreofrope);
					Velocity.X=0;
					Velocity.Y=0;
				}
			}
			if (bInhibitLateralMovement) {
				Velocity.X=0;
				Velocity.Y=0;
			}

			SetPhysics(PHYS_Flying);
			if ( Abs(OldLadderZ - Location.Z) > 72 ) {
				//log("playing ladder sound");
				if (PlayerReplicationInfo!=none && PlayerReplicationInfo.Team!=255
                   && !bOnCatfall) {
					PlayOwnedSound(ladderSound,SLOT_None,1.0);
				}
				OldLadderZ = Location.Z;
	  		}
		} else if (DodgeMove == DODGE_Back) {		// move down the ladder
			Velocity.Z = -LadderSpeed;
            if (bOnSpeed) Velocity.Z = -LadderSpeed * SpeedModifier();
			if (MyLadder!=none) {
				LadderPosition=abs(Location.Z-MyLadder.Location.Z);
				if (Location.Z<MyLadder.Location.Z) {	// bottom half of ladder
					if (LadderPosition<(MyLadder.CollisionHeight-1.2*CollisionHeight)) {
						bInhibitLateralMovement=true;
					}
				} else {
					if ((MyLadder!=none) && (MyLadder.IsA('ThRope'))) {
						bInhibitLateralMovement=true;
					} else {
						start=Location;  end=Location+vect(0,0,-1)*60;
						extent.X=CollisionRadius;
						extent.Y=CollisionRadius;
						extent.Z=0.1;
						if (Trace(hitlocation, hitnormal, end, start, false, extent)==none) {
							bInhibitLateralMovement=true;
						}
					}
				}
				if (MyLadder.IsA('ThRope') && ThRope(MyLadder).bStickToRope) {	// lock the player to the centre of the rope
					centreofrope=MyLadder.Location;
					centreofrope.Z=Location.Z;
					SetLocation(centreofrope);
					Velocity.X=0;
					Velocity.Y=0;
				}
			}
			if (bInhibitLateralMovement) {
				Velocity.X=0;
				Velocity.Y=0;
				SetPhysics(PHYS_Flying);
			} else if (MyLadder!=none && Location.Z<MyLadder.Location.Z) {
			     if (Physics==PHYS_Flying)
				    SetPhysics(PHYS_Falling);
			}
			if ( Abs(OldLadderZ - Location.Z) > 72 ) {
				if (PlayerReplicationInfo!=none && PlayerReplicationInfo.Team!=255
                   && !bOnCatfall) {
					PlayOwnedSound(ladderSound,SLOT_None,1.0);
			  }
				OldLadderZ = Location.Z;
				//log("playing ladder sound");
	  		}
		} else if (DodgeMove == DODGE_Left) {		// stand still on the ladder or walk normally if at ends
			if (MyLadder!=none) {
				LadderPosition=abs(Location.Z-MyLadder.Location.Z);
				if ((LadderPosition<(MyLadder.CollisionHeight-1.2*CollisionHeight)) || ((MyLadder.IsA('ThRope')) && (Location.Z>MyLadder.Location.Z))) {
					bInhibitLateralMovement=true;
				}
			}
			if (bInhibitLateralMovement) {
    			Velocity.X=0;
				Velocity.Y=0;
			    if (ropeHangFix)
				{
				    if (ropeFixCycle == 0)
				    {
				        Velocity.Z = 0.5;
				        SetLocation(location + vect(0,0,0.01));
				        ropeFixCycle = 1;
				    }
				    else
				    {
				        Velocity.Z = -0.5;
   				        SetLocation(location - vect(0,0,0.01));
				        ropeFixCycle = 0;
				    }
				}
				else
				{
				Velocity.Z = 0;
				}

				SetPhysics(PHYS_Flying);
			}
		} else if (DodgeMove==DODGE_Right) {	// dodge right is for mantling
			GetAxes(Rotation,wx,wy,wz); wx.z=0; wx=Normal(wx);

			Velocity.Z = MantleSpeed;
			Velocity.X = wx.x*GroundSpeed*0.5;
			Velocity.Y = wx.y*GroundSpeed*0.5;
		} else if (DodgeMove==DODGE_Active) {	// dodge active is for leaping off the ladder/rope
			// leap off ladder
			DoLeapOffLadder();
		}

	}

	function PlayerMove( float DeltaTime ) {
          local vector X,Y,Z, NewAccel, wx, wy, wz, Loc;
          local EDodgeDir OldDodge;
          local eDodgeDir DodgeMove;
          local rotator OldRotation;
          local float Speed2D,OldSpeed2D;
          local bool     bSaveJump;
          local name AnimGroupName;
          local rotator VelocityRotator;
          local int AngleDifference, i;
          local float VelocityCap,VelocityDecrease;
          local byte VelCap;
					local ThLadder RLadder;

          GetAxes(ViewRotation,X,Y,Z);

					bInsideLadder=false;
	          for (i=0;i<4;i++) {
	          	if (Touching[i]!=none) {
	          		if (Touching[i].IsA('ThLadder') && Touching[i]!=LadderJumpedFrom) {
	          			bInsideLadder=true;
	          			break;
	          		}
	          	}
	          }

          aForward *= 0.4;     //aForward*=0.01;
          aStrafe  *= 0.4;     //aStrafe*=0.01;
          aLookup  *= 0.24;
          aTurn    *= 0.24;
          aUp      *= 0.1;

          if (bDuck>128)
          	bDuck=0;

          if (bInsideLadder) {
          	aForward*=0.1;
          	aStrafe*=0.1;
          }

          if (bOnParalysed) {	// turn slowly when paralysed
          	aLookup  *= 0.1;
						aTurn    *= 0.1;
          }

          TSpeed=2;
          if (bTWalking>0) TSpeed=1;
          if ((bTSpeedUp>0) && (TSpeed<2)) TSpeed++;
          if (bTSlowDown>0) TSpeed--;

          // Limit velocity when strafing/walking backwards
          VelocityCap=1.0;
          VelocityRotator=rotator(velocity);
          AngleDifference=ViewRotation.Yaw-VelocityRotator.Yaw;
          while (AngleDifference<0) { AngleDifference+=65536; }
          while (AngleDifference>65536) { AngleDifference-=65536; }
          if ((AngleDifference>12288) && (AngleDifference<53248)) VelocityCap=0.8;  // playerstrafing
          if ((AngleDifference>24576) && (AngleDifference<40960)) {
          	VelocityCap=0.8;  // walking backwards
          	if (TSpeed>1) TSpeed=1; // can't run backwards, only walk
          }

          // change cap depending on tspeed
          switch (TSpeed) {
               case 0:VelocityCap*=0.22; break;  // creeping
               case 1:VelocityCap*=0.50; break;   // walking
          }

          // change player speed if carrying an item in hands
          if (HeldItem!=none) {
          	if (HeldItem.isA('ThieveryObject')) {
          		VelocityCap*=ThieveryObject(HeldItem).MovementScaleWhileCarrying;
          	}
          }

          // change player speed if weapon is out
          if (Weapon!=none) {
          	if (Weapon.isA('ThieveryWeapon')) {
          		if (PlayerReplicationInfo.Team==1)
          			VelocityCap*=ThieveryWeapon(Weapon).MovementScaleWhileCarryingGuard;
          		else
          			VelocityCap*=ThieveryWeapon(Weapon).MovementScaleWhileCarrying;
          	}
          }

          if (bOnSpeed) {  // drinking a speed potion, move quicker
          	VelocityCap*=SpeedModifier();
          	if (Role<ROLE_Authority) {
          		SpeedPotionDuration-=deltatime;
          		if (SpeedPotionDuration<=0) {
	          		SpeedPotionDuration=0;
	          	}
	          }
          }

          if (bOnParalysed) {	// paralysed, move slower
          	VelocityCap=0.5;
          	if (bIsCrouching)
          		VelocityCap = 0.25;
          	if (Role<ROLE_Authority) {
          		ParalysedDuration-=deltatime;
          		if (ParalysedDuration<=0) {
	          		ParalysedDuration=0;
	          		bOnParalysed=false;
	          	}
	          }
          }

          // if you're a rat, and hidden (i.e. follow camming someone else), then don't move
					if ((PlayerReplicationInfo.team==255 && bHidden) || health <= 0)
						VelocityCap=0;

          velcaptemp=VelocityCap; AngDiffTemp=AngleDifference;
          VelCap=byte(VelocityCap*100);

          NewAccel = aForward*X + aStrafe*Y + aUp*vect(0,0,1);

          // use dodge moves to send ladder climbing info

          DodgeMove=DODGE_None;
          if (bInsideLadder) {
          	if (aForward>0) {
          		if ((ViewRotation.Pitch>4000) && (ViewRotation.Pitch<19000)) {	// looking up
          			DodgeMove=DODGE_Forward;	// climb up ladder
          		} else if ((ViewRotation.Pitch>48000) && (ViewRotation.Pitch<61000)) {  // looking down
          			DodgeMove=DODGE_Back;		// climb down ladder
          		}
          	} else if (aForward<0) {
          		if ((ViewRotation.Pitch>4000) && (ViewRotation.Pitch<19000)) { // looking up
          			DodgeMove=DODGE_Back;		// climb down ladder
          		} else if ((ViewRotation.Pitch>48000) && (ViewRotation.Pitch<61000)) { // looking down
          			DodgeMove=DODGE_Forward;	// climb up ladder
          		}
          	} else {
          		DodgeMove=DODGE_Left;	// player floating
          	}
          	// pitches
          	//49000 = straight down
          	//65000/0 = straight forward
          	//18000 = straight up
          	if (bJumpKey!=0) {
          		DodgeMove=DODGE_Active;	// player leaping off ladder
          	}
          } else {
          	if (Physics==PHYS_Flying) {
				SetPhysics(PHYS_Swimming);
			}
          }
          LastDodgeMove = DodgeMove;

          // also use dodge move to mantle
          if (bMantling) {
          	DodgeMove=DODGE_Right;

          	GetAxes(Rotation,wx,wy,wz); wx.z=0; wx=Normal(wx);
						loc=Location;
						loc.Z-=CollisionHeight;
						if ((bJumpKey==0) || 							// let go of jump
							(GapInFront(Loc,wx)) || 					// gap at feet
								(Location.Z-StartMantleLocation.Z>MaxMantleHeight)	// at max mantle height
								|| BumpedHead()) {

							bMantling=false;
						}
          }

          // Update rotation.
          OldRotation = Rotation;
          UpdateRotation(DeltaTime, 2);

          if ( bPressedJump && (AnimGroupName == 'Dodge') ) {
               bSaveJump = true;
               bPressedJump = false;
          }
          else
               bSaveJump = false;


          if ( Role < ROLE_Authority ) { // then save this move and replicate it
               TReplicateMove(DeltaTime, NewAccel, DodgeMove, OldRotation - Rotation, VelCap);
          } else {
               	OldVelocity=Velocity;
               	TProcessMove(DeltaTime, NewAccel, DodgeMove, OldRotation - Rotation, VelCap);
	      }
          bPressedJump = false;
     }
}

simulated function float SpeedModifier()
{
    if (balancedSpeedPots)
    {
        return 1.0 + 0.5 * fMin(1, 1 - (1 - (SpeedPotionDuration / 10)) * (1 - (SpeedPotionDuration / 10)));
    }
    else
    {
        return 1.5;
    }
}

// Slight fixes to KO detection
function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation,
						Vector momentum, name damageType) {
	local float dotproduct, height;
	local string n;
	local TSuspiciousThing st;

	// make player be shown for a second
	VisCapacitor=1.0;

	// check for blocking
	if ((Weapon.isA('ThWeaponSword')) && ((Weapon.GetStateName()=='ClientAltFiring')
					   || (Weapon.GetStateName()=='AltFiring')
					 )) {
		if (ThieveryWeapon(Weapon).BlockedAttack(Damage, hitlocation, damageType))
			return;
	}
	// check for KO
	if ((damageType=='KnockedOut') || (damageType=='KnockedOutHeavy')) {
		GiveKOEffect(); // make the screen shake
		if (!ThieveryPlayerReplicationInfo(PlayerReplicationInfo).bHelmet) {
			dotproduct= Normal((HitLocation-Location) * vect(1,1,0))
			 dot
			Normal(vector(Rotation) * vect(1,1,0)); // how near the front the attack is

			if (dotproduct<0 && bCanBeKnockedOut) {
				if ( (PlayerReplicationInfo.Team!=0) ||
				     (damageType=='KnockedOutHeavy' && ThieveryGameReplicationInfo(GameReplicationInfo).bThievesVs) ) {	// thieves don't get KOd

				 	if(hitlocation.Z > Location.Z+CollisionHeight*0.5)		// is in top 25% of cylinder
						Damage=999999;
				}
			}
		} else {
			//log("MAKING THIS SOUND");
			PlaySound(sound'ThieveryData.BJFail');
		}
	} else if (damageType=='MeleeBluntMace') {
		GiveKOEffect(); // make the screen shake
	}
	DoDamageEffects(Damage, instigatedBy, hitlocation, momentum, damageType); // spawn blood, etc
	Super(TMale1).TakeDamage(Damage,instigatedBy,hitlocation,momentum,damageType);
	// KO message
	if ( ((DamageType=='KnockedOut') || (DamageType=='KnockedOutHeavy'))  && (Health<=0) ) {
		n=instigatedBy.PlayerReplicationInfo.PlayerName;
		if (n!="") {
			ClientMessage("You were knocked out by "$n$"!");
		} else {
			ClientMessage("You were knocked out!");
		}
	}
}

function ClearCatfall()
{
    bOnCatfall = false;
    CatfallPotionDuration = 0;
}

function ClearCrackImmune()
{
    bOnCrackImmune = false;
    BreathPotionDuration = 0;
}

function ClearSpeed()
{
    bOnSpeed = false;
    SpeedPotionDuration = 0;
    ClientGiveSpeed(0);
}

//
// Send movement to the server.
// Passes acceleration in components so it doesn't get rounded.
// (copy & pasted form PlayerPawn, added haXor velcap, also packed bools into one byte to allow extra parameters)
function TServerMove
(
     float TimeStamp,
     vector InAccel,
     vector ClientLoc,
     byte PackedBits,
     //bool NewbRun,
     //bool NewbDuck,
     //bool NewbJumpStatus,
     //bool bFired,
     //bool bAltFired,
     //bool bForceFire,
     //bool bForceAltFire,
     eDodgeDir DodgeMove,
     byte ClientRoll,
     int View,
     optional byte OldTimeDelta,
     optional int OldAccel,
     optional byte VelCap
)
{
     local float DeltaTime, clientErr, OldTimeStamp;
     local rotator DeltaRot, Rot;
     local vector Accel, LocDiff, ThOldLocation;
     local int maxPitch, ViewPitch, ViewYaw;
     local actor OldBase;
     local bool NewbPressedJump, OldbRun, OldbDuck;
     local eDodgeDir OldDodgeMove;
     //dalai
     local float VelocityScale;
     //dalai (for packed bits)
     local bool NewbRun,NewbDuck,NewbJumpStatus,bFired,bAltFired,bForceFire,bForceAltFire;

     // If this move is outdated, discard it.
     if ( CurrentTimeStamp >= TimeStamp )
          return;

		ThOldLocation=Location;

	//dalai (unpack the bits)
     NewbRun=bool(PackedBits & 1);
     NewbDuck=bool(PackedBits & 2);
     NewbJumpStatus=bool(PackedBits & 4);
     bFired=bool(PackedBits & 8);
     bAltFired=bool(PackedBits & 16);
     bForceFire=bool(PackedBits & 32);
     bForceAltFire=bool(PackedBits & 64);

			// check you're not moving too fast
		  if (!bOnSpeed) {
				if (VelCap>100)
    	 		VelCap=100;

    	 	if (bIsCrouching && VelCap>35 && Physics == PHYS_Walking)
    	 		VelCap=35;
   		} else {
   			if (VelCap>150)
    	 		VelCap=150;

    	 	if (bIsCrouching && VelCap>53 && Physics == PHYS_Walking)
    	 		VelCap=53;
   		}

			if (bOnParalysed) {	// paralysed, move slower
				//log(self$" replicate move, setting velcap to 10, was "$VelCap$" duration is "$ParalysedDuration);
		    VelCap = Min(50, VelCap);
		    if (bIsCrouching)
		    	VelCap = Min(18, VelCap);
		  }


     // if OldTimeDelta corresponds to a lost packet, process it first
     if (  OldTimeDelta != 0 )
     {
          OldTimeStamp = TimeStamp - float(OldTimeDelta)/500 - 0.001;
          if ( CurrentTimeStamp < OldTimeStamp - 0.001 )
          {
               // split out components of lost move (approx)
               Accel.X = OldAccel >>> 23;
               if ( Accel.X > 127 )
                    Accel.X = -1 * (Accel.X - 128);
               Accel.Y = (OldAccel >>> 15) & 255;
               if ( Accel.Y > 127 )
                    Accel.Y = -1 * (Accel.Y - 128);
               Accel.Z = (OldAccel >>> 7) & 255;
               if ( Accel.Z > 127 )
                    Accel.Z = -1 * (Accel.Z - 128);
               Accel *= 20;

               OldbRun = ( (OldAccel & 64) != 0 );
               OldbDuck = ( (OldAccel & 32) != 0 );
               NewbPressedJump = ( (OldAccel & 16) != 0 );
               if ( NewbPressedJump )
                    bJumpStatus = NewbJumpStatus;

               switch (OldAccel & 7)
               {
                    case 0:
                         OldDodgeMove = DODGE_None;
                         break;
                    case 1:
                         OldDodgeMove = DODGE_Left;
                         break;
                    case 2:
                         OldDodgeMove = DODGE_Right;
                         break;
                    case 3:
                         OldDodgeMove = DODGE_Forward;
                         break;
                    case 4:
                         OldDodgeMove = DODGE_Back;
                         break;
               }
               //log("Recovered move from "$OldTimeStamp$" acceleration "$Accel$" from "$OldAccel);
               TMoveAutonomous(OldTimeStamp - CurrentTimeStamp, OldbRun, OldbDuck, NewbPressedJump, OldDodgeMove, Accel, rot(0,0,0), VelCap);
               CurrentTimeStamp = OldTimeStamp;
          }
     }

     // View components
     ViewPitch = View/32768;
     ViewYaw = 2 * (View - 32768 * ViewPitch);
     ViewPitch *= 2;
     // Make acceleration.
     Accel = InAccel/10;

     NewbPressedJump = (bJumpStatus != NewbJumpStatus);
     bJumpStatus = NewbJumpStatus;

     // handle firing and alt-firing
     if ( bFired )
     {
          if ( bForceFire && (Weapon != None) ) {
          	//log("[tpp:"$self$"] servermove() w.forcefire");
               Weapon.ForceFire();
          } else if ( bFire == 0 ) {
          	//log("[tpp:"$self$"] servermove() fire");
               Fire(0);
          }
          bFire = 1;
     }
     else
          bFire = 0;


     if ( bAltFired )
     {
          if ( bForceAltFire && (Weapon != None) )
               Weapon.ForceAltFire();
          else if ( bAltFire == 0 )
               AltFire(0);
          bAltFire = 1;
     }
     else
          bAltFire = 0;

     // Save move parameters.
     DeltaTime = TimeStamp - CurrentTimeStamp;
     if ( ServerTimeStamp > 0 )
     {
          // allow 1% error
          TimeMargin += DeltaTime - 1.01 * (Level.TimeSeconds - ServerTimeStamp);
          if ( TimeMargin > MaxTimeMargin )
          {
               // player is too far ahead
               TimeMargin -= DeltaTime;
               if ( TimeMargin < 0.5 )
                    MaxTimeMargin = Default.MaxTimeMargin;
               else
                    MaxTimeMargin = 0.5;
               DeltaTime = 0;
          }
     }

     CurrentTimeStamp = TimeStamp;
     ServerTimeStamp = Level.TimeSeconds;
     Rot.Roll = 256 * ClientRoll;
     Rot.Yaw = ViewYaw;
     if ( (Physics == PHYS_Swimming) || (Physics == PHYS_Flying) )
          maxPitch = 2;
     else
          maxPitch = 1;
     If ( (ViewPitch > maxPitch * RotationRate.Pitch) && (ViewPitch < 65536 - maxPitch * RotationRate.Pitch) )
     {
          If (ViewPitch < 32768)
               Rot.Pitch = maxPitch * RotationRate.Pitch;
          else
               Rot.Pitch = 65536 - maxPitch * RotationRate.Pitch;
     }
     else
          Rot.Pitch = ViewPitch;
     DeltaRot = (Rotation - Rot);
     ViewRotation.Pitch = ViewPitch;
     ViewRotation.Yaw = ViewYaw;
     ViewRotation.Roll = 0;

     if (PlayerReplicationInfo.Team==255) rot.pitch=0;	// rat always flat on floor

     SetRotation(Rot);

     OldBase = Base;

     // Perform actual movement.
     if ( (Level.Pauser == "") && (DeltaTime > 0) )
          TMoveAutonomous(DeltaTime, NewbRun, NewbDuck, NewbPressedJump, DodgeMove, Accel, DeltaRot, VelCap);

     // Accumulate movement error.
     if ( Level.TimeSeconds - LastUpdateTime > 500.0/Player.CurrentNetSpeed )
          ClientErr = 10000;
     else if ( Level.TimeSeconds - LastUpdateTime > 180.0/Player.CurrentNetSpeed )
     {
          LocDiff = Location - ClientLoc;
          ClientErr = LocDiff Dot LocDiff;
     }

     // If client has accumulated a noticeable positional error, correct him.
     if ( ClientErr > 3 )
     {
          if ( Mover(Base) != None )
               ClientLoc = Location - Base.Location;
          else
               ClientLoc = Location;
          // dalai unremmed
          //log("Client Error at "$TimeStamp$" is "$ClientErr$" with acceleration "$Accel$" LocDiff "$LocDiff$" Physics "$Physics);
          LastUpdateTime = Level.TimeSeconds;
          ClientAdjustPosition
          (
               TimeStamp,
               GetStateName(),
               Physics,
               ClientLoc.X,
               ClientLoc.Y,
               ClientLoc.Z,
               Velocity.X,
               Velocity.Y,
               Velocity.Z,
               Base
          );
     }
     if (Physics==PHYS_Walking) {
	     DistanceSinceLastFootstep+=VSize(Location-ThOldLocation);
	     if (DistanceSinceLastFootstep>ServerFootStepThreshold && GetStateName()=='PlayerWalking' && PlayerReplicationInfo.Team!=255) {
	     		//log(self$"Server driven footstep from "$PlayerReplicationInfo.PlayerName);
			  	ServerFootStepping();
			 }
		 }
     //log("Server "$Role$" moved "$self$" stamp "$TimeStamp$" location "$Location$" Acceleration "$Acceleration$" Velocity "$Velocity);
}

DefaultProperties
{
    PlayerReplicationInfoClass=Class'ThProPRI'
    prevBehindView=false
    bAllowBehindView=false
}