//-----------------------------------------------------------
// ThieveryProMod - ThieveryProTvG by Immortius
// Gametype for pro mod, not required yet.
//-----------------------------------------------------------
class ThieveryProTvG expands ThieveryDeathMatchPlus config(ThieveryProMod);

var config int InitialLives;
var config int LivesPerWave;
var config int Waves;
var int wave;
var int waveTime;
var int nextWaveTime;
var string ThiefIP[64];	// keep track of thieves' ip's so they don't reconnect and get more lives (lamers)
var string GuardIP[64]; //
var int ThiefLives[64];

event PreBeginPlay()
{
   spawn(class'ThProMutator');
   super.PreBeginPlay();
}

function ThieveryPawnWaiting (ThieveryPPawn P) {
	if (P.PlayerReplicationInfo!=none) P.PlayerReplicationInfo.Team=255;
	CountUpPlayersForScoreboard();
}

function PlayerReady(ThieveryProPawn P) {
    if (IsSpectatorIP(P)) {
		P.MakeRat();
		P.ClientMakeRat();
		P.bPickedTeam=true;
		P.ClientShowObjectives(1);
		P.bShowObjectives=1;
		ThAddDefaultInventory(P);
		if (!(bRequireReady && (CountDown > 0))) {
			RestartPlayer(P);
		}
	} else if (IsThiefIP(P)) {
	   P.PlayerLives = GetThiefLivesForIP(P);
	   ThieveryPlayerReplicationInfo(P.PlayerReplicationInfo).PlayerLives=P.PlayerLives;
	   P.PlayerReplicationInfo.Team = 0;
	   P.bPickedTeam=true;
       if (P.PlayerLives > 0)
	   {
	       P.MakeThief();
	       P.ClientMakeThief();

    	   P.ClientShowObjectives(1);
  	       P.bShowObjectives=1;
	       ThAddDefaultInventory(P);
	       if (!(bRequireReady && CountDown > 0)) {
		    	ServerRestartThieveryPawn(P);
		   }
	    }
	    else
	    {
	        P.MakeTeamSpectator();
	        P.ClientMakeTeamSpectator();
	    }
    }  else if (ISGuardIP(P)) {
	   P.MakeGuard();
	   P.ClientMakeGuard();
	   P.bPickedTeam=true;
	   P.ClientShowObjectives(1);
	   P.bShowObjectives=1;
	   ThAddDefaultInventory(P);
	   if (!(bRequireReady && CountDown > 0)) {
			RestartPlayer(P);
		}
	}
	else
	{
	   P.ChangeClass();
	}
}

function UseUpALife(pawn APlayer) {
	if (aPlayer.IsA('ThieveryPPawn')) {
		ThieveryPPawn(aPlayer).PlayerLives--;
		ThieveryPlayerReplicationInfo(aPlayer.PlayerReplicationInfo).PlayerLives=ThieveryPPawn(aPlayer).PlayerLives;	// rep for scoreboard
		if (ThieveryPPawn(aPlayer).PlayerLives>1) {
			ThieveryPPawn(aPlayer).ClientMessage("You have "$ThieveryPPawn(aPlayer).PlayerLives$" lives left this wave.");
		} else if (ThieveryPPawn(aPlayer).PlayerLives==1){
			ThieveryPPawn(aPlayer).ClientMessage("You have 1 life left this wave.");
		} else {
			ThieveryPPawn(aPlayer).ClientMessage("You have no lives remaining this wave.");
		}
		AddThiefIP(ThieveryPPawn(APlayer));
	}
	CountUpPlayersForScoreboard();
}

function AssignNomineeToTeam(ThieveryPPawn tpp, int TeamNo) {
    if (TeamNo==0) {
		tpp.MakeThief();
		tpp.ClientMakeThief();
		tpp.bPickedTeam=true;
		tpp.ClientShowObjectives(1);
		tpp.bShowObjectives=1;
		tpp.PlayerLives = InitialLives;
		ThieveryPlayerReplicationInfo(tpp.PlayerReplicationInfo).PlayerLives = tpp.PlayerLives;
		ThAddDefaultInventory(tpp);
	} else if (TeamNo==1) {
		tpp.MakeGuard();
		tpp.ClientMakeGuard();
		tpp.bPickedTeam=true;
		tpp.ClientShowObjectives(1);
		tpp.bShowObjectives=1;
		ThAddDefaultInventory(tpp);
	} else if (TeamNo==255) {
		tpp.bDontShowOnScores=true;
		tpp.MakeRat();
		tpp.ClientMakeRat();
		tpp.bPickedTeam=true;
		tpp.ClientShowObjectives(1);
	  tpp.bShowObjectives=1;
	  ThieveryDeathMatchPlus(tpp.Level.Game).ThAddDefaultInventory(tpp);
	}
}

// called whenever a human player select which team he wants to join, if false the button doesn't work
function bool PlayerSelectedTeam(ThieveryPPawn player, int TeamNo, optional bool bQuiet) {
	local int i;
	local Pawn P;
	local TBaseBot bot;

	// grab the next map (can't seem to do it earlier as it grabs the previous map as the current url?)
	ThieveryGameReplicationInfo(GameReplicationInfo).NextMapName=FindNextMapName();

	if (CheckImbalance(TeamNo)) {
		if (TeamNo==0) {
			if (!bQuiet) player.ClientMessage("Too many thieves");
		} else {
			if (!bQuiet) player.ClientMessage("Too many guards");
		}
		return false;
	}

	if (TeamNo==0) { // thief
		if( Level.NetMode==NM_DedicatedServer || Level.NetMode==NM_ListenServer )
		{
		    i=GetThiefLivesForIP(player);
		    if (i != -1) {
			    player.PlayerLives=i;
		    } else {
		        player.PlayerLives = InitialLives + LivesPerWave * wave;
		    }
		    ThieveryPlayerReplicationInfo(player.PlayerReplicationInfo).PlayerLives = player.PlayerLives;
		    if (IRCLink!=none)
		         IRCLink.ThSendText("", player.PlayerReplicationInfo.PlayerName$" has joined the Thieves");
			BroadcastMessage( player.PlayerReplicationInfo.PlayerName$" has joined the Thieves", false );
		}
		return true;
	} else if (TeamNo==1) { // guard
		i=0;
		// count bots
		foreach AllActors(class'TBaseBot',bot) {
			if ((bot.PlayerReplicationInfo.Team==1) && (bot.bPlayerCanInhabit) && (bot.Health>0) && (!bot.PlayerReplicationInfo.bWaitingPlayer)) i++;
		}
		// subtract waiting human players
		if ( bRequireReady && (CountDown > 0) ) {
			for ( P=Level.PawnList; P!=None; P=P.NextPawn ) {
				if ((P.IsA('ThieveryPPawn')) && (P.PlayerReplicationInfo!=none) && (P.PlayerReplicationInfo.Team==1)) {
					i--;
				}
			}
		}
		if (i>0) {
			if( Level.NetMode==NM_DedicatedServer || Level.NetMode==NM_ListenServer )
			{
				BroadcastMessage( player.PlayerReplicationInfo.PlayerName$" has joined the Guards", false );
				if (IRCLink!=none)
			     IRCLink.ThSendText("", player.PlayerReplicationInfo.PlayerName$" has joined the Guards");
			}
			return true;
		} else {
			if (!bQuiet) player.ClientMessage("Guard team is full");
			return false;
		}
	} else if (TeamNo==255) { // rat
		if( Level.NetMode==NM_DedicatedServer || Level.NetMode==NM_ListenServer )
			BroadcastMessage( player.PlayerReplicationInfo.PlayerName$" is spectating", false );
	}
	return true;
}

// Checks if you're allowed to respawn:
// For thieves this means checking if your team has lives left
// For guards this means checking if there are any AI left to inhabit
function bool ThieveryPawnAllowedToRespawn(ThieveryPPawn P) {
	local int numberOfPossibleGuards;
	local TBaseBot bot;

	if (P.PlayerReplicationInfo.Team==0) { // if you're a thief
		if (P.PlayerLives > 0) {
			return true;
		}
	} else if (P.PlayerReplicationInfo.Team==1) { // if you're a guard
		// find the number of possible bots to inhabit
		numberOfPossibleGuards=0;
		foreach AllActors(class'TBaseBot',bot) {
			if ((bot.PlayerReplicationInfo.Team==1) && (bot.bPlayerCanInhabit) && (bot.Health>0) && (!bot.PlayerReplicationInfo.bWaitingPlayer)) numberOfPossibleGuards++;
		}
		if (numberOfPossibleGuards>0) {
			return true;
		}
	}
	return false;
}

//
// Restart a player.
//
function bool RestartPlayer( pawn aPlayer )
{
	local NavigationPoint startSpot;
	local bool foundStart;

	if( bRestartLevel && Level.NetMode!=NM_DedicatedServer && Level.NetMode!=NM_ListenServer )
		return true;

	if (ThieveryProPawn(aPlayer) != none && aPlayer.PlayerReplicationInfo.Team == 0 && ThieveryProPawn(aPlayer).PlayerLives == 0)
        return true;

	startSpot = FindPlayerStart(aPlayer, 255);	// Side effect if team==1, kills AI on map for you to take
	if( startSpot == None )
	{
		return false;
	}

	if (GoingToFragSomeone(aPlayer, startSpot)) {
		startSpot=PreventTelefragging(aPlayer, startSpot);
	}

	foundStart = aPlayer.SetLocation(startSpot.Location);

	if( foundStart )
	{
		startSpot.PlayTeleportEffect(aPlayer, true);
		if (aPlayer.PlayerReplicationInfo.Team==0) {	// if a thief, use up one of your team's lives
			UseUpALife(aPlayer);
		}
		if (aPlayer.IsA('ThieveryPPawn')) {
			ThieveryPPawn(aPlayer).ResetWeapons();
			ThieveryPPawn(aPlayer).ResetPlayerEffects();
			if (aPlayer.PlayerReplicationInfo.Team == 1) {
		      AddGuardIP(ThieveryPPawn(aPlayer));
		  }
		}
		aPlayer.SetRotation(startSpot.Rotation);
		aPlayer.ViewRotation = aPlayer.Rotation;
		aPlayer.Acceleration = vect(0,0,0);
		aPlayer.Velocity = vect(0,0,0);
		if (aPlayer.Health<=0) {
			if (aPlayer.IsA('ThieveryPPawn')) {
				aPlayer.Health = ThieveryPPawn(aPlayer).MaxHealth;
			} else {
				aPlayer.Health = aPlayer.default.Health;
			}
		}

		// rats are non solid - 1.3: making them solid
		//if (aPlayer.PlayerReplicationInfo.Team!=255)
		aPlayer.SetCollision( true, true, true );
		aPlayer.ClientSetLocation( startSpot.Location, startSpot.Rotation );
		aPlayer.bHidden = false;
		aPlayer.DamageScaling = aPlayer.Default.DamageScaling;
		aPlayer.SoundDampening = aPlayer.Default.SoundDampening;
		AddDefaultInventory(aPlayer);
	}

	if ( aPlayer.IsA('TournamentPlayer') )
		TournamentPlayer(aPlayer).StartSpot = LastStartSpot;

	if (aPlayer.IsA('PlayerPawn')) {
		if (aPlayer.Region.Zone.IsA('ThieveryZoneInfo') && ThieveryZoneInfo(aPlayer.Region.Zone).Song!=none)
			PlayerPawn(aPlayer).ClientSetMusic( ThieveryZoneInfo(aPlayer.Region.Zone).Song, ThieveryZoneInfo(aPlayer.Region.Zone).SongSection, ThieveryZoneInfo(aPlayer.Region.Zone).CDTrack, ThieveryZoneInfo(aPlayer.Region.Zone).MusicTransition );
		else
			PlayerPawn(aPlayer).ClientSetMusic( Level.Song, Level.SongSection, Level.CdTrack, MTRAN_Fade );
	}

	return foundStart;
}

function ServerRestartThieveryPawn(ThieveryPPawn P) {
	if ( (P.bFrozen && (TimerRate>0.0)) || (Level.NetMode == NM_Client) )
		return;

	if (ThieveryPawnAllowedToRespawn(P)) {
		DestroyAllTraps(P);
		// normal respawn
		if (RestartPlayer(P)) {
		    P.BehindView(false);
			ThAddDefaultInventory(P);
			P.ServerTimeStamp = 0;
			P.TimeMargin = 0;
			P.Enemy = none;
			if (P.Mesh!=none)
				P.PlayWaiting();
			// restarts level in single player mode
			if (Level.NetMode!=NM_DedicatedServer && Level.NetMode!=NM_ListenServer && bRestartLevel) {
				P.ClientTravel( "?restart", TRAVEL_Relative, false );
			}
			P.ClientReStart();		// moves client into restartstate
			// send the player into a personal buying state
			P.bNoWaitingForOthers=true;
			// reset some stuff to prevent half-rattyness
			if (P.PlayerReplicationInfo.Team==0) {
				P.MakeThief();
				P.ClientMakeThief();
			} if (P.PlayerReplicationInfo.Team==1) {
				P.MakeGuard();
				P.ClientMakeGuard();
			}
			P.GotoState('PlayerWaiting');
		}
	} else if (p.PlayerReplicationInfo.team == 0 && wave < Waves) {
       ThieveryProPawn(P).MakeTeamSpectator();
       ThieveryProPawn(P).ClientMakeTeamSpectator();
	   P.ResetPlayerEffects();
	} else {
		// you're a rat, buddy
		if (P.PlayerReplicationInfo.Team==0) DistributeLoot+=P.Loot;
		if (P.PlayerReplicationInfo.Team!=255) {
			P.OldTeam=P.PlayerReplicationInfo.Team;
		}
		if (RestartPlayerAsRat(P)) {
			P.ClientMessage("You are spectating as a rat");
			//P.bAlwaysRelevant=true;
			P.MakeRat();
			P.ClientMakeRat();
			P.ResetPlayerEffects();
			if ( P.Mesh != None )
				P.PlayWaiting();
			// restarts level in single player mode
			if (Level.NetMode!=NM_DedicatedServer && Level.NetMode!=NM_ListenServer && bRestartLevel) {
				P.ClientTravel( "?restart", TRAVEL_Relative, false );
			}
			P.ClientReStart();		// moves client into restartstate
			// Convince those awkward players that you're a rat,
			// and not, in fact, a thief buried in the ground up to his knees.
			// That squeaks.
			ExplicitlySetPlayersRatMesh(P);
			P.GotoState('PlayerWaiting');
			//1.3: making rats solid
			//P.SetCollision(false,false,false);
			P.SetCollision(true, true, true);
			if (class'ThieveryGameSettings'.default.bRememberSpectators) AddSpectatorIP(P);
		}
	}
}

function InitGameReplicationInfo()
{
    local ThProGRI gri;

    super.InitGameReplicationInfo();

    gri = ThProGRI(GameReplicationInfo);
    gri.usingWaves = true;
    gri.wave = 0;
    gri.totalWaves = waves;
    gri.livesPerWave = livesPerWave;
}

// Calculate Wave time
function StartMatch()
{
    local ThProGRI gri;

    super.StartMatch();

    gri = ThProGRI(GameReplicationInfo);
    waveTime = (timeLimit * 60) / (waves + 1);
    nextWaveTime = remainingTime - waveTime;
    gri.nextWaveTime = nextWaveTime;
}

function Timer()
{
	local Pawn P;
	local bool bReady;
	local int M, increase;
	local ThieveryGameSettings t;
	local ThieveryObject ChosenObject;
	local AttachedSmallAuraGenerator g;
	local int i;

	// **** RESPAWNING LOOT ******

	// FIX MIGHT ADD LOOT TO AN ITEM THAT'S BEEN STOLEN! (can it? don't they get destoryed? yes they do...)
	if ((DistributeLoot>0) && (StolenLoot!=none)) {
		CheckForDistLoot--;
		if (CheckForDistLoot<0) {
			if (LastRespawned!=none && LastRespawned.LootValue<=LastRespawned.default.LootValue) {
				increase=LastRespawned.default.LootValue-LastRespawned.LootValue;
				if (increase>DistributeLoot)
					increase=DistributeLoot;
				LastRespawned.LootValue+=increase;
				DistributeLoot-=increase;
				if (DistributeLoot<0) DistributeLoot=0;
				//LastRespawned.LootValue+=DistributeLoot;
				//if (LastRespawned.LootValue>LastRespawned.default.LootValue) {
//					DistributeLoot=LastRespawned.LootValue-LastRespawned.default.LootValue;
				//} else {
//					DistributeLoot=0;
				//}
			}
			if (DistributeLoot>0) {
				do {		// loop to respawn all loot that you can
					ChosenObject=RedistributeSomeLoot();
					log("respawned "$ChosenObject$" DistributeLoot="$DistributeLoot);
					if (ChosenObject!=none) LastRespawned=ChosenObject;
				} until (DistributeLoot<=0 || ChosenObject==none);
				// if couldn't distribute the loot into new items, put it all into the last respawned item
				if (ChosenObject==none && LastRespawned!=none && DistributeLoot>0) {
					log("no object and still some loot left");
					if (!LastRespawned.bHidden && LastRespawned.bFrobbable && LastRespawned.LootValue>0) {
						// throw all remaining loot on this item
						log("Throwing all remaining loot onto "$LastRespawned);
						LastRespawned.LootValue+=DistributeLoot;
						DistributeLoot=0;
						// spawn a fancy marker on this loot to indicate this item is VALUABLE
						if (LastRespawned.LootValue>=500) {
							g=spawn(class'AttachedSmallAuraGenerator',,,LastRespawned.Location);
							g.AttachTo(LastRespawned);
						}
					}
				}
			}
			CheckForDistLoot=5;	// respawn items of loot every 5 seconds
		}
	}

	super(TournamentGameInfo).Timer();

	if ( bRequireReady && (CountDown > 0) ) {		// if the game hasn't started yet
		CountUpPlayersForScoreboard();
		// ****** SINGLE PLAYER STARTING *****
		if (Level.NetMode == NM_Standalone) {
			if (HumansReadyToPlay()) {
				// set misc flags
				bReady=true;
				CountDown=0;
		  	ThieveryCountDown=0;
		  	bReady=true;
		  	bNetReady=true;
		  	bRequireReady = false;

		  	// start the game
				StartMatch();
			}
		} else {
		  // **** NETGAME STARTING ****
		  if (bNoNominations) {		// if there's no nominating going on, game starts as soon as someone is ready
		  	for (P=Level.PawnList; P!=None; P=P.NextPawn ) {
					if ( P.IsA('ThieveryPPawn') ) {
						//if (PlayerPawn(P).bReadyToPlay ) {

				  		// set misc ready flags
				  		CountDown=0;
				  		ThieveryCountDown=0;
				  		bReady=true;
				  		bNetReady=true;
				  		bRequireReady = false;

							ExplicitlySetPlayerMeshes();

				  		// start the game
				  		log(self$" starting match in no nominations bit of timer");
				  		StartMatch();
				  	//}
			  	}
			  }
		  } else {
			  if (!bStartedThieveryCountDown) {		// start the countdown when 1 player has nominated a team
					if (AtLeastOnePlayerHasNominated()) {

			  		bStartedThieveryCountDown=true;
			  		ThieveryCountDownDuration=class'ThieveryGameSettings'.default.nPregameWaitTime;
			  		ThieveryCountDown=ThieveryCountDownDuration;
			  	}
			  } else {			// count down, when reach zero, start the game
			  	for (P=Level.PawnList; P!=None; P=P.NextPawn )
						if ( P.IsA('PlayerPawn') )
							PlayerPawn(P).SetProgressTime(ThieveryCountDown);
					ThieveryCountDown--;
			  	if (ThieveryCountDown<=0) {

			  		// set misc ready flags
			  		CountDown=0;
			  		ThieveryCountDown=0;
			  		bReady=true;
			  		bNetReady=true;
			  		bRequireReady = false;

						ExplicitlySetPlayerMeshes();

			  		// start the game
			  		StartMatch();
			  	}
			  }
			}
		}
	}
	else			// game in progress
	{
		// ****** FORCING RESPAWNS ***********
		if ( bAlwaysForceRespawn || (bForceRespawn && (Level.NetMode != NM_Standalone)) )
			For ( P=Level.PawnList; P!=None; P=P.NextPawn )
			{
				if ( P.IsInState('Dying') && P.IsA('PlayerPawn') && P.bHidden )
					PlayerPawn(P).ServerReStartPlayer();
			}
		// ***** END GAME WAIT **********
		if ( bGameEnded )
		{
			if (Level.NetMode==NM_Standalone) {
				if ( Level.TimeSeconds > EndTime + RestartWait )
					RestartGame();
			} else {
				if ( ( Level.TimeSeconds > EndTime + MultiplayerRestartWait ) || (AllPlayersReadyForNextMap()) )
					RestartGame();
			}
		}
		else if ( !bOverTime && (TimeLimit > 0) )
		{
			// ***** COUNTDOWN TIME & TIMELIMIT HITS ********
			GameReplicationInfo.bStopCountDown = false;
			RemainingTime--;
			GameReplicationInfo.RemainingTime = RemainingTime;
			if (RemainingTime % class'ThieveryGameSettings'.default.ScoreUpdateInterval == 0)
				CSportsScores();
			if ( RemainingTime % 60 == 0 ) {
				GameReplicationInfo.RemainingMinute = RemainingTime;
			}
			if ( RemainingTime <= 0 ) {	// time limit hit, make a team win
				NotifyDalai("RemainingTime:"$RemainingTime$" TimeLimit:"$TimeLimit);
				t=GetThieveryGameSettings();
				if (t!=none) {
					if (t.TeamWinsOnTimeLimit==0) {
						EndGame("team0wins");
					} else {
						MissionSuccess(1);
					}
				} else {
					MissionSuccess(1);
				}
			}

			// Waves
			if (remainingTime == nextWaveTime + 60)
			{
		          BroadcastLocalizedMessage(class'ThProWaveTimeMessage', 0);
			} else if (remainingTime == nextWaveTime + 5) {
			      BroadcastLocalizedMessage(class'ThProWaveTimeMessage', 1);
            } else if (remainingTime == nextWaveTime + 3) {
			      BroadcastLocalizedMessage(class'ThProWaveTimeMessage', 2);
            } else if (remainingTime == nextWaveTime + 2) {
			      BroadcastLocalizedMessage(class'ThProWaveTimeMessage', 3);
            } else if (remainingTime == nextWaveTime + 1) {
			      BroadcastLocalizedMessage(class'ThProWaveTimeMessage', 4);
            } else if (remainingTime == nextWaveTime) {
                  // New Wave
                  BroadcastLocalizedMessage(class'ThProWaveTimeMessage', 5);
                  // Give everyone the new lives
                  for (i = 0; i < 64; i++)
                  {
                       if ((Len(thiefIP[i]) > 0)) thiefLives[i]++;
                  }
                  for (P=Level.PawnList; P!=None; P=P.NextPawn )
                  {
                       if (ThieveryProPawn(P) != none && P.PlayerReplicationInfo.Team == 0)
                       {
                            ThieveryProPawn(p).PlayerLives += LivesPerWave;
               			    ThieveryPlayerReplicationInfo(p.PlayerReplicationInfo).PlayerLives = ThieveryProPawn(P).PlayerLives;
                            if (p.PlayerReplicationInfo.bIsSpectator)
                            {
                                ServerRestartThieveryPawn(ThieveryProPawn(p));
                            }
                       }
                  }
                  wave++;
                  if (wave < Waves)
                  {
                       nextWaveTime = RemainingTime - waveTime;
                  }
                  ThProGRI(GameReplicationInfo).wave = wave;
                  ThProGRI(GameReplicationInfo).nextWaveTime = nextWaveTime;
            }
		}
		else
		{
			// ***** COUNTING UP TIME FOR NO TIMELIMIT GAMES ************
			ElapsedTime++;
			GameReplicationInfo.ElapsedTime = ElapsedTime;
			if (ElapsedTime % class'ThieveryGameSettings'.default.ScoreUpdateInterval == 0)
				CSportsScores();
		}
	}
	// change maps if it is empty for VacantMapTime mins
	if (bChangeLevels && (Level.TimeSeconds>=VacantMapTime*60) && Vacant()) {
		RestartGame();
	}
}

function CheckIfWholeTeamIsDead(int TeamNumber) {	// called everytime someone dies
    local Pawn p;
    local ThieveryProPawn tpp;
    local bool allKilled;
    allKilled=true;

    if (teamNumber != 0) {
        super.CheckIfWholeTeamIsDead(TeamNumber);
        return;
    }

    for (p = level.PawnList; p != none; p = p.nextPawn)
    {
        tpp = ThieveryProPawn(p);
        if (tpp != none && tpp.PlayerReplicationInfo != none && tpp.PlayerReplicationInfo.Team == TeamNumber) {
            if (tpp.PlayerLives > 0 || tpp.health > 0) {
                allKilled=false;
                break;
            }
        }
    }

	if (allKilled) {	// all dead, other team wins
		if (wave < waves)
		{
		      if (remainingTime > nextWaveTime + 8)
		      {
		          BroadcastLocalizedMessage(class'ThProWaveTimeMessage', 6);
                  remainingTime = nextWaveTime + 8;
              }
		}
		else
		{
		      MissionSuccess(1);	// guards get the 10 OP bonus
		}
	}
}


function AddThiefIP(thieveryppawn tpp) {
	local string IP;
	local int i;

	IP = tpp.GetPlayerNetworkAddress();
	IP = Left(IP, InStr(IP, ":"));

	for (i=0;i<64;i++) {
		if (ThiefIP[i]==IP) {
			ThiefLives[i]=tpp.PlayerLives;
			return;
		} else if (ThiefIP[i]=="") {
			ThiefIP[i]=IP;
			ThiefLives[i]=tpp.PlayerLives;
			return;
		}
	}
}

function int GetThiefLivesForIP(ThieveryPPawn P) {
	local string IP;
	local int i;

	IP = P.GetPlayerNetworkAddress();
	IP = Left(IP, InStr(IP, ":"));

	if (IP=="") return -1;	// singleplay games have no IP

	for (i=0;i<64;i++) {
		if (ThiefIP[i]==IP) {
			return ThiefLives[i];
		}
	}
	return -1;
}

function bool IsThiefIP(PlayerPawn P) {
	local string IP;
	local int i;

	IP = P.GetPlayerNetworkAddress();
	IP = Left(IP, InStr(IP, ":"));

	if (IP=="") return false;

	for (i=0;i<64;i++) {
		if (ThiefIP[i]==IP) {
            return true;
		}
	}
	return false;
}

function bool IsGuardIP(PlayerPawn P) {
	local string IP;
	local int i;

	IP = P.GetPlayerNetworkAddress();
	IP = Left(IP, InStr(IP, ":"));

	if (IP=="") return false;

    for (i=0;i<64;i++) {
		if (GuardIP[i]==IP) {
			return true;
		}
	}
	return false;
}

function AddGuardIP(thieveryppawn tpp) {
	local string IP;
	local int i;

	IP = tpp.GetPlayerNetworkAddress();
	IP = Left(IP, InStr(IP, ":"));

	for (i=0;i<64;i++) {
		if (GuardIP[i]==IP) {
			return;
		} else if (GuardIP[i]=="") {
			GuardIP[i]=IP;
			return;
		}
	}
}

DefaultProperties
{
    InitialLives=1
    LivesPerWave=1
    Waves=1
    wave=0
    HUDType=Class'ThProHUD'
    GameReplicationInfoClass=Class'ThProGRI'
    ScoreBoardType=Class'ThProScoreBoard'
    GameName="Thievery Pro: Thieves vs Guards"
}