//-----------------------------------------------------------
// ThieveryProMod - ThProPlayerLoadouts by Immortius
// Copy of ThPlayerLoadouts that ensures gives players a separate
// loadout set on pro servers.
//-----------------------------------------------------------
class ThProPlayerLoadouts expands ThPlayerLoadouts;

var() config string ItemClasses[256];
var string promodItemPrefix;

// steps through a specified loudout, trying to buy all the items listed in it
// Changed: ProMod items saved with ProMod prefix, and loaded the same
function BuyLoadout(ThieveryPPawn P, int i, ThieveryShop shop) {
	local int n, amount, index;
	local string ItemClassString;
	local class<Inventory> ItemClass;
	local string package;
	if (i<0 || i>7) return;

	package = string(P.class);
	package = Left(package, InStr(package, "."));

	P.ResetToDefaultInventory();	// tell the server to clear the items

	index=i*32;
	for (n=0;n<32;n++) {
		if (ItemClasses[index+n]!="") {
			// buy in quantity, where quantity = surplus and cost = surplus*cost/number you get per buy in the shop
            ItemClassString = ItemClasses[index+n];
            if (Left(ItemClassString, Len(promodItemPrefix) + 1) ~= (promodItemPrefix $ "."))
            {
                ItemClassString = package $ Right(ItemClassString, Len(ItemClassString) - Len(promodItemPrefix));
            }
            ItemClass=class<Inventory>(DynamicLoadObject(ItemClassString, class'Class'));
			P.SafeLoadoutBuyItem(ItemClass, Quantity[index+n]);
		}
	}
}

// saves the player's current inventory to this loadout slot
function SaveLoadout(ThieveryPPawn P, int i) {
	local Inventory o;
	local int n,g,index;
	local string ItemClass;
	local string package;

    package = string(P.class);
	package = Left(package, InStr(package, "."));

	index=i*32;
	// clear this loadout slot
	for (n=0;n<32;n++) {
		Item[index+n]="";
		Quantity[index+n]=0;
	}
	n=0;

	// put player's inventory in instead
	for (o=P.Inventory;o!=none;o=o.Inventory) {
		if (n<32 && !o.IsA('ThPickupSupplyChest')) {
		    Item[index+n] = string(o.class);
			ItemClass=string(o.class);
			if (Left(ItemClass, Len(package) + 1) ~= (package $ "."))
			{
		        ItemClass = promodItemPrefix $ Right(ItemClass, Len(ItemClass) - Len(package));
			}
			ItemClasses[index+n] = ItemClass;
			if (o.IsA('Ammo')) {
				Quantity[index+n]=Ammo(o).AmmoAmount;
			} else if (o.IsA('Pickup')) {
				Quantity[index+n]=Pickup(o).NumCopies+1;
			} else {
				Quantity[index+n]=1;
			}
			n++;
		}
		g++;
		if (g>100) break;
	}
	SaveConfig();
}

function int getQuantity(int i) {
	return Quantity[i];
}

DefaultProperties
{
    promodItemPrefix="ThProItem"
}