class FixQSGMutator expands Mutator
	config;

// By dma (http://student-www.uncc.edu/~danderse/)

// This little beauty is dedicated to all the losers who cheat using
// the Quantum Singularity Generator.  If the cause of death is
// 'Suicided', then this mutator assumes the user to be cheating.
// In any case, players are NOT left invulnerable after dying with
// the shield up unless they were already invulnerable.

// This mutator must be placed above any "terminating" mutators (like
// the Zombie one).  I recommend placing it above U4E.

var config bool bNoTossQSG;					// Do not allow players to use "throwweapon"
											//   with the QSG.

var config bool bClientCheatBanner;			// Do we want the cheater to see a banner
											//   Message on his screen?

var config string ClientCheatBannerText;	// This is placed in big letters on the client's
											//   screen for 4 seconds.

var config int CheatPenalty;				// This is the score penalty for cheating.
											//   It is subtracted from the player's current
											//   score.
											
var config bool bNotifyOthers;				// Do we want to notify other players of the
											//   cheat attempt?

var config string NotifyString;				// This string is broadcast to all players.
											//   '%k' is replaced with the cheater.


// From ScrollingMessageTexture.uc, without the "simulated" attribute.
function string Replace(string Text, string Match, string Replacement)
{
	local int i;
	
	i = InStr(Text, Match);	

	if(i != -1)
		return Left(Text, i) $ Replacement $ Replace(Mid(Text, i+Len(Match)), Match, Replacement);
	else
		return Text;
}

// This is the heart of the mutator.  It is called whenever a Pawn dies, if the mutator
// list is configured properly.

function bool PreventDeath(Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{
	local name RedDamType;		// Previous value of Pawn's ReducedDamageType
								//   (in case another mutator changes it.)
	
	if ((QSG(Killed.Weapon) != None) && (!QSG(Killed.Weapon).bAlreadyGod)) {
		RedDamType=Killed.ReducedDamageType;	// If this is 'All', then the guy's shield is up.  
												//   I could use Killed.Weapon.IsInState('altfiring'),
												//   but I don't trust it.
		
		
		// Maybe a mutator further down the chain will prevent this guy
		//   from dying.  If so, then we have nothing to worry about.
		
		if ( NextMutator != None )
			if (NextMutator.PreventDeath(Killed,Killer, damageType,HitLocation))
				return true;				// We stop.  He's gonna live after all.
		
		
		// If we're here, then the guy is going to die.  Let's make sure he doesn't remain
		// invulnerable.
		
		if (RedDamType == 'All') {
			Killed.ReducedDamageType = 'None';			// No longer invulnerable.
			
			if (damageType == 'Suicided' ) {
				// Draw the cheat banner.
				if (bClientCheatBanner) {
					PlayerPawn(Killed).ClearProgressMessages();
					PlayerPawn(Killed).SetProgressTime(4);
					PlayerPawn(Killed).SetProgressMessage(ClientCheatBannerText,0);
				}

				// Penalize the player.  CheatPenalty can be set to zero to disable
				//   this feature.
				
				Killed.PlayerReplicationInfo.Score -= CheatPenalty;
				
				// Broadcast it to the world.
				if (bNotifyOthers) {
					BroadcastMessage(Replace(NotifyString, "%k", Killed.PlayerReplicationInfo.PlayerName), true);
				}
			}
			return false;		// This means we DIDN'T prevent this player's death.
		}
	} else {
		// Either the guy isn't holding a QSG, it isn't altfiring, 
		//   or he was already in god mode.
		if ( NextMutator != None )
			return NextMutator.PreventDeath(Killed,Killer, damageType,HitLocation);
	}			
	return false;				// This means we DIDN'T prevent this player's death.
}

// This code is from InstantRockets.uc

function bool AlwaysKeep(Actor Other)
{
	if ( Other.IsA('QSG') && bNoTossQSG )
		Weapon(Other).bCanThrow=false;
	if ( NextMutator != None )
		return ( NextMutator.AlwaysKeep(Other) );
	return false;
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	if ( Other.IsA('QSG') && bNoTossQSG )
		Weapon(Other).bCanThrow=false;
	return true; 
}

defaultproperties
{
	bNoTossQSG=true
	bClientCheatBanner=true
	ClientCheatBannerText="L O S E R ! ! !"
	CheatPenalty=10
	bNotifyOthers=true
	NotifyString="%k attempted to cheat!!!"	
}
