<?php

/*
    UT2003 Remote Logger
    Copyright (C) 2003  Paul Gallier

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

function LogListen($port)
{
  if (($socket = socket_create(AF_INET, SOCK_STREAM, getprotobyname("TCP"))) === FALSE)
    die("Error creating socket: ".socket_last_error()." - ".socket_strerror(socket_last_error())."\n");
  if (socket_bind($socket, "0.0.0.0", $port) === FALSE)
    die("Error binding to port $port: ".socket_last_error()." - ".socket_strerror(socket_last_error())."\n"); 
  if (socket_listen($socket) === FALSE)
    die("Error listening on port $port: ".socket_last_error()." - ".socket_strerror(socket_last_error())."\n"); 

  echo "Listening for UT2003 logs on port $port....\n";
  $exit = 0;
  $f = "";
  do {
    $fd = socket_accept($socket);
    LogSave($fd, $port);
  } while (!$exit);
}

function LogSave($fd, $port)
{
  $socketclosed = 0;
  do {
    $data = socket_read($fd, 4096, PHP_BINARY_READ);
    if ($data == "")
      $socketclosed = 1;
    else {
      $tok = strtok($data, "\t");
      if ($tok != "") {
        $tok = strtok("\t");
        if ($tok == "NG") {
          $tok = strtok("\t");
          if ($tok != "") {
            $logname = "UTLog_".$port."_".$tok.".txt";
            for ($i = 0; $i < strlen($logname); $i++)
              if ($logname[$i] == ':' || $logname[$i] == ' ')
                $logname[$i] = '_';
            if ($f != "")
              fclose($f);
            $f = fopen($logname, 'w');
            echo "Created new log file: $logname\n";
          }
        }
      }
      if ($f != "")
        fwrite($f, $data);
    }
  } while(!$socketclosed);
  if ($f != "")
    fclose($f);
}


if ($argc == 2)
  $port = intval($argv[1]);
else {
  echo "UT2003 Remote Logger v0.3\n";
  echo "Usage: rlog <port number>\n";
  exit;
}

LogListen($port);

?>