<?php

/* ftp_class_curl.php for UTStats
   adds support for retrieving logfiles over ftp and sftp using php5-curl

   Version: 01
   - Basic setup
*/

class ftp {
	var $lastmsg;
	var $url;
	var $fullhost;
	var $transfertype;
 	var $errors = array();
		
	function SetServer($host, $port) {
		$url = preg_replace("/\/+$/", "", $host);
		
		if (!preg_match("/^\w+:\/\//", $url)) {
		      $url = "ftp://" . $url;
		}

		$url .= ":$port/";
		$this->url = parse_url($url);

		$this->sendmsg("Connect to: $url\n");

		if (!is_long($port)) {
			$this->sendmsg("Incorrect port syntax\n");
			return(false);
		} else {
			$ip=@gethostbyname($host);
			$dns=@gethostbyaddr($host);
			if(!$ip) $ip = $host;
			if(!$dns) $dns = $host;
			if(ip2long($ip) === -1) {
				$this->sendmsg("Wrong host name/address \"".$host."\"");
				return(false);
			}
		$this->fullhost = $dns;
		}
		$this->sendmsg("\n");
		return(true);
	}
	
	function connect() {
		if (!function_exists('curl_init')) {
			$this->sendmsg("No cURL support in this php build!\n\n");
			return(false);
		}

		// Connection will be checked while logging in, extra try is enough.
		return(true);
	}
	function login($user, $pass) {
		// Not required but let's try anyway
		$this->url['user'] = $user;
		$this->url['pass'] = $pass;

		$this->sendmsg("Login as " . $user . "\n");

		$url = http_build_url("foo", $this->url);
		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$result = curl_exec($ch);

		if ($result === false) {
		      $this->sendmsg(curl_error($ch) . "\n");
		      $this->connected = false;
		      curl_close($ch);
		      return false;
		}

		curl_close($ch);

		$this->connected = true;
		$this->sendmsg("\n");
		return true;
	}
	
	function SetType($transfertype) {
		// not used at the moment
		$this->transfertype = $transfertype;
		return(true);
	}
	
	function Passive($pasv) {
		// not used at the moment
		$this->passive = $pasv;
		$this->sendmsg("Set passivemode: " . $pasv . " (does nothing)\n");

		return(true);
	}
	
	function pwd() {
		// no need to connect to return the path
		if (!$this->connected) {
		      $this->sendmsg("No connection\n");
		      return false;
		}
		$this->sendmsg("Current working dir: " . $this->url['path'] . "\n");
		return $this->url['path'];
	}
	
	function chdir($dir) {
		$this->sendmsg("\nChangedir to $dir\n");
		if (!$this->connected) {
		      $this->sendmsg("No connection\n");
		      return false;
		}
		$oldpath = $this->url['path'];
		// it actually has to end with a /
		if (substr($dir, -1, 1) != "/") {
		      $dir .= "/";
		}
		$this->url['path'] = $dir;

		// test
		$url = http_build_url("foo", $this->url);
		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$result = curl_exec($ch);

		if ($result === false) {
			$this->url['path'] = $oldpath;
			$this->sendmsg("Failed: " . curl_error($ch) . "\n");
			echo curl_error($ch);
			curl_close($ch);
			return false;
		}
		curl_close($ch);
		return true;
	}
	
	function nlist() {
		$this->sendmsg("Get directory listing\n");
		if (!$this->connected) {
		      $this->sendmsg("No connection\n");
		      return false;
		}
		$url = http_build_url("foo", $this->url);
		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_FTPLISTONLY, 1);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$result = curl_exec($ch);

		if ($results === false) {
		      $this->sendmsg("Failed: " . curl_error($ch) . "\n");
		      return false;
		}

		curl_close($ch);

		$this->sendmsg($result . "\n");

		$files = explode("\n", $result);

		return $files;
	}
	
	function get($remotefile, $localfile) {
		$this->sendmsg("Download $remotefile\n");
		if (!$this->connected) {
		      $this->sendmsg("No connection\n");
		      return false;
		}

		// save the path, we'll need to reset it later!
		$oldpath = $this->url['path'];

		// if localfile isn't set use the remote filename and the current working dir
		if (empty($localfile)) {
		      $localfile = pathinfo($remotefile, PATHINFO_BASENAME);
		}

		// check if the current file is absolute or relative
		if (substr($remotefile,0, 1) != "/") {
		      $this->url['path'] .= $remotefile;
		}
		else {
		      $this->url['path'] = $remotefile;
		}

		// open the filehandle
		$fh = fopen($localfile, "w");
		if ($fh === false) {
		      $this->sendmsg("Failed: Can't open local file for writing\n");
		      return $false;
		}

		// get the file
		$url = http_build_url("foo", $this->url);
		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_FILE, $fh);
		$result = curl_exec($ch);

		if ($result === false) {
			$this->sendmsg("Failed: " . curl_error($ch) . "\n");
			curl_close($ch);
			return false;
		}

		curl_close($ch);
		fclose($fh);

		// reset the path
		$this->url['path'] = $oldpath;

		$size = filesize($localfile);
		$this->sendmsg("Size: $size\n");

		return $size;
	}

	function delete($remotefile) {
		$this->sendmsg("Delete: $remotefile\n");
		if (!$this->connected) {
		      $this->sendmsg("No connection\n");
		      return false;
		}

		// remove the file
		$url = http_build_url("foo", $this->url);
		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		if ($this->url['scheme'] == 'ftp') {
			curl_setopt($ch, CURLOPT_QUOTE, array("DELE " . $this->url['path'] . $remotefile));
		}
		else if ($this->url['scheme'] == 'sftp') {
			curl_setopt($ch, CURLOPT_QUOTE, array("rm " . $this->url['path'] . $remotefile));
		}
		else {
		      $this->sendmsg("Failed: Protocol not supported");
		      curl_close($ch);
		      return false;
		}
		$result = curl_exec($ch);

		if ($result === false) {
		      $this->sendmsg("Failed: " . curl_error($ch) . "\n");
		      curl_close($ch);
		      return false;
		}

		curl_close($ch);

		return true;
	}
	
	
	function quit() {
		$this->sendmsg("Close connection\n");
		return(true);
	}

	function sendmsg($msg) {
		global $ftp_debug ;
		if ($ftp_debug) {
		      echo $msg;
		}
	}

	
	function PushError($fctname, $msg, $desc=false){
		$error=array();
		$error['time']=time();
		$error['fctname']=$fctname;
		$error['msg']=$msg;
		$error['desc']=$desc;
		if($desc) $tmp=' ('.$desc.')'; else $tmp='';
		return(array_push($this->errors,$error));
	}
	
	function PopError(){
		if(count($this->errors)) return(array_pop($this->_error_array));
			else return(false);
	}	
}

if (!function_exists('http_build_url'))
{
	define('HTTP_URL_REPLACE', 1);				// Replace every part of the first URL when there's one of the second URL
	define('HTTP_URL_JOIN_PATH', 2);			// Join relative paths
	define('HTTP_URL_JOIN_QUERY', 4);			// Join query strings
	define('HTTP_URL_STRIP_USER', 8);			// Strip any user authentication information
	define('HTTP_URL_STRIP_PASS', 16);			// Strip any password authentication information
	define('HTTP_URL_STRIP_AUTH', 32);			// Strip any authentication information
	define('HTTP_URL_STRIP_PORT', 64);			// Strip explicit port numbers
	define('HTTP_URL_STRIP_PATH', 128);			// Strip complete path
	define('HTTP_URL_STRIP_QUERY', 256);		// Strip query string
	define('HTTP_URL_STRIP_FRAGMENT', 512);		// Strip any fragments (#identifier)
	define('HTTP_URL_STRIP_ALL', 1024);			// Strip anything but scheme and host
	
	// Build an URL
	// The parts of the second URL will be merged into the first according to the flags argument. 
	// 
	// @param	mixed			(Part(s) of) an URL in form of a string or associative array like parse_url() returns
	// @param	mixed			Same as the first argument
	// @param	int				A bitmask of binary or'ed HTTP_URL constants (Optional)HTTP_URL_REPLACE is the default
	// @param	array			If set, it will be filled with the parts of the composed url like parse_url() would return 
	function http_build_url($url, $parts=array(), $flags=HTTP_URL_REPLACE, &$new_url=false)
	{
		$keys = array('user','pass','port','path','query','fragment');
		
		// HTTP_URL_STRIP_ALL becomes all the HTTP_URL_STRIP_Xs
		if ($flags & HTTP_URL_STRIP_ALL)
		{
			$flags |= HTTP_URL_STRIP_USER;
			$flags |= HTTP_URL_STRIP_PASS;
			$flags |= HTTP_URL_STRIP_PORT;
			$flags |= HTTP_URL_STRIP_PATH;
			$flags |= HTTP_URL_STRIP_QUERY;
			$flags |= HTTP_URL_STRIP_FRAGMENT;
		}
		// HTTP_URL_STRIP_AUTH becomes HTTP_URL_STRIP_USER and HTTP_URL_STRIP_PASS
		else if ($flags & HTTP_URL_STRIP_AUTH)
		{
			$flags |= HTTP_URL_STRIP_USER;
			$flags |= HTTP_URL_STRIP_PASS;
		}
		
		// Parse the original URL
		$parse_url = parse_url($url);
		
		// Scheme and Host are always replaced
		if (isset($parts['scheme']))
			$parse_url['scheme'] = $parts['scheme'];
		if (isset($parts['host']))
			$parse_url['host'] = $parts['host'];
		
		// (If applicable) Replace the original URL with it's new parts
		if ($flags & HTTP_URL_REPLACE)
		{
			foreach ($keys as $key)
			{
				if (isset($parts[$key]))
					$parse_url[$key] = $parts[$key];
			}
		}
		else
		{
			// Join the original URL path with the new path
			if (isset($parts['path']) && ($flags & HTTP_URL_JOIN_PATH))
			{
				if (isset($parse_url['path']))
					$parse_url['path'] = rtrim(str_replace(basename($parse_url['path']), '', $parse_url['path']), '/') . '/' . ltrim($parts['path'], '/');
				else
					$parse_url['path'] = $parts['path'];
			}
			
			// Join the original query string with the new query string
			if (isset($parts['query']) && ($flags & HTTP_URL_JOIN_QUERY))
			{
				if (isset($parse_url['query']))
					$parse_url['query'] .= '&' . $parts['query'];
				else
					$parse_url['query'] = $parts['query'];
			}
		}
			
		// Strips all the applicable sections of the URL
		// Note: Scheme and Host are never stripped
		foreach ($keys as $key)
		{
			if ($flags & (int)constant('HTTP_URL_STRIP_' . strtoupper($key)))
				unset($parse_url[$key]);
		}
		
		
		$new_url = $parse_url;
		
		return 
			  ((isset($parse_url['scheme'])) ? $parse_url['scheme'] . '://' : '')
			.((isset($parse_url['user'])) ? $parse_url['user'] . ((isset($parse_url['pass'])) ? ':' . $parse_url['pass'] : '') .'@' : '')
			.((isset($parse_url['host'])) ? $parse_url['host'] : '')
			.((isset($parse_url['port'])) ? ':' . $parse_url['port'] : '')
			.((isset($parse_url['path'])) ? $parse_url['path'] : '')
			.((isset($parse_url['query'])) ? '?' . $parse_url['query'] : '')
			.((isset($parse_url['fragment'])) ? '#' . $parse_url['fragment'] : '')
		;
	}
}
