#include "shader_complexsurface.h"

Shader_ComplexSurface::Shader_ComplexSurface(ID3D10Device *device): Shader_Unreal(device)
{

}

bool Shader_ComplexSurface::compile(const D3D10_SHADER_MACRO *macros, DWORD shaderFlags)
{
	Shader_Unreal::compile(macros,shaderFlags);
	D3D10_INPUT_ELEMENT_DESC layoutDesc[] =
    {
		{ "POSITION",   0, DXGI_FORMAT_R32G32B32_FLOAT, 0, D3D10_APPEND_ALIGNED_ELEMENT,   D3D10_INPUT_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD",   0, DXGI_FORMAT_R32G32_FLOAT, 0, D3D10_APPEND_ALIGNED_ELEMENT,   D3D10_INPUT_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD",   1, DXGI_FORMAT_R32G32_FLOAT, 0, D3D10_APPEND_ALIGNED_ELEMENT,   D3D10_INPUT_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD",   2, DXGI_FORMAT_R32G32_FLOAT, 0, D3D10_APPEND_ALIGNED_ELEMENT,   D3D10_INPUT_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD",   3, DXGI_FORMAT_R32G32_FLOAT, 0, D3D10_APPEND_ALIGNED_ELEMENT,   D3D10_INPUT_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD",   4, DXGI_FORMAT_R32G32_FLOAT, 0, D3D10_APPEND_ALIGNED_ELEMENT,   D3D10_INPUT_PER_VERTEX_DATA, 0 },
		{ "BLENDINDICES", 0, DXGI_FORMAT_R32_UINT, 0, D3D10_APPEND_ALIGNED_ELEMENT,  D3D10_INPUT_PER_VERTEX_DATA, 0 },
    };

	if(!Shader_Unreal::compileUnrealShader(L"d3d10drv\\complexsurface.fx",macros,shaderFlags,layoutDesc,sizeof(layoutDesc)/sizeof(layoutDesc[0])))
		return false;
	
	variables.useTexturePass = effect->GetVariableByName("useTexturePass")->AsScalar();
	variables.textures = effect->GetVariableByName("textures")->AsShaderResource();
	
	return true;
}

void Shader_ComplexSurface::switchPass(TextureCache::TexturePass pass, BOOL val)
{
	if(useTexturePass[pass-1]!=val)	
	{
		D3D::render(); //draw geometry that might have used other textures
		enableChanged = true;
	}
	useTexturePass[pass-1]=val;
}



void Shader_ComplexSurface::apply() 
{
	//apply texture enabled array

	if(enableChanged)
	{
		variables.useTexturePass->SetBoolArray(this->useTexturePass,0,this->numBools);
		enableChanged=false;
	}
	Shader::apply();
}

void Shader_ComplexSurface::setTexture(int pass,ID3D10ShaderResourceView *texture) const
{
	if(pass==0)
		Shader_Unreal::setTexture(pass,texture);
	else
		variables.textures->SetResourceArray(&texture,pass-1,1);	
}