#pragma once

#include "shader_postprocess.h"
#include "texturecache.h"

class Shader_FinalPass : public Shader_Postprocess
{
private:
	struct 
	{
		ID3D10EffectScalarVariable* brightness;
	} variables;

	
public:	
	bool compile(const D3D10_SHADER_MACRO *macros, DWORD shaderFlags);
	Shader_FinalPass(ID3D10Device *device);
	bool createRenderTargetViews(ID3D10RenderTargetView *backbuffer, const DXGI_SWAP_CHAIN_DESC &swapChainDesc, int multiSampleCount);
	void releaseRenderTargetViews();
	void setBrightness(float brightness) const;
};